/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.item.ActivatableItem;
import de.dafuqs.spectrum.api.item.ArmorPiercingItem;
import de.dafuqs.spectrum.api.item.ExpandedStatTooltip;
import de.dafuqs.spectrum.api.item.Preenchanted;
import de.dafuqs.spectrum.api.item.SplitDamageItem;
import de.dafuqs.spectrum.entity.entity.BidentBaseEntity;
import de.dafuqs.spectrum.entity.entity.BidentEntity;
import de.dafuqs.spectrum.entity.entity.BidentMirrorImageEntity;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumToolMaterial;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class MalachiteBidentItem
extends class_1835
implements Preenchanted,
ExpandedStatTooltip,
ArmorPiercingItem {
    private final float armorPierce;
    private final float protPierce;

    public MalachiteBidentItem(class_1792.class_1793 settings, double attackSpeed, double damage, float armorPierce, float protPierce) {
        super(settings.method_57348(class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(field_8006, damage, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(field_8001, attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486()));
        this.armorPierce = armorPierce;
        this.protPierce = protPierce;
    }

    @Override
    public Map<class_5321<class_1887>, Integer> getDefaultEnchantments() {
        return Map.of(class_1893.field_9106, 6);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 handStack = user.method_5998(hand);
        if (handStack.method_7919() >= handStack.method_7936() - 1) {
            return class_1271.method_22431((Object)handStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)handStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int useTime = this.method_7881(stack, user) - remainingUseTicks;
            if (useTime >= 10) {
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                if (this.canStartRiptide(player, stack)) {
                    this.riptide(world, player, stack, this.getRiptideLevel((class_7225.class_7874)world.method_30349(), stack));
                } else if (!world.field_9236) {
                    stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)user.method_6058()));
                    this.throwBident(stack, (class_3218)world, player);
                }
            }
        }
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return SpectrumToolMaterial.MALACHITE.method_8023().method_8093(ingredient) || super.method_7878(stack, ingredient);
    }

    public int getRiptideLevel(class_7225.class_7874 lookup, class_1799 stack) {
        return SpectrumEnchantmentHelper.getLevel(lookup, (class_5321<class_1887>)class_1893.field_9104, stack);
    }

    protected void riptide(class_1937 world, class_1657 playerEntity, class_1799 stack, int riptideLevel) {
        this.yeetPlayer(playerEntity, riptideLevel);
        playerEntity.method_40126(20, (float)playerEntity.method_45325(class_5134.field_23721), stack);
        if (playerEntity.method_24828()) {
            playerEntity.method_5784(class_1313.field_6308, new class_243(0.0, 1.2, 0.0));
        }
        class_3414 soundEvent = riptideLevel >= 3 ? (class_3414)class_3417.field_14717.comp_349() : (riptideLevel == 2 ? (class_3414)class_3417.field_14806.comp_349() : (class_3414)class_3417.field_14606.comp_349());
        world.method_43129(null, (class_1297)playerEntity, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
    }

    protected void yeetPlayer(class_1657 playerEntity, float riptideLevel) {
        float f = playerEntity.method_36454();
        float g = playerEntity.method_36455();
        float h = -class_3532.method_15374((float)(f * ((float)Math.PI / 180))) * class_3532.method_15362((float)(g * ((float)Math.PI / 180)));
        float k = -class_3532.method_15374((float)(g * ((float)Math.PI / 180)));
        float l = class_3532.method_15362((float)(f * ((float)Math.PI / 180))) * class_3532.method_15362((float)(g * ((float)Math.PI / 180)));
        float m = class_3532.method_15355((float)(h * h + k * k + l * l));
        float n = 3.0f * ((1.0f + riptideLevel) / 4.0f);
        playerEntity.method_5762((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
    }

    protected void throwBident(class_1799 stack, class_3218 world, class_1657 playerEntity) {
        boolean mirrorImage = this.isThrownAsMirrorImage(stack, world, playerEntity);
        BidentBaseEntity bidentBaseEntity = mirrorImage ? new BidentMirrorImageEntity((class_1937)world) : new BidentEntity((class_1937)world);
        bidentBaseEntity.method_57313(stack);
        bidentBaseEntity.method_7432((class_1297)playerEntity);
        bidentBaseEntity.method_30634(playerEntity.method_23317(), playerEntity.method_23320() - 0.1, playerEntity.method_23321());
        bidentBaseEntity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, this.getThrowSpeed(stack), 1.0f);
        if (!mirrorImage && playerEntity.method_31549().field_7477) {
            bidentBaseEntity.field_7572 = class_1665.class_1666.field_7594;
        }
        world.method_8649((class_1297)bidentBaseEntity);
        class_3414 soundEvent = (class_3414)class_3417.field_15001.comp_349();
        if (mirrorImage) {
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, bidentBaseEntity.method_19538(), (class_2394)SpectrumParticleTypes.MIRROR_IMAGE, 8, class_243.field_1353, new class_243(0.2, 0.2, 0.2));
            bidentBaseEntity.field_7572 = class_1665.class_1666.field_7592;
            soundEvent = SpectrumSoundEvents.BIDENT_MIRROR_IMAGE_THROWN;
        } else if (playerEntity.method_31549().field_7477) {
            bidentBaseEntity.field_7572 = class_1665.class_1666.field_7594;
        }
        world.method_43129(null, (class_1297)bidentBaseEntity, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
        if (!playerEntity.method_31549().field_7477 && !mirrorImage) {
            playerEntity.method_31548().method_7378(stack);
        }
    }

    public void markDisabled(class_1799 stack, boolean disabled) {
        ActivatableItem.setActivated(stack, !disabled);
    }

    public boolean isDisabled(class_1799 stack) {
        return !ActivatableItem.isActivated(stack);
    }

    public boolean canBeDisabled() {
        return false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (this.isDisabled(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.bident.toolTip.disabled").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
        }
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (this.canBeDisabled() && clickType == class_5536.field_27014) {
            this.markDisabled(stack, !this.isDisabled(stack));
            return true;
        }
        return false;
    }

    public float getThrowSpeed(class_1799 stack) {
        return 3.0f;
    }

    public boolean canStartRiptide(class_1657 player, class_1799 stack) {
        return this.getRiptideLevel((class_7225.class_7874)player.method_37908().method_30349(), stack) > 0 && player.method_5721();
    }

    public boolean isThrownAsMirrorImage(class_1799 stack, class_3218 world, class_1657 player) {
        return false;
    }

    @Override
    public float getDefenseMultiplier(class_1309 target, class_1799 stack) {
        return 1.0f - this.armorPierce;
    }

    @Override
    public float getToughnessMultiplier(class_1309 target, class_1799 stack) {
        return 1.0f;
    }

    @Override
    public float getProtReduction(class_1309 target, class_1799 stack) {
        return this.protPierce;
    }

    @Override
    public SplitDamageItem.DamageComposition getDamageComposition(class_1309 attacker, class_1309 target, class_1799 stack, float damage) {
        SplitDamageItem.DamageComposition composition = new SplitDamageItem.DamageComposition();
        class_1282 source = composition.getPlayerOrEntity(attacker);
        SpectrumDamageTypes.wrapWithStackTracking(source, stack);
        composition.add(source, damage);
        return composition;
    }

    @Override
    public void expandTooltip(class_1799 stack, @Nullable class_1657 player, Consumer<class_2561> tooltip, class_1792.class_9635 context) {
        if (class_437.method_25442()) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"item.spectrum.bident.postToolTip.ap", (Object[])new Object[]{Float.valueOf(this.armorPierce * 100.0f)}).method_27692(class_124.field_1077));
            if (this.protPierce > 0.0f) {
                tooltip.accept((class_2561)class_2561.method_43469((String)"item.spectrum.bident.postToolTip.pp", (Object[])new Object[]{Float.valueOf(this.protPierce * 100.0f)}).method_27692(class_124.field_1077));
            }
            if (this.canBeDisabled()) {
                tooltip.accept((class_2561)class_2561.method_43471((String)"item.spectrum.bident.postToolTip.disable").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
            }
        } else {
            tooltip.accept((class_2561)class_2561.method_43471((String)"spectrum.tooltip.press_shift_for_more").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
        }
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9118) || enchantment.method_40225(class_1893.field_9123) || enchantment.method_40225(class_1893.field_9112) || enchantment.method_40225(class_1893.field_9110);
    }
}

