/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.item.AoEBreakingTool;
import de.dafuqs.spectrum.api.item.Preenchanted;
import de.dafuqs.spectrum.components.WorkstaffComponent;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.inventories.WorkstaffScreenHandler;
import de.dafuqs.spectrum.items.tools.MultiToolItem;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_9334;

public class WorkstaffItem
extends MultiToolItem
implements AoEBreakingTool,
Preenchanted {
    protected static final InkCost BASE_COST_PER_AOE_MINING_RANGE_INCREMENT = new InkCost(InkColors.WHITE, 3L);

    public WorkstaffItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_5715()) {
            if (user instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)user;
                serverPlayerEntity.method_17355(this.createScreenHandlerFactory(user.method_5998(hand)));
            }
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        int range = this.getAoERange(stack);
        if (range > 0) {
            int displayedRange = 1 + range + range;
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.workstaff.tooltip.mining_range", (Object[])new Object[]{displayedRange, displayedRange}).method_27692(class_124.field_1080));
        }
    }

    @Override
    public boolean canTill(class_1799 stack) {
        return ((WorkstaffComponent)stack.method_57825(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).canTill();
    }

    public class_3908 createScreenHandlerFactory(class_1799 itemStack) {
        return new class_747((syncId, inventory, player) -> new WorkstaffScreenHandler(syncId, inventory, itemStack), (class_2561)class_2561.method_43471((String)"item.spectrum.workstaff"));
    }

    @Override
    public boolean canUseAoE(class_1657 player, class_1799 stack) {
        int range = this.getAoERange(stack);
        if (range <= 0) {
            return true;
        }
        int costForRange = (int)Math.pow(BASE_COST_PER_AOE_MINING_RANGE_INCREMENT.cost(), range);
        return InkPowered.tryDrainEnergy(player, BASE_COST_PER_AOE_MINING_RANGE_INCREMENT.color(), (long)costForRange);
    }

    public static void applyToggle(class_1657 player, class_1799 stack, GUIToggle toggle) {
        switch (toggle.ordinal()) {
            case 3: {
                stack.method_57381(SpectrumDataComponentTypes.AOE);
                player.method_7353(toggle.getTriggerText(), true);
                break;
            }
            case 4: {
                stack.method_57379(SpectrumDataComponentTypes.AOE, (Object)1);
                player.method_7353(toggle.getTriggerText(), true);
                break;
            }
            case 5: {
                stack.method_57379(SpectrumDataComponentTypes.AOE, (Object)2);
                player.method_7353(toggle.getTriggerText(), true);
                break;
            }
            case 1: {
                WorkstaffItem.enchantAndRemoveOthers(player, stack, toggle.getTriggerText(), (class_5321<class_1887>)class_1893.field_9130);
                break;
            }
            case 0: {
                WorkstaffItem.enchantAndRemoveOthers(player, stack, toggle.getTriggerText(), (class_5321<class_1887>)class_1893.field_9099);
                break;
            }
            case 2: {
                WorkstaffItem.enchantAndRemoveOthers(player, stack, toggle.getTriggerText(), SpectrumEnchantments.RESONANCE);
                break;
            }
            case 6: {
                stack.method_57368(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(true, comp.canShoot(), comp.fortuneLevel()));
                player.method_7353(toggle.getTriggerText(), true);
                break;
            }
            case 7: {
                stack.method_57368(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(false, comp.canShoot(), comp.fortuneLevel()));
                player.method_7353(toggle.getTriggerText(), true);
                break;
            }
            case 8: {
                stack.method_57368(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(comp.canTill(), true, comp.fortuneLevel()));
                player.method_7353(toggle.getTriggerText(), true);
                break;
            }
            case 9: {
                stack.method_57368(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(comp.canTill(), false, comp.fortuneLevel()));
                player.method_7353(toggle.getTriggerText(), true);
            }
        }
    }

    private static void enchantAndRemoveOthers(class_1657 player, class_1799 stack, class_2561 message, class_5321<class_1887> enchantment) {
        class_5455 registryLookup = player.method_37908().method_30349();
        int existingLevel = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)registryLookup, enchantment, stack);
        if (existingLevel > 0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.workstaff.message.already_has_the_enchantment"), true);
            return;
        }
        int level = 1;
        if (enchantment == class_1893.field_9130) {
            level = ((WorkstaffComponent)stack.method_57825(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).fortuneLevel();
        } else {
            int fortuneLevel = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)registryLookup, (class_5321<class_1887>)class_1893.field_9130, stack);
            stack.method_57368(SpectrumDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(comp.canTill(), comp.canShoot(), Math.max(fortuneLevel, 1)));
        }
        class_1799 newStack = stack.method_7972();
        class_3545<class_1799, Integer> removeResult = SpectrumEnchantmentHelper.removeEnchantments((class_7225.class_7874)registryLookup, newStack, class_1893.field_9099, SpectrumEnchantments.RESONANCE, class_1893.field_9130);
        if ((Integer)removeResult.method_15441() == 0) {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                WorkstaffItem.triggerUnenchantedWorkstaffAdvancement(serverPlayerEntity);
            }
        } else {
            class_3545<Boolean, class_1799> addResult = SpectrumEnchantmentHelper.addOrUpgradeEnchantment((class_7225.class_7874)registryLookup, (class_1799)removeResult.method_15442(), enchantment, level, false, AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)SpectrumAdvancements.APPLY_CONFLICTING_ENCHANTMENTS));
            if (((Boolean)addResult.method_15442()).booleanValue()) {
                stack.method_57379(class_9334.field_49633, (Object)((class_1799)addResult.method_15441()).method_58657());
                player.method_7353(message, true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.workstaff.message.would_result_in_conflicting_enchantments"), true);
            }
        }
    }

    private static void triggerUnenchantedWorkstaffAdvancement(class_3222 player) {
        player.method_17356(SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 0.75f, 1.0f);
        Support.grantAdvancementCriterion(player, "lategame/trigger_unenchanted_workstaff", "code_triggered");
    }

    @Override
    public Map<class_5321<class_1887>, Integer> getDefaultEnchantments() {
        return Map.of(class_1893.field_9130, 4);
    }

    public static enum GUIToggle {
        SELECT_SILK_TOUCH("item.spectrum.workstaff.message.silk_touch"),
        SELECT_FORTUNE("item.spectrum.workstaff.message.fortune"),
        SELECT_RESONANCE("item.spectrum.workstaff.message.resonance"),
        SELECT_1x1("item.spectrum.workstaff.message.1x1"),
        SELECT_3x3("item.spectrum.workstaff.message.3x3"),
        SELECT_5x5("item.spectrum.workstaff.message.5x5"),
        ENABLE_RIGHT_CLICK_ACTIONS("item.spectrum.workstaff.message.enabled_right_click_actions"),
        DISABLE_RIGHT_CLICK_ACTIONS("item.spectrum.workstaff.message.disabled_right_click_actions"),
        ENABLE_PROJECTILES("item.spectrum.workstaff.message.enabled_projectiles"),
        DISABLE_PROJECTILES("item.spectrum.workstaff.message.disabled_projectiles");

        private final String triggerText;

        private GUIToggle(String triggerText) {
            this.triggerText = triggerText;
        }

        public class_2561 getTriggerText() {
            return class_2561.method_43471((String)this.triggerText);
        }
    }
}

