/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import dev.emi.trinkets.api.SlotReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5134;

public class AttackRingItem
extends SpectrumTrinketItem {
    public static final class_2960 ATTACK_RING_DAMAGE_ID = SpectrumCommon.locate("jeopardant");
    public static final String ATTACK_RING_DAMAGE_NAME = "spectrum:jeopardant";

    public AttackRingItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/jeopardant"));
    }

    public static double getAttackModifierForEntity(class_1309 entity) {
        if (entity == null) {
            return 0.0;
        }
        double mod = entity.method_6063() / (entity.method_6032() * entity.method_6032() + 1.0f);
        return Math.max(0.0, 1.0 + Math.log10(mod));
    }

    @Override
    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onUnequip(stack, slot, entity);
        if (entity.method_6127().method_45330(class_5134.field_23721, ATTACK_RING_DAMAGE_ID)) {
            Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
            map.put((Object)class_5134.field_23721, (Object)new class_1322(ATTACK_RING_DAMAGE_ID, AttackRingItem.getAttackModifierForEntity(entity), class_1322.class_1323.field_6331));
            entity.method_6127().method_59935(map);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        class_310 client = class_310.method_1551();
        long mod = Math.round(AttackRingItem.getAttackModifierForEntity((class_1309)client.field_1724) * 100.0);
        if (mod == 0L) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.jeopardant.tooltip.damage_zero"));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.jeopardant.tooltip.damage", (Object[])new Object[]{mod}));
        }
    }
}

