/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class GlowVisionGogglesItem
extends SpectrumTrinketItem
implements InkPowered {
    public static final InkCost INK_COST = new InkCost(InkColors.LIGHT_BLUE, 20L);
    public static final class_1799 ITEM_COST = new class_1799((class_1935)class_1802.field_28410, 1);

    public GlowVisionGogglesItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/glow_vision_goggles"));
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        class_1937 world = entity.method_37908();
        if (world != null && !world.field_9236 && world.method_8510() % 20L == 0L && entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            GlowVisionGogglesItem.giveEffect(world, serverPlayerEntity);
        }
    }

    @Override
    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onEquip(stack, slot, entity);
        class_1937 world = entity.method_37908();
        if (world != null && !world.field_9236 && entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            GlowVisionGogglesItem.giveEffect(world, serverPlayerEntity);
        }
    }

    private static void giveEffect(class_1937 world, class_3222 serverPlayerEntity) {
        class_1293 nightVisionInstance;
        int lightLevelAtPlayerPos = world.method_22339(serverPlayerEntity.method_24515());
        if (lightLevelAtPlayerPos < 7 && ((nightVisionInstance = serverPlayerEntity.method_6112(class_1294.field_5925)) == null || nightVisionInstance.method_5584() < 220)) {
            boolean paid = serverPlayerEntity.method_7337();
            if (!paid) {
                paid = InkPowered.tryDrainEnergy((class_1657)serverPlayerEntity, INK_COST);
            }
            if (!paid) {
                paid = InventoryHelper.removeFromInventoryWithRemainders((class_1657)serverPlayerEntity, ITEM_COST);
            }
            if (paid) {
                class_1293 newNightVisionInstance = new class_1293(class_1294.field_5925, 20 * SpectrumCommon.CONFIG.GlowVisionGogglesDuration, 0, true, true);
                serverPlayerEntity.method_6092(newNightVisionInstance);
                world.method_43129(null, (class_1297)serverPlayerEntity, SpectrumSoundEvents.ITEM_ARMOR_EQUIP_GLOW_VISION, class_3419.field_15248, 0.2f, 1.0f);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (InkPowered.canUseClient()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.glow_vision_goggles.tooltip_with_ink", (Object[])new Object[]{INK_COST.color().getColoredInkName()}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.glow_vision_goggles.tooltip"));
        }
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(INK_COST.color());
    }
}

