/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public abstract class SpectrumTrinketItem
extends TrinketItem {
    private final class_2960 unlockIdentifier;

    public SpectrumTrinketItem(class_1792.class_1793 settings, class_2960 unlockIdentifier) {
        super(settings);
        this.unlockIdentifier = unlockIdentifier;
    }

    public static boolean hasEquipped(Object entity, class_1792 item) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return SpectrumTrinketItem.hasEquipped(livingEntity, item);
        }
        return false;
    }

    public static boolean hasEquipped(class_1309 entity, class_1792 item) {
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
        return trinketComponent.map(component -> component.isEquipped(item)).orElse(false);
    }

    public static Optional<class_1799> getFirstEquipped(class_1309 entity, class_1792 item) {
        List stacks;
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (trinketComponent.isPresent() && !(stacks = ((TrinketComponent)trinketComponent.get()).getEquipped(item)).isEmpty()) {
            return Optional.of((class_1799)((class_3545)stacks.getFirst()).method_15441());
        }
        return Optional.empty();
    }

    public class_2960 getUnlockIdentifier() {
        return this.unlockIdentifier;
    }

    public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        class_1657 playerEntity;
        if (entity instanceof class_1657 && AdvancementHelper.hasAdvancement((class_1657)(playerEntity = (class_1657)entity), (class_2960)this.getUnlockIdentifier())) {
            if (!this.canEquipMoreThanOne() && SpectrumTrinketItem.hasEquipped(entity, (class_1792)this)) {
                return false;
            }
            return super.canEquip(stack, slot, entity);
        }
        return false;
    }

    public boolean canEquipMoreThanOne() {
        return false;
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onEquip(stack, slot, entity);
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            SpectrumAdvancementCriteria.TRINKET_CHANGE.trigger(serverPlayerEntity);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onUnequip(stack, slot, entity);
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            SpectrumAdvancementCriteria.TRINKET_CHANGE.trigger(serverPlayerEntity);
        }
    }

    public void onBreak(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onBreak(stack, slot, entity);
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            SpectrumAdvancementCriteria.TRINKET_CHANGE.trigger(serverPlayerEntity);
        }
    }
}

