/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import dev.emi.trinkets.api.SlotReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class WhispyCircletItem
extends SpectrumTrinketItem {
    private static final int TRIGGER_EVERY_X_TICKS = 100;
    private static final int NEGATIVE_EFFECT_SHORTENING_TICKS = 200;
    public static final class_2960 ATTRIBUTE_ID = SpectrumCommon.locate("whispy_circlet_mental_presence");

    public WhispyCircletItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/whispy_circlet"));
    }

    public static void removeSingleStatusEffect(@NotNull class_1309 entity, class_4081 category) {
        Collection currentEffects = entity.method_6026();
        if (currentEffects.isEmpty()) {
            return;
        }
        ArrayList<class_1293> negativeEffects = new ArrayList<class_1293>();
        for (class_1293 statusEffectInstance : currentEffects) {
            class_6880 effect = statusEffectInstance.method_5579();
            if (((class_1291)effect.comp_349()).method_18792() != category || effect.method_40220(SpectrumStatusEffectTags.SOPORIFIC) || effect.method_40220(SpectrumStatusEffectTags.BYPASSES_WHISPY_CIRCLET)) continue;
            negativeEffects.add(statusEffectInstance);
        }
        if (negativeEffects.isEmpty()) {
            return;
        }
        class_1937 world = entity.method_37908();
        int randomIndex = world.field_9229.method_43048(negativeEffects.size());
        entity.method_6016(((class_1293)negativeEffects.get(randomIndex)).method_5579());
    }

    public static void removeNegativeStatusEffects(@NotNull class_1309 entity) {
        HashSet<class_6880> effectsToRemove = new HashSet<class_6880>();
        for (class_1293 instance : entity.method_6026()) {
            if (!WhispyCircletItem.affects((class_6880<class_1291>)instance.method_5579())) continue;
            effectsToRemove.add(instance.method_5579());
        }
        for (class_6880 effect : effectsToRemove) {
            entity.method_6016(effect);
        }
    }

    public static void shortenNegativeStatusEffects(@NotNull class_1309 entity, int duration) {
        ArrayList<class_1293> newEffects = new ArrayList<class_1293>();
        ArrayList<class_6880> effectTypesToClear = new ArrayList<class_6880>();
        for (class_1293 instance : entity.method_6026()) {
            if (!WhispyCircletItem.affects((class_6880<class_1291>)instance.method_5579())) continue;
            int newDurationTicks = instance.method_5584() - duration;
            if (newDurationTicks > 0) {
                newEffects.add(new class_1293(instance.method_5579(), newDurationTicks, instance.method_5578(), instance.method_5591(), instance.method_5581(), instance.method_5592()));
            }
            if (effectTypesToClear.contains(instance.method_5579())) continue;
            effectTypesToClear.add(instance.method_5579());
        }
        for (class_6880 effectTypeToClear : effectTypesToClear) {
            entity.method_6016(effectTypeToClear);
        }
        for (class_1293 newEffect : newEffects) {
            entity.method_6092(newEffect);
        }
    }

    public static boolean affects(class_6880<class_1291> effect) {
        return ((class_1291)effect.comp_349()).method_18792() == class_4081.field_18272 && !effect.method_40220(SpectrumStatusEffectTags.BYPASSES_WHISPY_CIRCLET);
    }

    public static void preventPhantomSpawns(@NotNull class_3222 serverPlayerEntity) {
        serverPlayerEntity.method_14248().method_15023((class_1657)serverPlayerEntity, class_3468.field_15419.method_14956((Object)class_3468.field_15429), 0);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.whispy_circlet.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.whispy_circlet.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.whispy_circlet.tooltip3").method_27692(class_124.field_1080));
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        class_1937 world = entity.method_37908();
        if (!world.field_9236) {
            long time = entity.method_37908().method_8510();
            if (time % 100L == 0L) {
                WhispyCircletItem.shortenNegativeStatusEffects(entity, 200);
            }
            if (time % 10000L == 0L && entity instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)entity;
                WhispyCircletItem.preventPhantomSpawns(serverPlayerEntity);
            }
        }
    }

    public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
        modifiers.put(SpectrumEntityAttributes.MENTAL_PRESENCE, (Object)new class_1322(ATTRIBUTE_ID, 0.3, class_1322.class_1323.field_6328));
        return modifiers;
    }
}

