/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.particle.client;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.deeper_down.HowlingSpireEffects;
import de.dafuqs.spectrum.registries.SpectrumBiomes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class FallingAshParticle
extends class_4003 {
    private static final class_243 VERTICAL = new class_243(0.0, 1.0, 0.0);
    private static final float GRAVITY = 0.15f;
    private static double targetVelocity = 0.215;
    private static double ashScaleA = 20000.0;
    private static double ashScaleB = 2200.0;
    private static double ashScaleC = 200.0;
    private static class_2350.class_2351 primaryAxis;
    private static class_2350.class_2351 lastAxis;
    private final float rotateFactor;
    private final float lightness;
    private final int simInterval;
    private final int simOffset;
    private int slowTicks;
    private int axisTicks;
    private static final class_2338.class_2339 pos;

    protected FallingAshParticle(class_638 clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_4002 spriteProvider) {
        super(clientWorld, x, y, z);
        this.simInterval = SpectrumCommon.CONFIG.WindSimInterval;
        this.axisTicks = 0;
        this.method_18140(spriteProvider);
        this.field_3852 = velocityX;
        this.field_3869 = velocityY;
        this.field_3850 = velocityZ;
        class_5819 random = clientWorld.method_8409();
        this.field_3862 = true;
        this.field_3844 = 0.15f;
        this.field_3847 = 150 + random.method_43048(50);
        this.rotateFactor = ((float)Math.random() - 0.5f) * 0.002f;
        this.field_17867 = (float)(0.06 + random.method_43058() / 14.0);
        this.lightness = random.method_43057() * 0.6f + 0.4f;
        this.simOffset = random.method_43048(this.simInterval);
        this.method_3083(0.0f);
    }

    public void method_3070() {
        pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        class_243 camPos = class_310.method_1551().method_1560().method_19538();
        double distance = Math.sqrt(camPos.method_1028(this.field_3874, this.field_3854, this.field_3871));
        if (distance > (double)(HowlingSpireEffects.getRenderRadius() - 1)) {
            this.method_3085();
            return;
        }
        this.field_3857 = this.field_3839;
        boolean water = !this.field_3851.method_8316((class_2338)pos).method_15769();
        long time = this.field_3851.method_8510() % 432000L;
        if (this.field_3866 + 2 < this.field_3847 && this.field_3851.method_23753((class_2338)pos).method_40225(SpectrumBiomes.HOWLING_SPIRES)) {
            ++this.field_3866;
        }
        if (lastAxis != primaryAxis) {
            lastAxis = primaryAxis;
            this.axisTicks = 0;
        }
        switch (primaryAxis) {
            case field_11048: {
                this.field_3852 = class_3532.method_15390((double)this.field_3852, (double)this.adjustVelocity(this.field_3852, water), (double)((float)this.axisTicks / 20.0f));
                this.field_3850 = class_3532.method_15390((double)this.field_3850, (double)FallingAshParticle.getNonPrimaryVelocity(time), (double)((float)this.axisTicks / 20.0f));
                break;
            }
            case field_11051: {
                this.field_3850 = class_3532.method_15390((double)this.field_3850, (double)this.adjustVelocity(this.field_3850, water), (double)((float)this.axisTicks / 20.0f));
                this.field_3852 = class_3532.method_15390((double)this.field_3852, (double)FallingAshParticle.getNonPrimaryVelocity(time), (double)((float)this.axisTicks / 20.0f));
            }
        }
        if (this.axisTicks < 20) {
            ++this.axisTicks;
        }
        if (Math.abs(this.field_3852) + Math.abs(this.field_3850) < 0.1) {
            if (this.slowTicks < 20) {
                ++this.slowTicks;
            }
        } else {
            this.slowTicks = 0;
        }
        if (!this.field_3845 && !water) {
            this.field_3839 += (float)(Math.PI * Math.sin(this.rotateFactor * (float)this.field_3866) / 2.0);
            if (this.verifySimConfig(time)) {
                this.adjustGravityForLift();
            }
        } else if (water) {
            this.field_3869 /= 4.0;
            this.field_3852 /= 4.0;
            this.field_3850 /= 4.0;
            this.field_3844 = 0.0f;
        } else {
            this.field_3844 = 0.15f;
        }
        this.adjustAlpha(water);
        if (this.verifySimConfig(time) && Math.abs(this.field_3852) + Math.abs(this.field_3850) > 0.125) {
            this.applyAirflowTransforms();
        }
        super.method_3070();
    }

    private boolean verifySimConfig(long time) {
        return SpectrumCommon.CONFIG.WindSim && (time + (long)this.simOffset) % (long)this.simInterval == 0L;
    }

    private void adjustGravityForLift() {
        float height;
        boolean groundFound = false;
        for (height = 0.0f; height < 20.0f; height += 1.0f) {
            pos.method_10098(class_2350.field_11033);
            if (!this.field_3851.method_8316((class_2338)pos).method_15769()) {
                this.field_3844 = 0.0f;
                return;
            }
            if (!this.field_3851.method_8320((class_2338)pos).method_26206((class_1922)this.field_3851, (class_2338)pos, class_2350.field_11036)) continue;
            groundFound = true;
            break;
        }
        height += (float)(this.field_3854 - (double)((int)this.field_3854));
        if (!groundFound) {
            this.field_3844 = 0.3f * (1.0f + (1.0f - this.lightness));
            return;
        }
        float heightFactor = height / 14.0f;
        if (height < 4.0f) {
            this.field_3844 = 0.15f - 0.15f * (1.0f - heightFactor * 2.0f) * 2.0f * this.lightness;
            return;
        }
        if (height > 14.0f) {
            this.field_3844 = 0.15f * (1.0f - (height - 14.0f) / 7.0f) * 0.225f;
            return;
        }
        this.field_3844 = 0.15f * heightFactor;
    }

    private void applyAirflowTransforms() {
        class_243 velocity = new class_243(this.field_3852, this.field_3869, this.field_3850);
        class_243 direction = velocity.method_1029();
        class_243 movementNormal = direction.method_1036(VERTICAL);
        for (int i = 0; i <= 6; ++i) {
            float deflection = -0.0125f * (1.0f - (float)i / 24.0f) * this.lightness * (float)this.simInterval;
            class_243 shift = velocity.method_1021((double)i).method_1031(this.field_3874, this.field_3854, this.field_3871);
            int maxDist = 6 - i;
            for (int orthogonal = 1; orthogonal <= maxDist; ++orthogonal) {
                class_243 collisionDirection;
                class_243 leftShift = movementNormal.method_1021((double)orthogonal).method_1019(shift);
                class_243 rightShift = movementNormal.method_1021((double)(-orthogonal)).method_1019(shift);
                class_2338 leftPos = new class_2338((int)leftShift.field_1352, (int)leftShift.field_1351, (int)leftShift.field_1350);
                class_2338 rightPos = new class_2338((int)rightShift.field_1352, (int)rightShift.field_1351, (int)rightShift.field_1350);
                if (this.field_3851.method_8320(leftPos).method_26212((class_1922)this.field_3851, leftPos)) {
                    collisionDirection = leftShift.method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029();
                    this.field_3852 += collisionDirection.field_1352 * (double)deflection;
                    this.field_3850 += collisionDirection.field_1350 * (double)deflection;
                }
                if (!this.field_3851.method_8320(rightPos).method_26212((class_1922)this.field_3851, rightPos)) continue;
                collisionDirection = rightShift.method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029();
                this.field_3852 += collisionDirection.field_1352 * (double)deflection;
                this.field_3850 += collisionDirection.field_1350 * (double)deflection;
            }
        }
    }

    private static double getNonPrimaryVelocity(long time) {
        double scale = Math.sin((double)time / ashScaleA + ashScaleB);
        scale *= Math.cos((double)time / ashScaleB + ashScaleC) / 2.0;
        scale *= Math.cos((double)time / ashScaleC + ashScaleA) / 4.0;
        return scale *= 2.0;
    }

    private void adjustAlpha(boolean water) {
        if (this.field_3866 <= 20) {
            this.field_3841 = class_3532.method_15363((float)((float)this.field_3866 / 20.0f), (float)0.0f, (float)1.0f);
            return;
        }
        float ageFade = class_3532.method_15363((float)((float)Math.min(this.field_3847 - this.field_3866, 40) / 40.0f), (float)0.0f, (float)1.0f);
        this.field_3841 = ageFade < 1.0f ? Math.min(this.field_3841, ageFade) : (this.field_3845 || this.slowTicks == 20 ? class_3532.method_15363((float)(this.field_3841 - 0.02f), (float)0.0f, (float)1.0f) : (water ? class_3532.method_15363((float)(this.field_3841 - 0.02f), (float)0.5f, (float)1.0f) : class_3532.method_15363((float)(this.field_3841 + 0.05f), (float)0.0f, (float)1.0f)));
        if (this.field_3841 < 0.01f) {
            this.method_3085();
        }
    }

    private double adjustVelocity(double velocity, boolean water) {
        if (water) {
            return velocity / 1.5;
        }
        if (velocity != targetVelocity && velocity >= targetVelocity - 0.15 && velocity <= targetVelocity + 0.15) {
            velocity = targetVelocity;
        } else if (velocity > targetVelocity) {
            velocity -= 0.125;
        } else if (velocity < targetVelocity) {
            velocity += 0.0334;
        }
        return velocity;
    }

    public static void setTargetVelocity(double targetVelocity) {
        FallingAshParticle.targetVelocity = targetVelocity;
    }

    public static void setPrimaryAxis(class_2350.class_2351 primaryAxis) {
        FallingAshParticle.primaryAxis = primaryAxis;
    }

    public static void setAshScaleA(double ashScaleA) {
        FallingAshParticle.ashScaleA = ashScaleA;
    }

    public static void setAshScaleB(double ashScaleB) {
        FallingAshParticle.ashScaleB = ashScaleB;
    }

    public static void setAshScaleC(double ashScaleC) {
        FallingAshParticle.ashScaleC = ashScaleC;
    }

    public int method_3068(float tint) {
        return 0xF000F0;
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    static {
        lastAxis = primaryAxis = class_2350.class_2351.field_11048;
        pos = new class_2338.class_2339();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new FallingAshParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

