/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.particle.client;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.particle.client.TransmissionParticle;
import de.dafuqs.spectrum.particle.render.EarlyRenderingParticle;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5707;
import net.minecraft.class_5716;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class PastelTransmissionParticle
extends TransmissionParticle
implements EarlyRenderingParticle {
    private final class_918 itemRenderer;
    private final List<class_243> travelPositions;
    private final class_1799 itemStack;
    private final class_2394 particleEffect;

    public PastelTransmissionParticle(class_918 itemRenderer, class_638 world, double x, double y, double z, List<class_2338> travelPositions, class_1799 stack, int travelTime, int networkColor) {
        super(world, x, y, z, (class_5716)new class_5707(travelPositions.get(travelPositions.size() - 1)), travelTime);
        this.itemRenderer = itemRenderer;
        this.itemStack = stack;
        this.field_17867 = 0.25f;
        this.particleEffect = new class_2390(SpectrumColorHelper.colorIntToVec(networkColor), 0.8f);
        this.travelPositions = new ArrayList<class_243>();
        for (class_2338 p : travelPositions) {
            this.travelPositions.add(class_243.method_24953((class_2382)p));
        }
        class_243 startPos = this.travelPositions.get(0);
        world.method_8486(startPos.method_10216(), startPos.method_10214() + 0.25, startPos.method_10215(), class_3417.field_15197, class_3419.field_15245, 0.15f * SpectrumCommon.CONFIG.BlockSoundVolume + world.field_9229.method_43057() / 10.0f, 0.8f + world.field_9229.method_43057() * 0.3f, true);
        world.method_8406((class_2394)class_2398.field_11241, startPos.method_10216(), startPos.method_10214() + 0.25, startPos.method_10215(), 0.0, 0.0, 0.0);
    }

    @Override
    public void method_3070() {
        ++this.field_3866;
        int vertexCount = this.travelPositions.size() - 1;
        float travelPercent = (float)this.field_3866 / (float)this.field_3847;
        if (travelPercent >= 1.0f) {
            class_243 destination = this.travelPositions.get(vertexCount);
            this.field_3851.method_8486(destination.method_10216(), destination.method_10214() + 0.25, destination.method_10215(), class_3417.field_15197, class_3419.field_15245, 0.1f * SpectrumCommon.CONFIG.BlockSoundVolume + this.field_3840.method_43057() / 10.0f, 0.6f + this.field_3851.field_9229.method_43057() * 0.3f, true);
            this.field_3851.method_8406((class_2394)class_2398.field_11241, destination.method_10216(), destination.method_10214() + 0.25, destination.method_10215(), 0.0, 0.0, 0.0);
            this.method_3085();
            return;
        }
        float progress = travelPercent * (float)vertexCount;
        int startNodeID = (int)progress;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        class_243 source = this.travelPositions.get(startNodeID);
        class_243 destination = this.travelPositions.get(startNodeID + 1);
        float nodeProgress = progress % 1.0f;
        this.field_3874 = class_3532.method_16436((double)nodeProgress, (double)source.field_1352, (double)destination.field_1352);
        this.field_3854 = class_3532.method_16436((double)nodeProgress, (double)source.field_1351, (double)destination.field_1351);
        this.field_3871 = class_3532.method_16436((double)nodeProgress, (double)source.field_1350, (double)destination.field_1350);
        if (SpectrumCommon.CONFIG.PastelNetworkParticles && this.field_3866 % 2 == 0) {
            this.field_3851.method_8406(this.particleEffect, this.field_3874 + this.field_3840.method_43058() * 0.4 - 0.2, this.field_3854 + this.field_3840.method_43058() * 0.4 - 0.2, this.field_3871 + this.field_3840.method_43058() * 0.4 - 0.2, this.field_3840.method_43058() * 0.4 - 0.2, this.field_3840.method_43058() * 0.4 - 0.2, this.field_3840.method_43058() * 0.4 - 0.2);
        }
    }

    @Override
    public void renderAsEntity(class_4587 poseStack, class_4597 vertexConsumers, class_4184 camera, float tickDelta) {
        class_243 cameraPos = camera.method_19326();
        float x = (float)class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874);
        float y = (float)class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854);
        float z = (float)class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871);
        poseStack.method_22903();
        poseStack.method_22904((double)x - cameraPos.field_1352, (double)y - cameraPos.field_1351, (double)z - cameraPos.field_1350);
        int light = this.method_3068(tickDelta);
        poseStack.method_22907(camera.method_23767());
        poseStack.method_22905(0.65f, 0.65f, 0.65f);
        poseStack.method_22904(0.0, -0.15, 0.0);
        this.itemRenderer.method_23178(this.itemStack, class_811.field_4318, light, class_4608.field_21444, poseStack, vertexConsumers, (class_1937)this.field_3851, 0);
        poseStack.method_22909();
    }
}

