/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.blocks.potion_workshop.PotionWorkshopBlockEntity;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

public class PotionWorkshopBrewingCriterion
extends class_4558<Conditions> {
    public static final class_2960 ID = SpectrumCommon.locate("potion_workshop_brewing");

    public void trigger(class_3222 player, class_1799 itemStack, int brewedCount, PotionWorkshopBlockEntity potionWorkshop) {
        ArrayList<class_1799> reagents = new ArrayList<class_1799>();
        for (int i : PotionWorkshopBlockEntity.REAGENT_SLOTS) {
            reagents.add(potionWorkshop.method_5438(i));
        }
        this.method_22510(player, conditions -> {
            List effects;
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof InkPoweredPotionFillable) {
                InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)patt0$temp;
                effects = inkPoweredPotionFillable.getVanillaEffects(itemStack);
            } else {
                class_1844 potionComponent = (class_1844)itemStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
                effects = potionComponent.comp_2380();
            }
            int highestAmplifier = 0;
            int longestDuration = 0;
            for (class_1293 instance : effects) {
                if (instance.method_5578() > highestAmplifier) {
                    highestAmplifier = instance.method_5578();
                }
                if (instance.method_5584() <= longestDuration) continue;
                longestDuration = instance.method_5584();
            }
            ArrayList<class_1291> uniqueEffects = new ArrayList<class_1291>();
            for (class_1293 instance : effects) {
                if (uniqueEffects.contains(instance.method_5579().comp_349())) continue;
                uniqueEffects.add((class_1291)instance.method_5579().comp_349());
            }
            return conditions.matches(itemStack, effects, brewedCount, highestAmplifier, longestDuration, effects.size(), uniqueEffects.size(), reagents);
        });
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final class_2073 itemPredicate;
        private final class_2073 reagentPredicate;
        private final class_2102 statusEffectsPredicate;
        private final class_2096.class_2100 brewedCountRange;
        private final class_2096.class_2100 maxAmplifierRange;
        private final class_2096.class_2100 maxDurationRange;
        private final class_2096.class_2100 effectCountRange;
        private final class_2096.class_2100 uniqueEffectCountRange;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5258.field_47234.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_2073.field_45754.optionalFieldOf("item", (Object)class_2073.class_2074.method_8973().method_8976()).forGetter(Conditions::itemPredicate), (App)class_2073.field_45754.optionalFieldOf("reagent", (Object)class_2073.class_2074.method_8973().method_8976()).forGetter(Conditions::itemPredicate), (App)class_2102.field_45764.optionalFieldOf("effects", (Object)new class_2102(Map.of())).forGetter(Conditions::statusEffectsPredicate), (App)class_2096.class_2100.field_45763.optionalFieldOf("brewed_count", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::brewedCountRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("highest_amplifier", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::maxAmplifierRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("longest_duration", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::maxDurationRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("effect_count", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::effectCountRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("unique_effect_count", (Object)class_2096.class_2100.field_9708).forGetter(Conditions::uniqueEffectCountRange)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, class_2073 itemPredicate, class_2073 reagentPredicate, class_2102 statusEffectsPredicate, class_2096.class_2100 brewedCountRange, class_2096.class_2100 maxAmplifierRange, class_2096.class_2100 maxDurationRange, class_2096.class_2100 effectCountRange, class_2096.class_2100 uniqueEffectCountRange) {
            this.player = player;
            this.itemPredicate = itemPredicate;
            this.reagentPredicate = reagentPredicate;
            this.statusEffectsPredicate = statusEffectsPredicate;
            this.brewedCountRange = brewedCountRange;
            this.maxAmplifierRange = maxAmplifierRange;
            this.maxDurationRange = maxDurationRange;
            this.effectCountRange = effectCountRange;
            this.uniqueEffectCountRange = uniqueEffectCountRange;
        }

        public boolean matches(class_1799 stack, List<class_1293> effects, int brewedCount, int maxAmplifier, int maxDuration, int effectCount, int uniqueEffectCount, List<class_1799> reagents) {
            if (this.brewedCountRange.method_9054(brewedCount) && this.maxAmplifierRange.method_9054(maxAmplifier) && this.maxDurationRange.method_9054(maxDuration) && this.effectCountRange.method_9054(effectCount) && this.uniqueEffectCountRange.method_9054(uniqueEffectCount) && this.itemPredicate.method_8970(stack)) {
                boolean anyReagentMatched = false;
                for (class_1799 reagent : reagents) {
                    if (!this.reagentPredicate.method_8970(reagent)) continue;
                    anyReagentMatched = true;
                    break;
                }
                if (!anyReagentMatched) {
                    return false;
                }
                HashMap<class_6880, class_1293> effectMap = new HashMap<class_6880, class_1293>();
                for (class_1293 instance : effects) {
                    if (effectMap.containsKey(instance.method_5579())) continue;
                    effectMap.put(instance.method_5579(), instance);
                }
                return this.statusEffectsPredicate.method_9063(effectMap);
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;itemPredicate;reagentPredicate;statusEffectsPredicate;brewedCountRange;maxAmplifierRange;maxDurationRange;effectCountRange;uniqueEffectCountRange", "player", "itemPredicate", "reagentPredicate", "statusEffectsPredicate", "brewedCountRange", "maxAmplifierRange", "maxDurationRange", "effectCountRange", "uniqueEffectCountRange"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;itemPredicate;reagentPredicate;statusEffectsPredicate;brewedCountRange;maxAmplifierRange;maxDurationRange;effectCountRange;uniqueEffectCountRange", "player", "itemPredicate", "reagentPredicate", "statusEffectsPredicate", "brewedCountRange", "maxAmplifierRange", "maxDurationRange", "effectCountRange", "uniqueEffectCountRange"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;itemPredicate;reagentPredicate;statusEffectsPredicate;brewedCountRange;maxAmplifierRange;maxDurationRange;effectCountRange;uniqueEffectCountRange", "player", "itemPredicate", "reagentPredicate", "statusEffectsPredicate", "brewedCountRange", "maxAmplifierRange", "maxDurationRange", "effectCountRange", "uniqueEffectCountRange"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public class_2073 itemPredicate() {
            return this.itemPredicate;
        }

        public class_2073 reagentPredicate() {
            return this.reagentPredicate;
        }

        public class_2102 statusEffectsPredicate() {
            return this.statusEffectsPredicate;
        }

        public class_2096.class_2100 brewedCountRange() {
            return this.brewedCountRange;
        }

        public class_2096.class_2100 maxAmplifierRange() {
            return this.maxAmplifierRange;
        }

        public class_2096.class_2100 maxDurationRange() {
            return this.maxDurationRange;
        }

        public class_2096.class_2100 effectCountRange() {
            return this.effectCountRange;
        }

        public class_2096.class_2100 uniqueEffectCountRange() {
            return this.uniqueEffectCountRange;
        }
    }
}

