/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.entity.entity.SpectrumFishingBobberEntity;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4551;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;

public class SpectrumFishingRodHookedCriterion
extends class_4558<Conditions> {
    public static final class_2960 ID = SpectrumCommon.locate("fishing_rod_hooked");

    public void trigger(class_3222 player, class_1799 rod, SpectrumFishingBobberEntity bobber, class_1297 fishedEntity, Collection<class_1799> fishingLoots) {
        class_47 bobberContext = class_2048.method_27802((class_3222)player, (class_1297)bobber);
        class_47 hookedEntityContext = bobber.getHookedEntity() == null ? null : class_2048.method_27802((class_3222)player, (class_1297)bobber.getHookedEntity());
        class_47 fishedEntityContext = fishedEntity == null ? null : class_2048.method_27802((class_3222)player, (class_1297)fishedEntity);
        this.method_22510(player, conditions -> conditions.matches(rod, bobberContext, hookedEntityContext, fishedEntityContext, fishingLoots, (class_3218)bobber.method_37908(), bobber.method_24515()));
        class_47 hookedEntityOrBobberContext = class_2048.method_27802((class_3222)player, (class_1297)(bobber.getHookedEntity() != null ? bobber.getHookedEntity() : bobber));
        class_174.field_1203.method_22510(player, conditions -> conditions.method_27810(rod, hookedEntityOrBobberContext, fishingLoots));
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2073> rod;
        private final Optional<class_5258> bobber;
        private final Optional<class_5258> hookedEntity;
        private final Optional<class_5258> fishedEntity;
        private final Optional<class_2073> caughtItem;
        private final Optional<class_4551> fluidPredicate;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5258.field_47234.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_2073.field_45754.optionalFieldOf("rod").forGetter(Conditions::rod), (App)class_5258.field_47234.optionalFieldOf("bobber").forGetter(Conditions::bobber), (App)class_5258.field_47234.optionalFieldOf("fishing").forGetter(Conditions::hookedEntity), (App)class_2048.field_47250.optionalFieldOf("fished_entity").forGetter(Conditions::fishedEntity), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(Conditions::caughtItem), (App)class_4551.field_45753.optionalFieldOf("fluid").forGetter(Conditions::fluidPredicate)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, Optional<class_2073> rod, Optional<class_5258> bobber, Optional<class_5258> hookedEntity, Optional<class_5258> fishedEntity, Optional<class_2073> caughtItem, Optional<class_4551> fluidPredicate) {
            this.player = player;
            this.rod = rod;
            this.bobber = bobber;
            this.hookedEntity = hookedEntity;
            this.fishedEntity = fishedEntity;
            this.caughtItem = caughtItem;
            this.fluidPredicate = fluidPredicate;
        }

        public boolean matches(class_1799 rod, class_47 bobberContext, class_47 hookedEntityContext, class_47 fishedEntityContext, Collection<class_1799> fishingLoots, class_3218 world, class_2338 blockPos) {
            if (this.rod.isPresent() && !this.rod.get().method_8970(rod)) {
                return false;
            }
            if (this.bobber.isPresent() && !this.bobber.get().method_27806(bobberContext)) {
                return false;
            }
            if (this.fluidPredicate.isPresent() && !this.fluidPredicate.get().method_22475(world, blockPos)) {
                return false;
            }
            if (this.fishedEntity.isPresent() && (fishedEntityContext == null || !this.fishedEntity.get().method_27806(fishedEntityContext))) {
                return false;
            }
            if (this.hookedEntity.isPresent() && (hookedEntityContext == null || !this.hookedEntity.get().method_27806(hookedEntityContext))) {
                return false;
            }
            if (this.caughtItem.isPresent()) {
                class_1297 entity;
                if (hookedEntityContext != null && (entity = (class_1297)hookedEntityContext.method_296(class_181.field_1226)) instanceof class_1542) {
                    class_1542 itemEntity = (class_1542)entity;
                    if (this.caughtItem.get().method_8970(itemEntity.method_6983())) {
                        return true;
                    }
                }
                for (class_1799 itemStack : fishingLoots) {
                    if (!this.caughtItem.get().method_8970(itemStack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;rod;bobber;hookedEntity;fishedEntity;caughtItem;fluidPredicate", "player", "rod", "bobber", "hookedEntity", "fishedEntity", "caughtItem", "fluidPredicate"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;rod;bobber;hookedEntity;fishedEntity;caughtItem;fluidPredicate", "player", "rod", "bobber", "hookedEntity", "fishedEntity", "caughtItem", "fluidPredicate"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;rod;bobber;hookedEntity;fishedEntity;caughtItem;fluidPredicate", "player", "rod", "bobber", "hookedEntity", "fishedEntity", "caughtItem", "fluidPredicate"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2073> rod() {
            return this.rod;
        }

        public Optional<class_5258> bobber() {
            return this.bobber;
        }

        public Optional<class_5258> hookedEntity() {
            return this.hookedEntity;
        }

        public Optional<class_5258> fishedEntity() {
            return this.fishedEntity;
        }

        public Optional<class_2073> caughtItem() {
            return this.caughtItem;
        }

        public Optional<class_4551> fluidPredicate() {
            return this.fluidPredicate;
        }
    }
}

