/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.cinderhearth;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9696;

public class CinderhearthRecipe
extends GatedStackSpectrumRecipe<class_9696> {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/blocks/cinderhearth");
    protected final IngredientStack ingredient;
    protected final int time;
    protected final float experience;
    protected final List<class_3545<class_1799, Float>> resultsWithChance;

    public CinderhearthRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, IngredientStack ingredient, int time, float experience, List<class_3545<class_1799, Float>> resultsWithChance) {
        super(group, secret, requiredAdvancementIdentifier);
        this.ingredient = ingredient;
        this.time = time;
        this.experience = experience;
        this.resultsWithChance = resultsWithChance;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean matches(class_9696 input, class_1937 world) {
        return this.ingredient.test(input.method_59984(0));
    }

    @Deprecated
    public class_1799 assemble(class_9696 input, class_7225.class_7874 registryLookup) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registryLookup) {
        return (class_1799)this.resultsWithChance.getFirst().method_15442();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.CINDERHEARTH);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.CINDERHEARTH_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.CINDERHEARTH;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "cinderhearth";
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return List.of(this.ingredient);
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCraftingTime() {
        return this.time;
    }

    public List<class_1799> getRolledOutputs(class_5819 random, float yieldMod) {
        ArrayList<class_1799> output = new ArrayList<class_1799>();
        for (class_3545<class_1799, Float> possibleOutput : this.resultsWithChance) {
            float chance = ((Float)possibleOutput.method_15441()).floatValue();
            if (!((double)chance >= 1.0) && !(random.method_43057() < chance * yieldMod)) continue;
            class_1799 currentOutputStack = (class_1799)possibleOutput.method_15442();
            if (yieldMod > 1.0f) {
                int count;
                for (int totalCount = Support.getIntFromDecimalWithChance((float)currentOutputStack.method_7947() * yieldMod, random); totalCount > 0; totalCount -= count) {
                    count = Math.min(totalCount, currentOutputStack.method_7914());
                    class_1799 outputStack = currentOutputStack.method_7972();
                    outputStack.method_7939(count);
                    output.add(outputStack);
                }
                continue;
            }
            output.add(currentOutputStack.method_7972());
        }
        return output;
    }

    public List<class_1799> getPossibleOutputs() {
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (class_3545<class_1799, Float> pair : this.resultsWithChance) {
            outputs.add((class_1799)pair.method_15442());
        }
        return outputs;
    }

    public List<class_3545<class_1799, Float>> getResultsWithChance() {
        return this.resultsWithChance;
    }

    public static class Serializer
    implements class_1865<CinderhearthRecipe> {
        public static final MapCodec<CinderhearthRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.Serializer.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.withAlternative((Codec)class_1799.field_24671.xmap(stack -> new class_3545(stack, (Object)Float.valueOf(1.0f)), class_3545::method_15442), (Codec)CodecHelper.mapPair(class_1799.field_24671.fieldOf("result"), Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f))).codec()).listOf().fieldOf("results").forGetter(recipe -> recipe.resultsWithChance)).apply((Applicative)i, CinderhearthRecipe::new));
        public static final class_9139<class_9129, CinderhearthRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, recipe -> recipe.group, class_9135.field_48547, recipe -> recipe.secret, class_9135.method_56382((class_9139)class_2960.field_48267), recipe -> recipe.requiredAdvancementIdentifier, IngredientStack.Serializer.PACKET_CODEC, recipe -> recipe.ingredient, class_9135.field_48550, recipe -> recipe.time, class_9135.field_48552, recipe -> Float.valueOf(recipe.experience), PacketCodecHelper.pair(class_1799.field_48349, class_9135.field_48552).method_56433(class_9135.method_56363()), recipe -> recipe.resultsWithChance, CinderhearthRecipe::new);

        public MapCodec<CinderhearthRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CinderhearthRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

