/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.crafting.dynamic;

import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.blocks.present.PresentBlockItem;
import de.dafuqs.spectrum.items.PigmentItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapPresentRecipe
extends class_1852 {
    public WrapPresentRecipe() {
        super(class_7710.field_40251);
    }

    public class_2371<class_1856> method_8117() {
        class_2371 list = class_2371.method_10213((int)1, (Object)class_1856.field_9017);
        list.set(0, (Object)class_1856.method_8101((class_1799[])new class_1799[]{SpectrumBlocks.PRESENT.method_8389().method_7854()}));
        return list;
    }

    public class_1799 method_8110(class_7225.class_7874 registryLookup) {
        class_1799 stack = SpectrumBlocks.PRESENT.method_8389().method_7854();
        PresentBlockItem.wrap(stack, PresentBlock.WrappingPaper.RED, Map.of());
        return stack;
    }

    public boolean matches(@NotNull class_9694 input, class_1937 world) {
        boolean presentItemFound = false;
        boolean wrappingItemFound = false;
        for (int j = 0; j < input.method_59983(); ++j) {
            class_1799 itemStack = input.method_59984(j);
            if (itemStack.method_7960()) continue;
            if (itemStack.method_7909() instanceof PresentBlockItem) {
                if (presentItemFound || PresentBlockItem.isWrapped(itemStack)) {
                    return false;
                }
                presentItemFound = true;
                continue;
            }
            if (!wrappingItemFound && this.getPresentVariantForStack(itemStack) != null) {
                wrappingItemFound = true;
                continue;
            }
            if (itemStack.method_7909() instanceof PigmentItem) continue;
            return false;
        }
        return presentItemFound;
    }

    public class_1799 assemble(@NotNull class_9694 input, class_7225.class_7874 registryLookup) {
        class_1799 presentStack = class_1799.field_8037;
        PresentBlock.WrappingPaper wrappingPaper = PresentBlock.WrappingPaper.RED;
        HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
        for (int j = 0; j < input.method_59983(); ++j) {
            class_1799 stack = input.method_59984(j);
            if (stack.method_7909() instanceof PresentBlockItem) {
                presentStack = stack.method_7972();
            } else {
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof PigmentItem) {
                    PigmentItem pigmentItem = (PigmentItem)class_17922;
                    int color = pigmentItem.getInkColor().getColorInt();
                    if (colors.containsKey(color)) {
                        colors.put(color, (Integer)colors.get(color) + 1);
                    } else {
                        colors.put(color, 1);
                    }
                }
            }
            PresentBlock.WrappingPaper stackWrappingPaper = this.getPresentVariantForStack(stack);
            if (stackWrappingPaper == null) continue;
            wrappingPaper = stackWrappingPaper;
        }
        if (!presentStack.method_7960()) {
            PresentBlockItem.wrap(presentStack, wrappingPaper, colors);
        }
        return presentStack;
    }

    @Nullable
    public PresentBlock.WrappingPaper getPresentVariantForStack(@NotNull class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8264) {
            return PresentBlock.WrappingPaper.RED;
        }
        if (item == class_1802.field_8345) {
            return PresentBlock.WrappingPaper.BLUE;
        }
        if (item == class_1802.field_8632) {
            return PresentBlock.WrappingPaper.CYAN;
        }
        if (item == class_1802.field_8408) {
            return PresentBlock.WrappingPaper.GREEN;
        }
        if (item == class_1802.field_8296) {
            return PresentBlock.WrappingPaper.PURPLE;
        }
        if (item == class_1802.field_17534) {
            return PresentBlock.WrappingPaper.CAKE;
        }
        if (stack.method_31573(class_3489.field_20344)) {
            return PresentBlock.WrappingPaper.STRIPED;
        }
        if (item == class_1802.field_8450) {
            return PresentBlock.WrappingPaper.STARRY;
        }
        if (item == class_1802.field_8543) {
            return PresentBlock.WrappingPaper.WINTER;
        }
        if (item == class_1802.field_28652) {
            return PresentBlock.WrappingPaper.PRIDE;
        }
        return null;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 1;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.WRAP_PRESENT_SERIALIZER;
    }
}

