/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchanter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;

public class EnchanterRecipe
extends GatedSpectrumRecipe<class_9695> {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("midgame/build_enchanting_structure");
    protected final List<class_1856> inputs;
    protected final class_1799 output;
    protected final int requiredExperience;
    protected final int craftingTime;
    protected final boolean noBenefitsFromYieldAndEfficiencyUpgrades;
    protected final boolean copyComponents;

    public EnchanterRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, List<class_1856> inputs, class_1799 output, int craftingTime, int requiredExperience, boolean noBenefitsFromYieldAndEfficiencyUpgrades, boolean copyComponents) {
        super(group, secret, requiredAdvancementIdentifier);
        this.inputs = inputs;
        this.output = output;
        this.requiredExperience = requiredExperience;
        this.craftingTime = craftingTime;
        this.noBenefitsFromYieldAndEfficiencyUpgrades = noBenefitsFromYieldAndEfficiencyUpgrades;
        this.copyComponents = copyComponents;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean method_8115(class_9695 inv, class_1937 world) {
        if (inv.method_59983() >= 10) {
            if (!this.inputs.getFirst().method_8093(inv.method_59984(0))) {
                return false;
            }
            if (this.getRequiredExperience() > 0 && !(inv.method_59984(1).method_7909() instanceof ExperienceStorageItem) && ExperienceStorageItem.getStoredExperience(inv.method_59984(1)) < this.getRequiredExperience()) {
                return false;
            }
            for (int i = 1; i < 9; ++i) {
                if (this.inputs.get(i).method_8093(inv.method_59984(i + 1))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public class_1799 method_8116(class_9695 inv, class_7225.class_7874 drm) {
        if (this.copyComponents) {
            return inv.method_59984(0).method_56701((class_1935)this.output.method_7909(), this.output.method_7947());
        }
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.ENCHANTER);
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.ENCHANTER_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.ENCHANTER;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_37434((int)this.inputs.size());
        ingredients.addAll(this.inputs);
        return ingredients;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public boolean areYieldAndEfficiencyUpgradesDisabled() {
        return this.copyComponents || this.noBenefitsFromYieldAndEfficiencyUpgrades;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "enchanter";
    }

    public static class Serializer
    implements class_1865<EnchanterRecipe> {
        public static final MapCodec<EnchanterRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)class_1856.field_46096.listOf().optionalFieldOf("ingredients", List.of()).forGetter(recipe -> recipe.inputs), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("required_experience", (Object)0).forGetter(recipe -> recipe.requiredExperience), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("disable_yield_and_efficiency_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades), (App)Codec.BOOL.optionalFieldOf("copy_components", (Object)false).forGetter(recipe -> recipe.copyComponents)).apply((Applicative)i, EnchanterRecipe::new));
        public static final class_9139<class_9129, EnchanterRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, recipe -> recipe.group, class_9135.field_48547, recipe -> recipe.secret, class_9135.method_56382((class_9139)class_2960.field_48267), recipe -> recipe.requiredAdvancementIdentifier, class_1856.field_48355.method_56433(class_9135.method_56363()), recipe -> recipe.inputs, class_1799.field_48349, recipe -> recipe.output, class_9135.field_48550, recipe -> recipe.requiredExperience, class_9135.field_48550, recipe -> recipe.craftingTime, class_9135.field_48547, recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades, class_9135.field_48547, recipe -> recipe.copyComponents, EnchanterRecipe::new);

        public MapCodec<EnchanterRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, EnchanterRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

