/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.GemstoneColor;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalRecipeInput;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.RawShapedPedestalRecipe;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class ShapedPedestalRecipe
extends PedestalRecipe {
    protected final int width;
    protected final int height;
    protected final RawShapedPedestalRecipe rawShapedRecipe;

    public ShapedPedestalRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, PedestalRecipeTier tier, RawShapedPedestalRecipe rawShapedRecipe, Map<GemstoneColor, Integer> gemstonePowderInputs, class_1799 output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(group, secret, requiredAdvancementIdentifier, tier, (List<IngredientStack>)rawShapedRecipe.getIngredients(), gemstonePowderInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
        this.rawShapedRecipe = rawShapedRecipe;
        this.width = rawShapedRecipe.getWidth();
        this.height = rawShapedRecipe.getHeight();
    }

    @Override
    public boolean matches(PedestalRecipeInput inv, class_1937 world) {
        return this.rawShapedRecipe.matches(inv.getCraftingGridInput()) && super.matches(inv, world);
    }

    @Override
    public void consumeIngredients(PedestalBlockEntity pedestal) {
        super.consumeIngredients(pedestal);
        boolean mirrored = this.rawShapedRecipe.matches(pedestal.createRecipeInput().getCraftingGridInput(), true);
        class_9694.class_9765 positioned = pedestal.createPositionedInput();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                class_1799 slotStack;
                int ingredientStackId = (mirrored ? this.width - 1 - x : x) + this.width * y;
                int slot = x + positioned.comp_2796() + 3 * (y + positioned.comp_2797());
                IngredientStack ingredientStackAtPos = (IngredientStack)this.inputs.get(ingredientStackId);
                if (!ingredientStackAtPos.test(slotStack = pedestal.method_5438(slot))) {
                    SpectrumCommon.logError("Looks like DaFuqs or Electro fucked up Spectrums Pedestal recipe matching. Go open up a report with the recipe that was crafted and an image of the pedestals contents, please! :)");
                }
                if (slotStack.method_7960()) continue;
                this.decrementGridSlot(pedestal, slot, ingredientStackAtPos.getCount(), slotStack);
            }
        }
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.SHAPED_PEDESTAL_RECIPE_SERIALIZER;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isShapeless() {
        return false;
    }

    public static class Serializer
    implements class_1865<ShapedPedestalRecipe> {
        public static final MapCodec<ShapedPedestalRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)PedestalRecipeTier.CODEC.optionalFieldOf("tier", (Object)PedestalRecipeTier.BASIC).forGetter(recipe -> recipe.tier), (App)RawShapedPedestalRecipe.CODEC.forGetter(recipe -> recipe.rawShapedRecipe), (App)CodecHelper.registryMap(SpectrumRegistries.GEMSTONE_COLOR, Codec.INT).fieldOf("colors").forGetter(recipe -> recipe.powderInputs), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("skip_recipe_remainders", (Object)false).forGetter(recipe -> recipe.skipRecipeRemainders), (App)Codec.BOOL.optionalFieldOf("disable_yield_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldUpgrades)).apply((Applicative)i, ShapedPedestalRecipe::new));
        public static final class_9139<class_9129, ShapedPedestalRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, recipe -> recipe.group, class_9135.field_48547, recipe -> recipe.secret, class_9135.method_56382((class_9139)class_2960.field_48267), recipe -> recipe.requiredAdvancementIdentifier, PedestalRecipeTier.PACKET_CODEC, recipe -> recipe.tier, RawShapedPedestalRecipe.PACKET_CODEC, recipe -> recipe.rawShapedRecipe, class_9135.method_56377(HashMap::new, (class_9139)class_9135.method_56365((class_5321)SpectrumRegistries.GEMSTONE_COLOR.method_30517()), (class_9139)class_9135.field_48550), recipe -> recipe.powderInputs, class_1799.field_48349, recipe -> recipe.output, class_9135.field_48552, recipe -> Float.valueOf(recipe.experience), class_9135.field_48550, recipe -> recipe.craftingTime, class_9135.field_48547, recipe -> recipe.skipRecipeRemainders, class_9135.field_48547, recipe -> recipe.noBenefitsFromYieldUpgrades, ShapedPedestalRecipe::new);

        public MapCodec<ShapedPedestalRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ShapedPedestalRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

