/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.components.CustomPotionDataComponent;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionRecipeEffect;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumPotions;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_4081;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionWorkshopBrewingRecipe
extends PotionWorkshopRecipe {
    public static final int BASE_POTION_COUNT_ON_BREWING = 3;
    public static final int ARROW_COUNT_MULTIPLIER = 8;
    protected static final List<class_3545<Float, Float>> SPLIT_EFFECT_POTENCY_AND_DURATION = new ArrayList<class_3545<Float, Float>>(){
        {
            this.add(new class_3545((Object)Float.valueOf(1.667f), (Object)Float.valueOf(0.1f)));
            this.add(new class_3545((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.334f)));
            this.add(new class_3545((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.667f)));
        }
    };
    public static final Map<class_6880<class_1291>, class_6880<class_1291>> negativeToPositiveEffect = new HashMap<class_6880<class_1291>, class_6880<class_1291>>(){
        {
            this.put(class_1294.field_16595, class_1294.field_18980);
            this.put(class_1294.field_5903, class_1294.field_5922);
            this.put(class_1294.field_5921, class_1294.field_5915);
            this.put(class_1294.field_5901, class_1294.field_5917);
            this.put(class_1294.field_5909, class_1294.field_5904);
            this.put(class_1294.field_5908, class_1294.field_5926);
            this.put(class_1294.field_5911, class_1294.field_5910);
            this.put(class_1294.field_5920, class_1294.field_5924);
            this.put(SpectrumStatusEffects.STIFFNESS, SpectrumStatusEffects.SWIFTNESS);
            this.put(SpectrumStatusEffects.DENSITY, SpectrumStatusEffects.LIGHTWEIGHT);
        }
    };
    public static final List<PotionWorkshopBrewingRecipe> positiveRecipes = new ArrayList<PotionWorkshopBrewingRecipe>();
    public static final List<PotionWorkshopBrewingRecipe> negativeRecipes = new ArrayList<PotionWorkshopBrewingRecipe>();
    public final PotionRecipeEffect recipeData;
    protected class_1799 cachedOutput;

    @Nullable
    public static PotionWorkshopBrewingRecipe getPositiveRecipe(@NotNull class_6880<class_1291> statusEffect) {
        if (((class_1291)statusEffect.comp_349()).method_18792() == class_4081.field_18272) {
            class_6880 positiveEffect = negativeToPositiveEffect.getOrDefault(statusEffect, null);
            if (positiveEffect == null) {
                return null;
            }
            for (PotionWorkshopBrewingRecipe positiveRecipe : positiveRecipes) {
                if (positiveRecipe.recipeData.statusEffect() != positiveEffect) continue;
                return positiveRecipe;
            }
        }
        return null;
    }

    public PotionWorkshopBrewingRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, int craftingTime, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3, PotionRecipeEffect recipeData) {
        super(group, secret, requiredAdvancementIdentifier, craftingTime, ((class_1291)recipeData.statusEffect().comp_349()).method_5556(), ingredient1, ingredient2, ingredient3);
        this.recipeData = recipeData;
        this.registerInToastManager(this.method_17716(), this);
        if (((class_1291)recipeData.statusEffect().comp_349()).method_18792() == class_4081.field_18271) {
            for (PotionWorkshopBrewingRecipe ae : positiveRecipes) {
                if (ae.recipeData.statusEffect().comp_349() != recipeData.statusEffect()) continue;
                return;
            }
            positiveRecipes.add(this);
        } else if (((class_1291)recipeData.statusEffect().comp_349()).method_18792() == class_4081.field_18272) {
            for (PotionWorkshopBrewingRecipe ae : negativeRecipes) {
                if (ae.recipeData.statusEffect() != recipeData.statusEffect()) continue;
                return;
            }
            negativeRecipes.add(this);
        }
    }

    @Override
    public boolean isValidBaseIngredient(class_1799 itemStack) {
        InkPoweredPotionFillable fillable;
        class_1792 class_17922;
        return this.recipeData.applicableToPotions() && itemStack.method_31574(class_1802.field_8469) || this.recipeData.applicableToTippedArrows() && itemStack.method_31574(class_1802.field_8107) || (class_17922 = itemStack.method_7909()) instanceof InkPoweredPotionFillable && ((fillable = (InkPoweredPotionFillable)class_17922).isWeapon() && this.recipeData.applicableToWeapons() || this.recipeData.applicableToPotionFillabes());
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.POTION_WORKSHOP_BREWING_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_BREWING;
    }

    @Override
    public boolean usesReagents() {
        return true;
    }

    @Override
    public int getMinOutputCount(class_1799 baseItemStack) {
        return baseItemStack.method_31574(class_1802.field_8469) ? 3 : 1;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)IngredientStack.ofItems(SpectrumItems.MERMAIDS_GEM));
        defaultedList.add((Object)IngredientStack.ofItems(class_1802.field_8469));
        this.addIngredientStacks((class_2371<IngredientStack>)defaultedList);
        return defaultedList;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        if (this.cachedOutput == null) {
            this.cachedOutput = this.getPotion(class_1802.field_8469.method_7854(), class_1802.field_8574.method_7854(), new PotionMod.Builder().build(), null, class_5819.method_43047());
        }
        return this.cachedOutput;
    }

    public class_1799 method_8116(class_9695 inventory, class_7225.class_7874 drm) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8574);
        stack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), List.of(new class_1293(this.recipeData.statusEffect(), this.recipeData.baseDurationTicks()))));
        return stack;
    }

    public float getModifiedYield(PotionMod potionMod) {
        return this.recipeData.baseYield() + potionMod.yield();
    }

    public List<class_1799> getPotions(class_1799 stack, PotionMod potionMod, @Nullable class_8786<PotionWorkshopBrewingRecipe> lastRecipe, class_5819 random, int brewedAmount) {
        class_1799 itemStack;
        PotionMod.Builder builder = new PotionMod.Builder(potionMod);
        if (potionMod.flags().makeSplashing()) {
            if (potionMod.flags().makeLingering()) {
                itemStack = new class_1799((class_1935)class_1802.field_8150);
                if (potionMod.flags().negateDecreasingDuration()) {
                    builder.durationMultiplier(builder.durationMultiplier + 3.0f);
                }
            } else {
                itemStack = new class_1799((class_1935)class_1802.field_8436);
            }
        } else {
            itemStack = new class_1799((class_1935)class_1802.field_8574);
        }
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (int i = 0; i < brewedAmount; ++i) {
            results.add(this.getPotion(stack, itemStack.method_7972(), potionMod, lastRecipe, random));
        }
        return results;
    }

    public class_1799 getPotion(class_1799 originalStack, class_1799 targetStack, PotionMod potionMod, @Nullable class_8786<PotionWorkshopBrewingRecipe> lastRecipe, class_5819 random) {
        List<InkPoweredStatusEffectInstance> effects = this.generateEffects(originalStack, potionMod, lastRecipe, random);
        if (effects.isEmpty()) {
            targetStack = class_1844.method_57400((class_1792)targetStack.method_7909(), (class_6880)class_1847.field_8985);
        } else {
            targetStack = class_1844.method_57400((class_1792)targetStack.method_7909(), SpectrumPotions.PIGMENT_POTION);
            PotionWorkshopBrewingRecipe.setCustomPotionEffects(targetStack, potionMod, effects);
        }
        return targetStack;
    }

    public class_1799 getTippedArrows(class_1799 stack, PotionMod potionMod, @Nullable class_8786<PotionWorkshopBrewingRecipe> lastRecipe, int amount, class_5819 random) {
        if (potionMod.flags().negateDecreasingDuration()) {
            potionMod = new PotionMod.Builder(potionMod).durationMultiplier(potionMod.durationMultiplier() + 7.0f).build();
        }
        List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8087, amount);
        if (effects.isEmpty()) {
            itemStack = class_1844.method_57400((class_1792)itemStack.method_7909(), (class_6880)class_1847.field_8985);
        } else {
            itemStack = class_1844.method_57400((class_1792)itemStack.method_7909(), SpectrumPotions.PIGMENT_POTION);
            PotionWorkshopBrewingRecipe.setCustomPotionEffects(itemStack, potionMod, effects);
        }
        return itemStack;
    }

    public void fillPotionFillable(class_1799 stack, PotionMod potionMod, @Nullable class_8786<PotionWorkshopBrewingRecipe> lastRecipe, class_5819 random) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof InkPoweredPotionFillable) {
            InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)class_17922;
            List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
            inkPoweredPotionFillable.addOrUpgradeEffects(stack, effects);
        }
    }

    private static void setCustomPotionEffects(class_1799 stack, PotionMod potionMod, List<InkPoweredStatusEffectInstance> effects) {
        ArrayList<class_1293> instances = new ArrayList<class_1293>();
        for (InkPoweredStatusEffectInstance e : effects) {
            instances.add(e.getStatusEffectInstance());
        }
        OptionalInt potionColor = class_1844.method_58111(instances);
        class_1844 potionComponent = new class_1844(Optional.of(SpectrumPotions.PIGMENT_POTION), Optional.of(potionColor.orElse(0)), instances);
        stack.method_57379(class_9334.field_49651, (Object)potionComponent);
        if (potionMod.flags().unidentifiable() || potionMod.additionalDrinkDurationTicks() != 0) {
            stack.method_57379(SpectrumDataComponentTypes.CUSTOM_POTION_DATA, (Object)new CustomPotionDataComponent(potionMod.flags().unidentifiable(), potionMod.additionalDrinkDurationTicks()));
        }
    }

    private List<InkPoweredStatusEffectInstance> generateEffects(class_1799 baseIngredient, PotionMod potionMod, @Nullable class_8786<PotionWorkshopBrewingRecipe> lastRecipe, class_5819 random) {
        List<InkPoweredStatusEffectInstance> effects = new ArrayList<InkPoweredStatusEffectInstance>();
        this.addEffect(potionMod, random, effects);
        if (lastRecipe != null) {
            PotionWorkshopBrewingRecipe.addLastEffect(baseIngredient, potionMod, (PotionWorkshopBrewingRecipe)lastRecipe.comp_1933(), random, effects);
        }
        PotionWorkshopBrewingRecipe.addAdditionalEffects(baseIngredient, potionMod, random, effects);
        this.addRandomEffects(baseIngredient, potionMod, random, effects);
        if (potionMod.flags().potentDecreasingEffect()) {
            effects = this.applyPotentDecreasingEffect(effects, random);
        }
        return effects;
    }

    private static void addLastEffect(class_1799 baseIngredient, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        if (lastRecipe != null && (potionMod.chanceToAddLastEffect() >= 1.0f || random.method_43057() < potionMod.chanceToAddLastEffect()) && lastRecipe.recipeData.isApplicableTo(baseIngredient, potionMod)) {
            PotionMod lastEffectMod = new PotionMod.Builder(potionMod).potencyMultiplier(potionMod.lastEffectPotencyMultiplier()).durationMultiplier(potionMod.lastEffectDurationMultiplier()).build();
            lastRecipe.addEffect(lastEffectMod, random, effects);
        }
    }

    private static void addAdditionalEffects(class_1799 baseIngredient, PotionMod potionMod, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        for (class_3545<PotionRecipeEffect, Float> entry : potionMod.flags().additionalEffects()) {
            InkPoweredStatusEffectInstance statusEffectInstance;
            if (!(random.method_43057() < ((Float)entry.method_15441()).floatValue()) || !((PotionRecipeEffect)entry.method_15442()).isApplicableTo(baseIngredient, potionMod) || (statusEffectInstance = ((PotionRecipeEffect)entry.method_15442()).getStatusEffectInstance(potionMod, random)) == null) continue;
            effects.add(statusEffectInstance);
        }
    }

    private void addEffect(PotionMod potionMod, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        PotionWorkshopBrewingRecipe positiveRecipe;
        if (potionMod.flags().makeEffectsPositive() && (positiveRecipe = PotionWorkshopBrewingRecipe.getPositiveRecipe(this.recipeData.statusEffect())) != null) {
            effects.add(positiveRecipe.recipeData.getStatusEffectInstance(potionMod, random));
            return;
        }
        InkPoweredStatusEffectInstance statusEffectInstance = this.recipeData.getStatusEffectInstance(potionMod, random);
        if (statusEffectInstance != null) {
            effects.add(statusEffectInstance);
        }
    }

    private void addRandomEffects(class_1799 baseIngredient, PotionMod potionMod, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        int additionalNegativeEffectCount;
        int additionalPositiveEffectCount = Support.getIntFromDecimalWithChance(potionMod.additionalRandomPositiveEffectCount(), random);
        if (additionalPositiveEffectCount > 0) {
            List<PotionWorkshopBrewingRecipe> randomlySelectedRecipes = this.pullRandomMatchingRecipes(positiveRecipes, additionalPositiveEffectCount, effects, baseIngredient);
            for (PotionWorkshopBrewingRecipe recipe : randomlySelectedRecipes) {
                InkPoweredStatusEffectInstance statusEffectInstance = recipe.recipeData.getStatusEffectInstance(potionMod, random);
                if (statusEffectInstance == null) continue;
                effects.add(statusEffectInstance);
            }
        }
        if ((additionalNegativeEffectCount = Support.getIntFromDecimalWithChance(potionMod.additionalRandomNegativeEffectCount(), random)) > 0) {
            List<PotionWorkshopBrewingRecipe> randomlySelectedRecipes = this.pullRandomMatchingRecipes(potionMod.flags().makeEffectsPositive() ? positiveRecipes : negativeRecipes, additionalNegativeEffectCount, effects, baseIngredient);
            for (PotionWorkshopBrewingRecipe recipe : randomlySelectedRecipes) {
                InkPoweredStatusEffectInstance statusEffectInstance = recipe.recipeData.getStatusEffectInstance(potionMod, random);
                if (statusEffectInstance == null) continue;
                effects.add(statusEffectInstance);
            }
        }
    }

    private List<PotionWorkshopBrewingRecipe> pullRandomMatchingRecipes(List<PotionWorkshopBrewingRecipe> list, int amount, List<InkPoweredStatusEffectInstance> effects, class_1799 baseIngredient) {
        ArrayList<PotionWorkshopBrewingRecipe> results = new ArrayList<PotionWorkshopBrewingRecipe>();
        ArrayList<PotionWorkshopBrewingRecipe> shuffledPositiveRecipes = new ArrayList<PotionWorkshopBrewingRecipe>(list);
        Collections.shuffle(shuffledPositiveRecipes);
        int i = 0;
        for (PotionWorkshopBrewingRecipe recipe : shuffledPositiveRecipes) {
            if (i == amount) break;
            if (!recipe.isValidBaseIngredient(baseIngredient) || this.containsEffect(effects, (class_1291)recipe.recipeData.statusEffect().comp_349())) continue;
            results.add(recipe);
            ++i;
        }
        return results;
    }

    private boolean containsEffect(List<InkPoweredStatusEffectInstance> effects, class_1291 statusEffect) {
        for (InkPoweredStatusEffectInstance existingInstance : effects) {
            if (existingInstance.getStatusEffectInstance().method_5579() != statusEffect) continue;
            return true;
        }
        return false;
    }

    private List<InkPoweredStatusEffectInstance> applyPotentDecreasingEffect(@NotNull List<InkPoweredStatusEffectInstance> statusEffectInstances, class_5819 random) {
        ArrayList<InkPoweredStatusEffectInstance> splitInstances = new ArrayList<InkPoweredStatusEffectInstance>();
        for (InkPoweredStatusEffectInstance poweredInstance : statusEffectInstances) {
            class_1293 instance = poweredInstance.getStatusEffectInstance();
            if (((class_1291)instance.method_5579().comp_349()).method_5561()) {
                splitInstances.add(poweredInstance);
                continue;
            }
            for (class_3545<Float, Float> mods : SPLIT_EFFECT_POTENCY_AND_DURATION) {
                int newDuration = (int)((float)instance.method_5584() * ((Float)mods.method_15441()).floatValue());
                int newAmplifier = Support.getIntFromDecimalWithChance((float)instance.method_5578() * ((Float)mods.method_15442()).floatValue(), random);
                if (newAmplifier < 0) continue;
                splitInstances.add(new InkPoweredStatusEffectInstance(new class_1293(instance.method_5579(), newDuration, newAmplifier, instance.method_5591(), instance.method_5581()), poweredInstance.getInkCost(), poweredInstance.getColor(), poweredInstance.isUnidentifiable()));
            }
        }
        return splitInstances;
    }

    public class_1291 getStatusEffect() {
        return (class_1291)this.recipeData.statusEffect().comp_349();
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_brewing";
    }

    public static class Serializer
    implements class_1865<PotionWorkshopBrewingRecipe> {
        public static final MapCodec<PotionWorkshopBrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(c -> c.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(c -> c.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(c -> c.requiredAdvancementIdentifier), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(c -> c.craftingTime), (App)IngredientStack.Serializer.CODEC.fieldOf("ingredient1").forGetter(c -> c.ingredient1), (App)IngredientStack.Serializer.CODEC.optionalFieldOf("ingredient2", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient2), (App)IngredientStack.Serializer.CODEC.optionalFieldOf("ingredient3", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient3), (App)PotionRecipeEffect.CODEC.forGetter(c -> c.recipeData)).apply((Applicative)i, PotionWorkshopBrewingRecipe::new));
        public static final class_9139<class_9129, PotionWorkshopBrewingRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, c -> c.group, class_9135.field_48547, c -> c.secret, class_9135.method_56382((class_9139)class_2960.field_48267), c -> c.requiredAdvancementIdentifier, class_9135.field_48550, c -> c.craftingTime, IngredientStack.Serializer.PACKET_CODEC, c -> c.ingredient1, IngredientStack.Serializer.PACKET_CODEC, c -> c.ingredient2, IngredientStack.Serializer.PACKET_CODEC, c -> c.ingredient3, PotionRecipeEffect.PACKET_CODEC, c -> c.recipeData, PotionWorkshopBrewingRecipe::new);

        public MapCodec<PotionWorkshopBrewingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, PotionWorkshopBrewingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

