/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;

public class PotionWorkshopCraftingRecipe
extends PotionWorkshopRecipe {
    protected final IngredientStack baseIngredient;
    protected final boolean consumeBaseIngredient;
    protected final int requiredExperience;
    protected final class_1799 output;

    public PotionWorkshopCraftingRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, int craftingTime, int color, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3, IngredientStack baseIngredient, boolean consumeBaseIngredient, int requiredExperience, class_1799 output) {
        super(group, secret, requiredAdvancementIdentifier, craftingTime, color, ingredient1, ingredient2, ingredient3);
        this.output = output;
        this.baseIngredient = baseIngredient;
        this.requiredExperience = requiredExperience;
        this.consumeBaseIngredient = consumeBaseIngredient;
        this.registerInToastManager(this.method_17716(), this);
    }

    public IngredientStack getBaseIngredient() {
        return this.baseIngredient;
    }

    public boolean consumesBaseIngredient() {
        return this.consumeBaseIngredient;
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.POTION_WORKSHOP_CRAFTING_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING;
    }

    @Override
    public boolean usesReagents() {
        return false;
    }

    @Override
    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public class_1799 method_8116(class_9695 inventory, class_7225.class_7874 drm) {
        return this.output.method_7972();
    }

    @Override
    public boolean isValidBaseIngredient(class_1799 itemStack) {
        return this.baseIngredient.test(itemStack);
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)IngredientStack.ofItems(SpectrumItems.MERMAIDS_GEM));
        defaultedList.add((Object)this.baseIngredient);
        this.addIngredientStacks((class_2371<IngredientStack>)defaultedList);
        return defaultedList;
    }

    @Override
    public boolean method_8115(@NotNull class_9695 inv, class_1937 world) {
        if (this.enoughExperienceSupplied(inv)) {
            return super.method_8115(inv, world);
        }
        return false;
    }

    private boolean enoughExperienceSupplied(class_9695 inv) {
        if (this.requiredExperience > 0) {
            for (int i : new int[]{1, 2, 3, 4}) {
                if (!(inv.method_59984(i).method_7909() instanceof ExperienceStorageItem)) continue;
                return ExperienceStorageItem.getStoredExperience(inv.method_59984(i)) >= this.requiredExperience;
            }
        }
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.output;
    }

    @Override
    public int getMinOutputCount(class_1799 itemStack) {
        return 1;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_crafting";
    }

    public static class Serializer
    implements class_1865<PotionWorkshopCraftingRecipe> {
        public static final MapCodec<PotionWorkshopCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(c -> c.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(c -> c.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(c -> c.requiredAdvancementIdentifier), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(c -> c.craftingTime), (App)Codec.INT.optionalFieldOf("color", (Object)12595288).forGetter(c -> c.color), (App)IngredientStack.Serializer.CODEC.fieldOf("ingredient1").forGetter(c -> c.ingredient1), (App)IngredientStack.Serializer.CODEC.optionalFieldOf("ingredient2", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient2), (App)IngredientStack.Serializer.CODEC.optionalFieldOf("ingredient3", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient3), (App)IngredientStack.Serializer.CODEC.fieldOf("base_ingredient").forGetter(c -> c.baseIngredient), (App)Codec.BOOL.optionalFieldOf("use_up_base_ingredient", (Object)true).forGetter(c -> c.consumeBaseIngredient), (App)Codec.INT.optionalFieldOf("required_experience", (Object)0).forGetter(c -> c.requiredExperience), (App)class_1799.field_24671.fieldOf("result").forGetter(c -> c.output)).apply((Applicative)i, PotionWorkshopCraftingRecipe::new));
        public static final class_9139<class_9129, PotionWorkshopCraftingRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, c -> c.group, class_9135.field_48547, c -> c.secret, class_9135.method_56382((class_9139)class_2960.field_48267), c -> c.requiredAdvancementIdentifier, class_9135.field_48550, c -> c.craftingTime, class_9135.field_48550, c -> c.color, IngredientStack.Serializer.PACKET_CODEC, c -> c.ingredient1, IngredientStack.Serializer.PACKET_CODEC, c -> c.ingredient2, IngredientStack.Serializer.PACKET_CODEC, c -> c.ingredient3, IngredientStack.Serializer.PACKET_CODEC, c -> c.baseIngredient, class_9135.field_48547, c -> c.consumeBaseIngredient, class_9135.field_48550, c -> c.requiredExperience, class_1799.field_48349, c -> c.output, PotionWorkshopCraftingRecipe::new);

        public MapCodec<PotionWorkshopCraftingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, PotionWorkshopCraftingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

