/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller.dynamic;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullBlock;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.recipe.InstanceRecipeInput;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class MemoryToHeadRecipe
extends SpiritInstillerRecipe {
    public MemoryToHeadRecipe() {
        super("", false, Optional.of(SpectrumCommon.locate("unlocks/memory_to_head")), IngredientStack.ofItems(SpectrumBlocks.MEMORY.method_8389()), IngredientStack.ofItems(SpectrumItems.VEGETAL, 4), IngredientStack.ofItems(SpectrumItems.QUITOXIC_POWDER, 4), new class_1799((class_1935)class_2246.field_10241), 200, 1.0f, true);
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.SPIRIT_INSTILLER_MEMORY_TO_HEAD;
    }

    @Override
    public class_1799 assemble(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, class_7225.class_7874 drm) {
        SpiritInstillerBlockEntity spiritInstillerBlockEntity = recipeInput.getInstance();
        class_1799 resultStack = class_1799.field_8037;
        class_3218 world = (class_3218)spiritInstillerBlockEntity.method_10997();
        class_2338 pos = spiritInstillerBlockEntity.method_11016();
        Optional<class_9296> profile = MemoryItem.getPlayer(recipeInput.method_59984(0));
        if (profile.isPresent()) {
            resultStack = new class_1799((class_1935)class_1802.field_8575);
            resultStack.method_57379(class_9334.field_49617, (Object)profile.get());
        } else {
            Optional<class_1297> optionalEntity = MemoryBlockEntity.hatchEntity(world, pos, spiritInstillerBlockEntity.method_5438(0));
            if (optionalEntity.isPresent()) {
                class_1297 class_12972 = optionalEntity.get();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)class_12972;
                    if (world != null) {
                        class_52 lootTable = world.method_8503().method_58576().method_58295(livingEntity.method_5989());
                        class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)livingEntity).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1231, (Object)SpectrumDamageTypes.mobHeadDrop((class_1937)world));
                        class_8567 lootContextParameterSet = builder.method_51875(class_173.field_1173);
                        ObjectArrayList loot = lootTable.method_51879(lootContextParameterSet, livingEntity.method_51851());
                        for (class_1799 stack : loot) {
                            if (!stack.method_31573(SpectrumItemTags.SKULLS)) continue;
                            resultStack = stack;
                            break;
                        }
                    }
                }
                optionalEntity.get().method_31472();
            }
        }
        this.spawnXPAndGrantAdvancements(resultStack, spiritInstillerBlockEntity, spiritInstillerBlockEntity.getUpgradeHolder(), (class_1937)world, pos);
        return resultStack;
    }

    @Override
    public boolean canCraftWithStacks(InstanceRecipeInput<SpiritInstillerBlockEntity> inventory) {
        class_1799 instillerStack = inventory.method_59984(0);
        return MemoryToHeadRecipe.getSkullTypeForMemory(instillerStack).isPresent();
    }

    private static Optional<class_2484.class_2485> getSkullTypeForMemory(class_1799 instillerStack) {
        if (!(instillerStack.method_7909() instanceof MemoryItem)) {
            return Optional.empty();
        }
        Optional<class_9296> player = MemoryItem.getPlayer(instillerStack);
        if (player.isPresent()) {
            return Optional.of(class_2484.class_2486.field_11510);
        }
        Optional<class_1299<?>> optionalMemoryEntity = MemoryItem.getEntityType(instillerStack);
        return optionalMemoryEntity.flatMap(SpectrumSkullBlock::getSkullType);
    }
}

