/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller.dynamic.spawner_manipulation;

import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullBlock;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.InstanceRecipeInput;
import de.dafuqs.spectrum.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumEntityTypeTags;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import org.jetbrains.annotations.Nullable;

public class SpawnerCreatureChangeRecipe
extends SpawnerChangeRecipe {
    public SpawnerCreatureChangeRecipe() {
        super(IngredientStack.ofTag(SpectrumItemTags.SKULLS), IngredientStack.ofItems(SpectrumItems.DOWNSTONE_FRAGMENTS, 4), Optional.of(SpectrumAdvancements.SPAWNER_CREATURE_CHANGE));
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.SPIRIT_INSTILLER_SPAWNER_CREATURE_CHANGE;
    }

    @Override
    public boolean canCraftWithBlockEntityTag(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, class_9279 spawnerBlockEntityNbt, class_1799 firstBowlStack, class_1799 secondBowlStack) {
        class_2487 entity;
        class_2487 spawnData;
        Optional<class_1299<?>> entityType = SpectrumSkullBlock.getEntityTypeOfSkullStack(firstBowlStack);
        Optional<class_1299<?>> optional = entityType = entityType.isEmpty() ? SpectrumSkullBlock.getEntityTypeOfSkullStack(secondBowlStack) : entityType;
        if (entityType.isEmpty() || entityType.get().method_20210(SpectrumEntityTypeTags.SPAWNER_MANIPULATION_BLACKLISTED)) {
            @Nullable class_1657 player = recipeInput.getInstance().getOwnerIfOnline();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Support.grantAdvancementCriterion(serverPlayer, SpectrumAdvancements.FAILED_CREATING_EMPTY_OR_BLACKLISTED_SPAWNER, "failed_creating_empty_or_blacklisted_spawner");
            }
            return false;
        }
        if (entityType.get() == class_1299.field_6097) {
            @Nullable class_1657 player = recipeInput.getInstance().getOwnerIfOnline();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Support.grantAdvancementCriterion(serverPlayer, SpectrumAdvancements.FAILED_CREATING_PLAYER_SPAWNER, "failed_creating_player_spawner");
            }
            return false;
        }
        if (spawnerBlockEntityNbt == null) {
            return true;
        }
        if (spawnerBlockEntityNbt.method_57450("SpawnData") && (spawnData = spawnerBlockEntityNbt.method_57461().method_10562("SpawnData")).method_10545("entity") && (entity = spawnData.method_10562("entity")).method_10545("id")) {
            class_2960 entityTypeIdentifier = class_7923.field_41177.method_10221(entityType.get());
            return !entityTypeIdentifier.toString().equals(entity.method_10558("id"));
        }
        return true;
    }

    @Override
    public class_2561 getOutputLoreText() {
        return class_2561.method_43471((String)"recipe.spectrum.spawner.lore.changed_creature");
    }

    @Override
    public class_2487 getSpawnerResultNbt(class_2487 nbt, class_1799 firstBowlStack, class_1799 secondBowlStack, InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput) {
        Optional<class_1299<?>> entityType = SpectrumSkullBlock.getEntityTypeOfSkullStack(firstBowlStack);
        Optional<class_1299<?>> optional = entityType = entityType.isEmpty() ? SpectrumSkullBlock.getEntityTypeOfSkullStack(secondBowlStack) : entityType;
        if (entityType.isEmpty()) {
            return nbt;
        }
        class_2960 entityTypeIdentifier = class_7923.field_41177.method_10221(entityType.get());
        class_2487 idCompound = new class_2487();
        idCompound.method_10582("id", entityTypeIdentifier.toString());
        class_2487 entityCompound = new class_2487();
        entityCompound.method_10566("entity", (class_2520)idCompound);
        nbt.method_10566("SpawnData", (class_2520)entityCompound);
        if (nbt.method_10545("SpawnPotentials")) {
            nbt.method_10551("SpawnPotentials");
        }
        return nbt;
    }
}

