/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller.dynamic.spawner_manipulation;

import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.recipe.InstanceRecipeInput;
import de.dafuqs.spectrum.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9279;

public class SpawnerSpawnDelayChangeRecipe
extends SpawnerChangeRecipe {
    protected static final int DEFAULT_MIN_DELAY = 200;
    protected static final int DEFAULT_MAX_DELAY = 800;
    protected static final int MIN_MIN_DELAY = 20;
    protected static final int MIN_MAX_DELAY = 40;
    protected static final float EXPONENT = 0.98f;

    public SpawnerSpawnDelayChangeRecipe() {
        super(IngredientStack.ofItems(SpectrumItems.MIDNIGHT_CHIP, 4));
    }

    @Override
    public boolean canCraftWithBlockEntityTag(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, class_9279 spawnerBlockEntityNbt, class_1799 leftBowlStack, class_1799 rightBowlStack) {
        if (spawnerBlockEntityNbt == null) {
            return true;
        }
        class_2487 nbt = spawnerBlockEntityNbt.method_57463();
        return !(nbt.method_10545("MinSpawnDelay") && nbt.method_10568("MinSpawnDelay") <= 20 || nbt.method_10545("MaxSpawnDelay") && nbt.method_10568("MaxSpawnDelay") <= 40);
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.SPIRIT_INSTILLER_SPAWNER_SPAWN_DELAY_CHANGE;
    }

    @Override
    public class_2561 getOutputLoreText() {
        return class_2561.method_43471((String)"recipe.spectrum.spawner.lore.decreased_spawn_delay");
    }

    @Override
    public class_2487 getSpawnerResultNbt(class_2487 nbt, class_1799 firstBowlStack, class_1799 secondBowlStack, InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput) {
        short newMaxSpawnDelay;
        short newMinSpawnDelay;
        short minSpawnDelay = 200;
        if (nbt.method_10573("MinSpawnDelay", 2)) {
            minSpawnDelay = nbt.method_10568("MinSpawnDelay");
        }
        short maxSpawnDelay = 800;
        if (nbt.method_10573("MaxSpawnDelay", 2)) {
            maxSpawnDelay = nbt.method_10568("MaxSpawnDelay");
        }
        if ((newMinSpawnDelay = (short)Math.pow(minSpawnDelay, 0.98f)) == minSpawnDelay) {
            newMinSpawnDelay = (short)(minSpawnDelay - 1);
        }
        if ((newMaxSpawnDelay = (short)Math.pow(maxSpawnDelay, 0.98f)) == maxSpawnDelay) {
            newMaxSpawnDelay = (short)(maxSpawnDelay - 1);
        }
        nbt.method_10575("MinSpawnDelay", (short)Math.max(20, newMinSpawnDelay));
        nbt.method_10575("MaxSpawnDelay", (short)Math.max(40, newMaxSpawnDelay));
        return nbt;
    }
}

