/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditionType;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class SpectrumLoadConditions {
    public static final ResourceConditionType<SpectrumTagsPopulatedResourceCondition> TAGS_POPULATED = SpectrumLoadConditions.createResourceConditionType("tags_populated", SpectrumTagsPopulatedResourceCondition.CODEC);

    private static <T extends ResourceCondition> ResourceConditionType<T> createResourceConditionType(String name, MapCodec<T> codec) {
        return ResourceConditionType.create((class_2960)SpectrumCommon.locate(name), codec);
    }

    public static void register() {
        ResourceConditions.register(TAGS_POPULATED);
    }

    public record SpectrumTagsPopulatedResourceCondition(class_2960 registry, List<class_2960> tags) implements ResourceCondition
    {
        public static final MapCodec<SpectrumTagsPopulatedResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("registry").orElse((Object)class_7924.field_41197.method_29177()).forGetter(SpectrumTagsPopulatedResourceCondition::registry), (App)class_2960.field_25139.listOf().fieldOf("values").forGetter(SpectrumTagsPopulatedResourceCondition::tags)).apply((Applicative)instance, SpectrumTagsPopulatedResourceCondition::new));

        public ResourceConditionType<?> getType() {
            return TAGS_POPULATED;
        }

        public boolean test(class_7225.class_7874 registryLookup) {
            return SpectrumTagsPopulatedResourceCondition.tagsPopulated(registryLookup, this.registry(), this.tags());
        }

        public static boolean tagsPopulated(class_7225.class_7874 registryLookup, class_2960 registryId, List<class_2960> tags) {
            if (registryLookup == null) {
                return false;
            }
            class_5321 registryKey = class_5321.method_29180((class_2960)registryId);
            class_7225.class_7226 wrapper = registryLookup.method_46762(registryKey);
            for (class_2960 tag : tags) {
                class_6862 tagKey = class_6862.method_40092((class_5321)registryKey, (class_2960)tag);
                Optional optional = wrapper.method_46733(tagKey);
                if (optional.isEmpty()) {
                    return false;
                }
                class_6885.class_6888 entry = (class_6885.class_6888)optional.get();
                if (entry.method_40247() != 0) continue;
                return false;
            }
            return true;
        }
    }
}

