/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import java.util.List;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditionType;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SpectrumResourceConditions {
    public static void register() {
        ResourceConditions.register(EnchantmentsExistResourceCondition.TYPE);
        ResourceConditions.register(IntegrationPackActiveResourceCondition.TYPE);
    }

    public record EnchantmentsExistResourceCondition(List<class_5321<class_1887>> enchantments) implements ResourceCondition
    {
        public static MapCodec<EnchantmentsExistResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41265).listOf().fieldOf("values").forGetter(EnchantmentsExistResourceCondition::enchantments)).apply((Applicative)instance, EnchantmentsExistResourceCondition::new));
        public static ResourceConditionType<EnchantmentsExistResourceCondition> TYPE = ResourceConditionType.create((class_2960)SpectrumCommon.locate("enchantments_exist"), CODEC);

        public ResourceConditionType<?> getType() {
            return TYPE;
        }

        public boolean test(@Nullable class_7225.class_7874 wrapperLookup) {
            if (wrapperLookup == null || wrapperLookup.method_46759(class_7924.field_41265).isEmpty()) {
                return false;
            }
            class_7225.class_7226 impl = (class_7225.class_7226)wrapperLookup.method_46759(class_7924.field_41265).get();
            return this.enchantments.stream().allMatch(key -> impl.method_46746(key).isPresent());
        }
    }

    public record IntegrationPackActiveResourceCondition(String integrationPack) implements ResourceCondition
    {
        public static MapCodec<IntegrationPackActiveResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("integration_pack").forGetter(IntegrationPackActiveResourceCondition::integrationPack)).apply((Applicative)instance, IntegrationPackActiveResourceCondition::new));
        public static ResourceConditionType<IntegrationPackActiveResourceCondition> TYPE = ResourceConditionType.create((class_2960)SpectrumCommon.locate("integration_pack_active"), CODEC);

        public ResourceConditionType<?> getType() {
            return TYPE;
        }

        public boolean test(@Nullable class_7225.class_7874 wrapperLookup) {
            return SpectrumIntegrationPacks.isIntegrationPackActive(this.integrationPack);
        }
    }
}

