/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.api.entity.PlayerEntityAccessor;
import de.dafuqs.spectrum.api.item.ActivatableItem;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.api.item.SlotReservingItem;
import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.components.WrappedPresentComponent;
import de.dafuqs.spectrum.items.magic_items.EnderSpliceItem;
import de.dafuqs.spectrum.items.magic_items.PipeBombItem;
import de.dafuqs.spectrum.items.magic_items.StructureCompassItem;
import de.dafuqs.spectrum.items.tools.MalachiteCrossbowItem;
import de.dafuqs.spectrum.items.tools.SpectrumFishingRodItem;
import de.dafuqs.spectrum.items.trinkets.AshenCircletItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import net.minecraft.class_7391;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class SpectrumModelPredicateProviders {
    public static void registerClient() {
        SpectrumModelPredicateProviders.registerBowPredicates((class_1792)SpectrumItems.BEDROCK_BOW);
        SpectrumModelPredicateProviders.registerCrossbowPredicates((class_1792)SpectrumItems.BEDROCK_CROSSBOW);
        SpectrumModelPredicateProviders.registerSpectrumFishingRodItemPredicates((class_1792)SpectrumItems.LAGOON_ROD);
        SpectrumModelPredicateProviders.registerSpectrumFishingRodItemPredicates((class_1792)SpectrumItems.MOLTEN_ROD);
        SpectrumModelPredicateProviders.registerSpectrumFishingRodItemPredicates((class_1792)SpectrumItems.BEDROCK_FISHING_ROD);
        SpectrumModelPredicateProviders.registerEnderSplicePredicates(SpectrumItems.ENDER_SPLICE);
        SpectrumModelPredicateProviders.registerAnimatedWandPredicates(SpectrumItems.NATURES_STAFF);
        SpectrumModelPredicateProviders.registerAnimatedWandPredicates(SpectrumItems.RADIANCE_STAFF);
        SpectrumModelPredicateProviders.registerAnimatedWandPredicates(SpectrumItems.STAFF_OF_REMEMBRANCE);
        SpectrumModelPredicateProviders.registerKnowledgeDropPredicates(SpectrumItems.KNOWLEDGE_GEM);
        SpectrumModelPredicateProviders.registerAshenCircletPredicates(SpectrumItems.ASHEN_CIRCLET);
        SpectrumModelPredicateProviders.registerInkFillStateItemPredicate(SpectrumItems.INK_FLASK);
        SpectrumModelPredicateProviders.registerMoonPhasePredicates(SpectrumItems.CRESCENT_CLOCK);
        SpectrumModelPredicateProviders.registerActivatableItemPredicate((class_1792)SpectrumItems.DREAMFLAYER);
        SpectrumModelPredicateProviders.registerNullableInkColorPredicate(SpectrumItems.PAINTBRUSH);
        SpectrumModelPredicateProviders.registerSlotReservingItem((class_1792)SpectrumItems.DRAGON_TALON);
        SpectrumModelPredicateProviders.registerSlotReservingItem((class_1792)SpectrumItems.DRACONIC_TWINSWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.MALACHITE_WORKSTAFF);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.MALACHITE_ULTRA_GREATSWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.MALACHITE_CROSSBOW);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.MALACHITE_BIDENT);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.GLASS_CREST_WORKSTAFF);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.GLASS_CREST_ULTRA_GREATSWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.GLASS_CREST_CROSSBOW);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.FEROCIOUS_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.FRACTAL_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.OMNI_ACCELERATOR);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.DREAMFLAYER);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.KNOTTED_SWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.NECTAR_LANCE);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.DRACONIC_TWINSWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate((class_1792)SpectrumItems.DRAGON_TALON);
        SpectrumModelPredicateProviders.registerBidentThrowingItemPredicate((class_1792)SpectrumItems.MALACHITE_BIDENT);
        SpectrumModelPredicateProviders.registerBidentThrowingItemPredicate((class_1792)SpectrumItems.FEROCIOUS_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerBidentThrowingItemPredicate((class_1792)SpectrumItems.FRACTAL_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerMalachiteCrossbowPredicates((class_1792)SpectrumItems.MALACHITE_CROSSBOW);
        SpectrumModelPredicateProviders.registerMalachiteCrossbowPredicates((class_1792)SpectrumItems.GLASS_CREST_CROSSBOW);
        SpectrumModelPredicateProviders.registerBottomlessBundlePredicates(SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389());
        SpectrumModelPredicateProviders.registerEnchantmentCanvasPredicates(SpectrumItems.ENCHANTMENT_CANVAS);
        SpectrumModelPredicateProviders.registerPresentPredicates(SpectrumBlocks.PRESENT.method_8389());
        SpectrumModelPredicateProviders.registerMysteriousLocketPredicates(SpectrumItems.MYSTERIOUS_LOCKET);
        SpectrumModelPredicateProviders.registerStructureCompassPredicates(SpectrumItems.MYSTERIOUS_COMPASS);
        SpectrumModelPredicateProviders.registerPipeBombPredicates(SpectrumItems.PIPE_BOMB);
    }

    private static void registerNullableInkColorPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"has_ink_color"), (stack, clientWorld, entity, i) -> {
            InkColor color = (InkColor)stack.method_57824(SpectrumDataComponentTypes.INK_COLOR);
            return color == null ? 0.0f : 1.0f;
        });
    }

    private static void registerMysteriousLocketPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"socketed"), (stack, world, entity, i) -> stack.method_57826(SpectrumDataComponentTypes.SOCKETED) ? 1.0f : 0.0f);
    }

    private static void registerStructureCompassPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"angle"), (class_6395)new class_7391((world, stack, entity) -> StructureCompassItem.getStructurePos(stack)));
    }

    private static void registerMalachiteCrossbowPredicates(class_1792 crossbowItem) {
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"pull"), (stack, world, user, i) -> user == null || class_1764.method_7781((class_1799)stack) ? 0.0f : (float)(stack.method_7935(user) - user.method_6014()) / (float)class_1764.method_7775((class_1799)stack, (class_1309)user));
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"pulling"), (stack, world, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack && !class_1764.method_7781((class_1799)stack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"charged"), (stack, world, entity, i) -> entity != null && class_1764.method_7781((class_1799)stack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"projectile"), (stack, world, entity, seed) -> {
            if (stack == null) {
                return 0.0f;
            }
            class_1799 projectile = MalachiteCrossbowItem.getFirstProjectile(stack);
            if (projectile.method_7960()) {
                return 0.0f;
            }
            if (projectile.method_31574(class_1802.field_8639)) {
                return 0.1f;
            }
            if (projectile.method_31574(SpectrumItems.MALACHITE_GLASS_ARROW)) {
                return 0.2f;
            }
            if (projectile.method_31574(SpectrumItems.TOPAZ_GLASS_ARROW)) {
                return 0.3f;
            }
            if (projectile.method_31574(SpectrumItems.AMETHYST_GLASS_ARROW)) {
                return 0.4f;
            }
            if (projectile.method_31574(SpectrumItems.CITRINE_GLASS_ARROW)) {
                return 0.5f;
            }
            if (projectile.method_31574(SpectrumItems.ONYX_GLASS_ARROW)) {
                return 0.6f;
            }
            if (projectile.method_31574(SpectrumItems.MOONSTONE_GLASS_ARROW)) {
                return 0.7f;
            }
            return 0.0f;
        });
    }

    private static void registerBidentThrowingItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"bident_throwing"), (stack, world, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 0.5f : 0.0f);
    }

    private static void registerPresentPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"variant"), (stack, world, entity, i) -> (float)((WrappedPresentComponent)stack.method_57825(SpectrumDataComponentTypes.WRAPPED_PRESENT, (Object)WrappedPresentComponent.DEFAULT)).variant().ordinal() / 10.0f);
    }

    private static void registerBottomlessBundlePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"locked"), (stack, world, entity, i) -> BottomlessBundleItem.isLocked(stack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"filled"), (stack, world, entity, i) -> BottomlessBundleItem.getStoredAmount(stack) > 0L ? 1.0f : 0.0f);
    }

    private static void registerMoonPhasePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"phase"), (stack, world, entity, i) -> {
            class_1937 patt0$temp;
            class_1309 holder;
            Object object = holder = entity != null ? entity : stack.method_27319();
            if (entity == null) {
                return 0.0f;
            }
            if (world == null && (patt0$temp = holder.method_37908()) instanceof class_638) {
                class_638 clientWorld;
                world = clientWorld = (class_638)patt0$temp;
            }
            if (world == null) {
                return 0.0f;
            }
            if (!world.method_8597().comp_645()) {
                return 1.0f;
            }
            return (float)world.method_30273() / 8.0f;
        });
    }

    private static void registerActivatableItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"activated"), (stack, world, entity, i) -> ActivatableItem.isActivated(stack) ? 1.0f : 0.0f);
    }

    private static void registerSlotReservingItem(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"reserved"), (stack, world, entity, i) -> SlotReservingItem.isReservingSlot(stack) ? 1.0f : 0.0f);
    }

    private static void registerOversizedItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"oversized"), (stack, world, entity, seed) -> seed == 817210941 ? 1.0f : 0.0f);
    }

    private static void registerBowPredicates(class_1792 bowItem) {
        class_5272.method_27879((class_1792)bowItem, (class_2960)class_2960.method_60654((String)"pull"), (stack, world, entity, i) -> entity == null || entity.method_6030() != stack ? 0.0f : (float)(stack.method_7935(entity) - entity.method_6014()) / 20.0f);
        class_5272.method_27879((class_1792)bowItem, (class_2960)class_2960.method_60654((String)"pulling"), (stack, world, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
    }

    private static void registerCrossbowPredicates(class_1792 crossbowItem) {
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"pull"), (stack, world, entity, i) -> entity == null || class_1764.method_7781((class_1799)stack) ? 0.0f : (float)(stack.method_7935(entity) - entity.method_6014()) / (float)class_1764.method_7775((class_1799)stack, (class_1309)entity));
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"pulling"), (stack, world, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack && !class_1764.method_7781((class_1799)stack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"charged"), (stack, world, entity, i) -> entity != null && class_1764.method_7781((class_1799)stack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)class_2960.method_60654((String)"firework"), (stack, world, entity, seed) -> ((class_9278)stack.method_57825(class_9334.field_49649, (Object)class_9278.field_49298)).method_57438(class_1802.field_8639) ? 1.0f : 0.0f);
    }

    private static void registerPipeBombPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"armed"), (stack, world, entity, seed) -> PipeBombItem.isPrimed(stack) ? 1.0f : 0.0f);
    }

    private static void registerSpectrumFishingRodItemPredicates(class_1792 fishingRodItem) {
        class_5272.method_27879((class_1792)fishingRodItem, (class_2960)class_2960.method_60654((String)"cast"), (stack, world, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            boolean isInMainHand = entity.method_6047() == stack;
            boolean isInOffhand = entity.method_6079() == stack && !(entity.method_6047().method_7909() instanceof SpectrumFishingRodItem);
            return (isInMainHand || isInOffhand) && entity instanceof class_1657 && ((PlayerEntityAccessor)entity).getSpectrumBobber() != null ? 1.0f : 0.0f;
        });
    }

    private static void registerEnderSplicePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"bound"), (stack, world, entity, i) -> EnderSpliceItem.hasTeleportTarget(stack) ? 1.0f : 0.0f);
    }

    private static void registerAshenCircletPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"cooldown"), (stack, world, entity, i) -> world != null && AshenCircletItem.getCooldownTicks(stack, (class_1937)world) == 0L ? 0.0f : 1.0f);
    }

    private static void registerAnimatedWandPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"in_use"), (stack, world, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
    }

    private static void registerKnowledgeDropPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"stored_experience_10000"), (stack, world, entity, i) -> (float)ExperienceStorageItem.getStoredExperience(stack) / 10000.0f);
    }

    private static void registerInkFillStateItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"fill_state"), (stack, world, entity, i) -> {
            SingleInkStorage storage = SpectrumItems.INK_FLASK.getEnergyStorage(stack);
            float current = storage.getCurrentTotal();
            float maximum = storage.getMaxTotal();
            return current == 0.0f || maximum == 0.0f ? 0.0f : Math.max(0.01f, current / maximum);
        });
    }

    private static void registerEnchantmentCanvasPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)class_2960.method_60654((String)"bound"), (stack, world, entity, i) -> stack.method_57826(SpectrumDataComponentTypes.BOUND_ITEM) ? 1.0f : 0.0f);
    }
}

