/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.sound;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.AzureAuraEmitting;
import de.dafuqs.spectrum.helpers.ParticleHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class BlockAuraSoundInstance
extends class_1102
implements class_1117 {
    public static final List<BlockAuraSoundInstance> INSTANCES = new ArrayList<BlockAuraSoundInstance>();
    private static final int MAX_DISTANCE = 48;
    private static final int SPACING = 16;
    private static final float MIN_VOLUME = 0.01f;
    private static final float MAX_VOLUME = 1.0f;
    private static final float VOLUME_EASING_STEPS = 0.01f;
    private static final List<class_2338> toRemove = new ArrayList<class_2338>();
    private int age = 0;
    private double absX;
    private double absY;
    private double absZ;
    private final Queue<class_2338> sources = new LinkedList<class_2338>();
    private final class_1937 world;
    private float volumeHold;

    private BlockAuraSoundInstance(class_3414 sound, class_1937 world, class_2338 source) {
        super(sound, class_3419.field_15256, class_1113.method_43221());
        this.field_5442 = 0.01f;
        this.volumeHold = 0.01f;
        this.field_5446 = true;
        this.field_5451 = 0;
        this.field_18936 = true;
        this.world = world;
        this.sources.add(source);
        this.updatePositionAndCount();
    }

    public void method_16896() {
        float targetVolume;
        ++this.age;
        if (this.age % 100 == 0) {
            this.sources.poll();
        }
        if (this.age % 10 == 0) {
            this.updatePositionAndCount();
        }
        if (this.volumeHold < (targetVolume = (float)class_3532.method_15350((double)((double)this.sources.size() * 0.05 - 0.5), (double)0.01f, (double)1.0) * SpectrumCommon.CONFIG.OreAuraSoundVolume)) {
            this.volumeHold += 0.01f;
        } else if (this.volumeHold > targetVolume) {
            this.volumeHold -= 0.01f;
        }
        double distance = class_3532.method_15390((double)1.0, (double)0.0, (double)(Math.sqrt(class_310.method_1551().method_1560().method_5649(this.absX, this.absY, this.absZ)) / 48.0));
        this.field_5442 = (float)((double)this.volumeHold * distance * 0.8);
        double cameraEntityEyeY = class_310.method_1551().method_1560().method_23320();
        double pitchMod = class_3532.method_15350((double)((Math.abs(cameraEntityEyeY - this.absY) - 4.0) / 196.0), (double)0.0, (double)0.225f);
        if (cameraEntityEyeY < this.absY) {
            pitchMod *= -1.0;
        }
        this.field_5441 = (float)(1.0 + pitchMod);
        if ((double)this.volumeHold > 0.25) {
            class_243 pos = new class_243(this.absX, this.absY, this.absZ);
            float chance = this.volumeHold / 2.0f;
            ParticleHelper.playTriangulatedParticle(this.world, (class_2394)SpectrumParticleTypes.AZURE_AURA, Support.getIntFromDecimalWithChance(chance * 3.0f, this.field_38800), true, new class_243(24.0, 8.0, 24.0), -4.0, true, pos, new class_243(0.0, 0.04 + this.field_38800.method_43058() * 0.06, 0.0));
            ParticleHelper.playTriangulatedParticle(this.world, (class_2394)SpectrumParticleTypes.AZURE_MOTE_SMALL, Support.getIntFromDecimalWithChance(chance, this.field_38800), false, new class_243(16.0, 8.0, 16.0), -6.0, false, pos, class_243.field_1353);
            ParticleHelper.playTriangulatedParticle(this.world, (class_2394)SpectrumParticleTypes.AZURE_MOTE, Support.getIntFromDecimalWithChance(chance, this.field_38800), true, new class_243(16.0, 6.0, 16.0), -4.0, false, pos, class_243.field_1353);
        }
    }

    private void updatePositionAndCount() {
        int x = 0;
        int y = 0;
        int z = 0;
        for (class_2338 source : this.sources) {
            if (!this.world.method_22340(source) || !(this.world.method_8320(source).method_26204() instanceof AzureAuraEmitting)) {
                toRemove.add(source);
                continue;
            }
            x += source.method_10263();
            y += source.method_10264();
            z += source.method_10260();
        }
        for (class_2338 source : toRemove) {
            this.sources.remove(source);
        }
        toRemove.clear();
        int count = this.sources.size();
        if (count > 0) {
            this.absX = (double)x / (double)count;
            this.absY = (double)y / (double)count;
            this.absZ = (double)z / (double)count;
        }
    }

    public boolean method_4793() {
        boolean done;
        if (this.field_5442 <= 0.0f) {
            done = true;
        } else {
            class_1297 cameraEntity = class_310.method_1551().method_1560();
            boolean bl = done = cameraEntity == null || cameraEntity.method_19538().method_1028(this.absX, this.absY, this.absZ) > 2304.0;
        }
        if (done) {
            INSTANCES.remove((Object)this);
        }
        return done;
    }

    public static void addToExistingInstanceOrCreateNewOne(class_1937 world, class_2338 pos) {
        double nearestDistance = Double.MAX_VALUE;
        BlockAuraSoundInstance nearest = null;
        for (BlockAuraSoundInstance instance : INSTANCES) {
            double squaredDistance = pos.method_40081(instance.absX, instance.absY, instance.absZ);
            if (!(squaredDistance < nearestDistance)) continue;
            nearestDistance = squaredDistance;
            nearest = instance;
        }
        if (nearestDistance < 4096.0) {
            if (nearest.sources.contains(pos)) {
                return;
            }
            nearest.sources.add(pos.method_10062());
        } else {
            BlockAuraSoundInstance newInstance = new BlockAuraSoundInstance(SpectrumSoundEvents.OST_AZURE, world, pos.method_10062());
            INSTANCES.add(newInstance);
            class_310.method_1551().method_1483().method_4873((class_1113)newInstance);
        }
    }

    public static void clear() {
        INSTANCES.forEach(i -> {
            i.field_5442 = -2.1474836E9f;
        });
        INSTANCES.clear();
    }
}

