/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.interaction;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.entity.entity.ItemProjectileEntity;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2968;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public interface ItemProjectileBehavior {
    public static final List<class_3545<class_2073, ItemProjectileBehavior>> BEHAVIORS = new ArrayList<class_3545<class_2073, ItemProjectileBehavior>>();
    public static final ItemProjectileBehavior DEFAULT = new Default();

    public static void register(ItemProjectileBehavior behavior, class_2073 predicate) {
        BEHAVIORS.add((class_3545<class_2073, ItemProjectileBehavior>)new class_3545((Object)predicate, (Object)behavior));
    }

    public static void register(ItemProjectileBehavior behavior, class_1792 ... items) {
        BEHAVIORS.add((class_3545<class_2073, ItemProjectileBehavior>)new class_3545((Object)class_2073.class_2074.method_8973().method_8977((class_1935[])items).method_8976(), (Object)behavior));
    }

    public static void register(ItemProjectileBehavior behavior, class_6862<class_1792> tag) {
        BEHAVIORS.add((class_3545<class_2073, ItemProjectileBehavior>)new class_3545((Object)class_2073.class_2074.method_8973().method_8975(tag).method_8976(), (Object)behavior));
    }

    public static ItemProjectileBehavior get(class_1799 stack) {
        for (class_3545<class_2073, ItemProjectileBehavior> entry : BEHAVIORS) {
            if (!((class_2073)entry.method_15442()).method_8970(stack)) continue;
            return (ItemProjectileBehavior)entry.method_15441();
        }
        return DEFAULT;
    }

    public class_1799 onEntityHit(ItemProjectileEntity var1, class_1799 var2, @Nullable class_1297 var3, class_3966 var4);

    public class_1799 onBlockHit(ItemProjectileEntity var1, class_1799 var2, @Nullable class_1297 var3, class_3965 var4);

    public static ItemProjectileBehavior damaging(final float damage, final boolean destroyItemOnHit) {
        return new Damaging(){

            @Override
            public boolean destroyItemOnHit() {
                return destroyItemOnHit;
            }

            @Override
            public boolean dealDamage(class_3857 projectile, class_1297 owner, class_1297 target) {
                return target.method_5643(target.method_48923().method_48811((class_1297)projectile, owner), damage);
            }
        };
    }

    public static class Default
    implements ItemProjectileBehavior {
        @Override
        public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3966 hitResult) {
            class_1657 player;
            class_1297 target = hitResult.method_17782();
            if (target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325())) {
                return stack;
            }
            if (stack.method_31573(class_3489.field_41662) && target instanceof class_1548) {
                class_1548 creeperEntity = (class_1548)target;
                class_1937 world = projectile.method_37908();
                class_3414 soundEvent = stack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
                world.method_43128(null, projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), soundEvent, projectile.method_5634(), 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
                creeperEntity.method_7004();
                if (stack.method_7963()) {
                    stack.method_7970(1, world.method_8409(), null);
                } else {
                    boolean isUnbreakable;
                    class_2487 nbtCompound = stack.method_7969();
                    boolean bl = isUnbreakable = nbtCompound != null && nbtCompound.method_10577("Unbreakable");
                    if (!isUnbreakable) {
                        stack.method_7934(1);
                    }
                }
            }
            if (target instanceof class_1309) {
                class_1657 playerOwner;
                class_1309 livingTarget = (class_1309)target;
                if (target instanceof class_1657 && !SpectrumCommon.CONFIG.OmniAcceleratorPvP && stack.method_31573(SpectrumItemTags.REQUIRES_OMNI_ACCELERATOR_PVP_ENABLED)) {
                    return stack;
                }
                if (owner instanceof class_1657 && stack.method_7920(playerOwner = (class_1657)owner, livingTarget, class_1268.field_5808).method_23665()) {
                    return stack;
                }
                stack.method_7909().method_7861(stack, livingTarget.method_37908(), livingTarget);
            }
            return stack;
        }

        @Override
        public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3965 hitResult) {
            class_2350 placementDirection;
            class_1937 world = projectile.method_37908();
            class_2338 hitPos = hitResult.method_17777();
            hitResult.method_17779(hitResult.method_17780());
            class_2350 facing = hitResult.method_17780().method_10153();
            class_2338 placementPos = hitPos.method_10093(facing.method_10153());
            class_2350 class_23502 = placementDirection = world.method_22347(placementPos.method_10074()) ? facing : class_2350.field_11036;
            if (!GenericClaimModsCompat.canPlaceBlock(world, placementPos, owner)) {
                return stack;
            }
            try {
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1747) {
                    class_1747 blockItem = (class_1747)class_17922;
                    blockItem.method_7712((class_1750)new ItemProjectilePlacementContext(world, projectile, hitResult));
                } else {
                    stack.method_7981((class_1838)new class_2968(world, placementPos, facing, stack, placementDirection));
                }
            }
            catch (Exception e) {
                SpectrumCommon.logError("Item Projectile failed to use item " + String.valueOf(stack.method_7909().method_7848()));
                e.printStackTrace();
            }
            return stack;
        }
    }

    public static class ItemProjectilePlacementContext
    extends class_1750 {
        ItemProjectileEntity itemProjectileEntity;

        public ItemProjectilePlacementContext(class_1937 world, ItemProjectileEntity itemProjectileEntity, class_3965 blockHitResult) {
            super(world, null, class_1268.field_5808, itemProjectileEntity.method_7495(), blockHitResult);
            this.itemProjectileEntity = itemProjectileEntity;
        }

        public class_2350 method_7715() {
            return class_2350.method_32801((class_1297)this.itemProjectileEntity, (class_2350.class_2351)class_2350.class_2351.field_11052);
        }

        public class_2350 method_32760() {
            return this.itemProjectileEntity.method_5695(1.0f) < 0.0f ? class_2350.field_11036 : class_2350.field_11033;
        }

        public class_2350[] method_7718() {
            int i;
            class_2350[] directions = class_2350.method_10159((class_1297)this.itemProjectileEntity);
            if (this.field_7904) {
                return directions;
            }
            class_2350 direction = this.method_8038();
            for (i = 0; i < directions.length && directions[i] != direction.method_10153(); ++i) {
            }
            if (i > 0) {
                System.arraycopy(directions, 0, directions, 1, i);
                directions[0] = direction.method_10153();
            }
            return directions;
        }
    }

    public static abstract class Damaging
    implements ItemProjectileBehavior {
        @Override
        public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3966 hitResult) {
            class_1297 target = hitResult.method_17782();
            if (owner instanceof class_1309) {
                class_1309 livingOwner = (class_1309)owner;
                livingOwner.method_6114(target);
            }
            if (this.dealDamage(projectile, owner, target)) {
                int targetFireTicks = target.method_20802();
                if (projectile.method_5809()) {
                    target.method_20803(targetFireTicks);
                }
                if (target instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)target;
                    if (!target.method_37908().method_8608() && owner instanceof class_1309) {
                        class_1309 livingOwner = (class_1309)owner;
                        class_1890.method_8210((class_1309)livingTarget, (class_1297)livingOwner);
                        class_1890.method_8213((class_1309)livingOwner, (class_1297)target);
                    }
                    if (target != owner && target instanceof class_1657 && owner instanceof class_3222) {
                        class_3222 serverPlayerOwner = (class_3222)owner;
                        if (!projectile.method_5701()) {
                            serverPlayerOwner.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                        }
                    }
                    projectile.method_5783(SpectrumSoundEvents.BLOCK_CITRINE_CLUSTER_HIT, 1.0f, 1.2f / (projectile.method_37908().method_8409().method_43057() * 0.2f + 0.9f));
                }
            }
            if (this.destroyItemOnHit()) {
                stack.method_7934(1);
            }
            return stack;
        }

        public abstract boolean destroyItemOnHit();

        public abstract boolean dealDamage(class_3857 var1, class_1297 var2, class_1297 var3);

        @Override
        public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3965 hitResult) {
            if (this.destroyItemOnHit()) {
                stack.method_7934(1);
            }
            return stack;
        }
    }
}

