/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.cinderhearth;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import de.dafuqs.spectrum.blocks.cinderhearth.CinderhearthBlockEntity;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CinderhearthBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;

    public CinderhearthBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11034));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CinderhearthBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return null;
        }
        return CinderhearthBlock.method_31618(type, SpectrumBlockEntities.CINDERHEARTH, CinderhearthBlockEntity::serverTick);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            CinderhearthBlock.verifyStructure(world, pos, null);
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CinderhearthBlockEntity) {
            CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
            cinderhearthBlockEntity.setOwner(player);
            if (CinderhearthBlock.verifyStructure(world, pos, (class_3222)player) != CinderhearthBlockEntity.CinderHearthStructureType.NONE) {
                player.method_17355((class_3908)cinderhearthBlockEntity);
            }
        }
        return class_1269.field_21466;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CinderhearthBlockEntity) {
            CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
            if (placer instanceof class_1657) {
                class_1657 player = (class_1657)placer;
                cinderhearthBlockEntity.setOwner(player);
            }
            if (itemStack.method_7938()) {
                cinderhearthBlockEntity.method_17488(itemStack.method_7964());
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CinderhearthBlockEntity) {
                CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
                if (world instanceof class_3218) {
                    class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)cinderhearthBlockEntity);
                }
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CinderhearthBlockEntity) {
            CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
            class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
            class_2350.class_2351 axis = direction.method_10166();
            double d = (double)pos.method_10263() + 0.5;
            double e = (double)pos.method_10264() + 0.4;
            double f = (double)pos.method_10260() + 0.5;
            class_1860<?> recipe = cinderhearthBlockEntity.getCurrentRecipe();
            if (recipe != null) {
                if (random.method_43058() < 0.1) {
                    world.method_8486(d, e, f, class_3417.field_15006, class_3419.field_15245, 1.0f, 0.8f, false);
                }
                double g = 0.35;
                double h = random.method_43058() * 0.4 - 0.2;
                double i = axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * g : h;
                double j = random.method_43058() * 4.0 / 16.0;
                double k = axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * g : h;
                world.method_8406((class_2394)class_2398.field_11240, d + i, e + j, f + k, 0.0, 0.0, 0.0);
                world.method_8406((class_2394)class_2398.field_11251, d + i, e + j, f + k, 0.0, 0.0, 0.0);
                if (random.method_43056()) {
                    double g2 = -0.1875;
                    double h2 = 0.25;
                    double i2 = axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * g2 : h2;
                    double k2 = axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * g2 : h2;
                    world.method_8406((class_2394)class_2398.field_11204, d + i2, (double)pos.method_10264() + 1.1, f + k2, 0.0, 0.06, 0.0);
                }
            }
            if (cinderhearthBlockEntity.structure == CinderhearthBlockEntity.CinderHearthStructureType.WITH_LAVA) {
                for (int v = 0; v < 2; ++v) {
                    double g3 = 1.5 - random.method_43058() * 2.0;
                    double h3 = 1.5 - random.method_43058() * 3.0;
                    double i3 = axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * g3 : h3;
                    double k3 = axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * g3 : h3;
                    world.method_8406((class_2394)SpectrumParticleTypes.ORANGE_SPARKLE_RISING, d + i3, (double)pos.method_10264() - 1.2, f + k3, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public static CinderhearthBlockEntity.CinderHearthStructureType verifyStructure(class_1937 world, @NotNull class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        boolean structureValid;
        class_2470 rotation = Support.rotationFromDirection(((class_2350)world.method_8320(blockPos).method_11654((class_2769)FACING)).method_10153());
        Multiblock multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.CINDERHEARTH);
        CinderhearthBlockEntity.CinderHearthStructureType completedStructure = CinderhearthBlockEntity.CinderHearthStructureType.NONE;
        if (multiblock.validate(world, blockPos.method_10087(3), rotation)) {
            completedStructure = CinderhearthBlockEntity.CinderHearthStructureType.WITH_LAVA;
        } else {
            multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.CINDERHEARTH_WITHOUT_LAVA);
            if (multiblock.validate(world, blockPos.method_10087(3), rotation)) {
                completedStructure = CinderhearthBlockEntity.CinderHearthStructureType.WITHOUT_LAVA;
            }
        }
        boolean bl = structureValid = completedStructure != CinderhearthBlockEntity.CinderHearthStructureType.NONE;
        if (world.field_9236) {
            if (!structureValid) {
                ModonomiconHelper.renderMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.CINDERHEARTH), SpectrumMultiblocks.CINDERHEARTH_TEXT, blockPos.method_10087(4), rotation);
            }
        } else if (structureValid && serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
        }
        return completedStructure;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.CINDERHEARTH));
        }
    }
}

