/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.crystallarieum;

import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.crystallarieum.CrystallarieumBlock;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.NullableDyeColor;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TickLooper;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumCatalyst;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumBlockEntity
extends InWorldInteractionBlockEntity
implements PlayerOwned,
InkStorageBlockEntity<IndividualCappedInkStorage> {
    protected static final int CATALYST_SLOT_ID = 0;
    protected static final int INK_STORAGE_STACK_SLOT_ID = 1;
    protected static final int INVENTORY_SIZE = 2;
    public static final long INK_STORAGE_SIZE = 409600L;
    protected IndividualCappedInkStorage inkStorage;
    protected boolean inkDirty;
    @Nullable
    protected UUID ownerUUID;
    @Nullable
    protected CrystallarieumRecipe currentRecipe;
    protected CrystallarieumCatalyst currentCatalyst = CrystallarieumCatalyst.EMPTY;
    public static final int SECOND = 20;
    protected TickLooper tickLooper = new TickLooper(20);
    protected int currentGrowthStageTicks;
    protected boolean canWork = true;

    public CrystallarieumBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.CRYSTALLARIEUM, pos, state, 2);
        this.inkStorage = new IndividualCappedInkStorage(409600L);
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, CrystallarieumBlockEntity crystallarieum) {
        if (crystallarieum.canWork && crystallarieum.currentRecipe != null) {
            class_2394 particleEffect = SpectrumParticleTypes.getSparkleRisingParticle(crystallarieum.currentRecipe.getInkColor().getDyeColor());
            int amount = 1 + crystallarieum.currentRecipe.getInkPerSecond();
            if (Support.getIntFromDecimalWithChance((double)amount / 80.0, world.field_9229) > 0) {
                double randomX = world.method_8409().method_43058() * 0.8;
                double randomZ = world.method_8409().method_43058() * 0.8;
                world.method_8494(particleEffect, (double)blockPos.method_10263() + 0.1 + randomX, (double)(blockPos.method_10264() + 1), (double)blockPos.method_10260() + 0.1 + randomZ, 0.0, 0.03, 0.0);
            }
        }
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, CrystallarieumBlockEntity crystallarieum) {
        if (crystallarieum.canWork) {
            CrystallarieumBlockEntity.transferInk(crystallarieum);
            CrystallarieumRecipe recipe = crystallarieum.currentRecipe;
            if (recipe != null) {
                crystallarieum.tickLooper.tick();
                if (crystallarieum.tickLooper.reachedCap()) {
                    CrystallarieumBlockEntity.tickRecipe(world, blockPos, crystallarieum, recipe);
                    crystallarieum.tickLooper.reset();
                }
            }
        }
    }

    private static void tickRecipe(@NotNull class_1937 world, class_2338 blockPos, CrystallarieumBlockEntity crystallarieum, @NotNull CrystallarieumRecipe recipe) {
        if (crystallarieum.currentCatalyst == CrystallarieumCatalyst.EMPTY && !recipe.growsWithoutCatalyst()) {
            return;
        }
        if (crystallarieum.inkStorage.getEnergy(recipe.getInkColor()) == 0L) {
            return;
        }
        float consumedInkFloat = (float)recipe.getInkPerSecond() * crystallarieum.currentCatalyst.growthAccelerationMod * crystallarieum.currentCatalyst.inkConsumptionMod;
        int consumedInt = Support.getIntFromDecimalWithChance(consumedInkFloat, world.field_9229);
        if (crystallarieum.inkStorage.drainEnergy(recipe.getInkColor(), consumedInt) < (long)consumedInt) {
            crystallarieum.canWork = false;
            crystallarieum.setInkDirty();
            crystallarieum.updateInClientWorld();
            return;
        }
        crystallarieum.setInkDirty();
        crystallarieum.currentGrowthStageTicks = (int)((float)crystallarieum.currentGrowthStageTicks + 20.0f * crystallarieum.currentCatalyst.growthAccelerationMod);
        if (world.field_9229.method_43057() < crystallarieum.currentCatalyst.consumeChancePerSecond) {
            class_1799 catalystStack = crystallarieum.method_5438(0);
            catalystStack.method_7934(1);
            crystallarieum.updateInClientWorld();
            if (catalystStack.method_7960()) {
                crystallarieum.currentCatalyst = CrystallarieumCatalyst.EMPTY;
                if (!recipe.growsWithoutCatalyst()) {
                    crystallarieum.canWork = false;
                }
            }
        }
        if (crystallarieum.currentGrowthStageTicks >= recipe.getSecondsPerGrowthStage() * 20) {
            class_2338 topPos = blockPos.method_10084();
            class_2680 topState = world.method_8320(topPos);
            Optional<class_2680> nextState = recipe.getNextState(recipe, topState);
            if (nextState.isPresent()) {
                world.method_8501(topPos, nextState.get());
                class_3222 owner = (class_3222)crystallarieum.getOwnerIfOnline();
                if (owner != null) {
                    SpectrumAdvancementCriteria.CRYSTALLARIEUM_GROWING.trigger(owner, (class_3218)world, topPos, crystallarieum.method_5438(0));
                }
            } else {
                crystallarieum.canWork = false;
            }
            crystallarieum.currentGrowthStageTicks = 0;
        }
    }

    private static void transferInk(CrystallarieumBlockEntity crystallarieum) {
        InkStorageItem inkStorageItem;
        Object itemInkStorage;
        long transferredAmount;
        class_1799 inkStorageStack = crystallarieum.method_5438(1);
        class_1792 class_17922 = inkStorageStack.method_7909();
        if (class_17922 instanceof InkStorageItem && (transferredAmount = InkStorage.transferInk(itemInkStorage = (inkStorageItem = (InkStorageItem)class_17922).getEnergyStorage(inkStorageStack), crystallarieum.inkStorage)) > 0L) {
            inkStorageItem.setEnergyStorage(inkStorageStack, (InkStorage)itemInkStorage);
        }
    }

    @Override
    public void inventoryChanged() {
        if (this.currentRecipe == null) {
            this.currentCatalyst = CrystallarieumCatalyst.EMPTY;
            this.canWork = false;
        } else {
            this.currentCatalyst = this.currentRecipe.getCatalyst(this.method_5438(0));
            class_2680 topState = this.field_11863.method_8320(this.field_11867.method_10084());
            this.canWork = this.currentRecipe.getNextState(this.currentRecipe, topState).isPresent() && (this.currentRecipe.growsWithoutCatalyst() || this.currentCatalyst != CrystallarieumCatalyst.EMPTY);
        }
        super.inventoryChanged();
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("InkStorage", 10)) {
            this.inkStorage = IndividualCappedInkStorage.fromNbt(nbt.method_10562("InkStorage"));
        }
        if (nbt.method_10573("Looper", 10)) {
            this.tickLooper.readNbt(nbt.method_10562("Looper"));
        }
        this.canWork = nbt.method_10577("CanWork");
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentCatalyst = CrystallarieumCatalyst.EMPTY;
        this.currentRecipe = MultiblockCrafter.getRecipeFromNbt(this.field_11863, nbt, CrystallarieumRecipe.class);
        this.currentGrowthStageTicks = nbt.method_10550("CurrentGrowthStageDuration");
        if (this.currentRecipe != null) {
            this.currentCatalyst = this.currentRecipe.getCatalyst(this.method_5438(0));
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("InkStorage", (class_2520)this.inkStorage.toNbt());
        nbt.method_10566("Looper", this.tickLooper.toNbt());
        nbt.method_10556("CanWork", this.canWork);
        nbt.method_10569("CurrentGrowthStageDuration", this.currentGrowthStageTicks);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    public void acceptStack(class_1799 itemStack, boolean creative, @Nullable UUID player) {
        InkStorageItem inkStorageItem;
        boolean changed = false;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof InkStorageItem && (inkStorageItem = (InkStorageItem)class_17922).getDrainability().canDrain(false)) {
            class_1799 currentInkStorageStack = this.method_5438(1);
            if (currentInkStorageStack.method_7960()) {
                this.method_5447(1, itemStack.method_7972());
                if (!creative) {
                    itemStack.method_7939(0);
                }
                changed = true;
            }
        } else if (this.field_11863.method_8320(this.field_11867.method_10084()).method_26215()) {
            CrystallarieumRecipe recipe = CrystallarieumRecipe.getRecipeForStack(itemStack);
            if (recipe != null) {
                if (!creative) {
                    itemStack.method_7934(1);
                }
                class_2680 placedState = recipe.getGrowthStages().get(0);
                this.field_11863.method_8501(this.field_11867.method_10084(), placedState);
                this.onTopBlockChange(placedState, recipe);
                changed = true;
            }
        } else if (this.currentRecipe != null) {
            class_1799 currentCatalystStack = this.method_5438(0);
            if (currentCatalystStack.method_7960()) {
                CrystallarieumCatalyst catalyst = this.currentRecipe.getCatalyst(itemStack);
                if (catalyst != CrystallarieumCatalyst.EMPTY) {
                    this.method_5447(0, itemStack.method_7972());
                    if (!creative) {
                        itemStack.method_7939(0);
                    }
                    this.currentCatalyst = catalyst;
                    changed = true;
                }
            } else if (class_1799.method_31577((class_1799)currentCatalystStack, (class_1799)itemStack)) {
                InventoryHelper.combineStacks(currentCatalystStack, itemStack);
                changed = true;
            }
        }
        if (changed) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + this.field_11863.field_9229.method_43057() * 0.6f);
            if (player != null) {
                this.ownerUUID = player;
            }
            this.inventoryChanged();
        }
    }

    public void onTopBlockChange(class_2680 newState, @Nullable CrystallarieumRecipe recipe) {
        if (newState.method_26215()) {
            this.currentRecipe = null;
            this.canWork = false;
            this.method_5431();
            this.updateInClientWorld();
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657(CrystallarieumBlock.COLOR, (Comparable)((Object)NullableDyeColor.NONE)));
        } else {
            CrystallarieumRecipe crystallarieumRecipe = this.currentRecipe = recipe == null ? CrystallarieumRecipe.getRecipeForState(newState) : recipe;
            if (this.currentRecipe == null) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657(CrystallarieumBlock.COLOR, (Comparable)((Object)NullableDyeColor.NONE)));
            } else {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657(CrystallarieumBlock.COLOR, (Comparable)((Object)NullableDyeColor.get(this.currentRecipe.getInkColor().getDyeColor()))));
                class_1799 catalystStack = this.method_5438(0);
                if (!catalystStack.method_7960()) {
                    this.currentCatalyst = this.currentRecipe.getCatalyst(catalystStack);
                    if (this.currentCatalyst == CrystallarieumCatalyst.EMPTY) {
                        class_1542 itemEntity = new class_1542(this.field_11863, (double)this.method_11016().method_10263() + 0.5, (double)(this.method_11016().method_10264() + 1), (double)this.method_11016().method_10260() + 0.5, catalystStack);
                        this.method_5447(0, class_1799.field_8037);
                        this.field_11863.method_8649((class_1297)itemEntity);
                    }
                }
            }
            this.inventoryChanged();
        }
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 1) {
            return stack.method_7909() instanceof InkStorageItem;
        }
        if (this.currentRecipe != null) {
            return this.currentRecipe.getCatalyst(stack) != CrystallarieumCatalyst.EMPTY;
        }
        return false;
    }
}

