/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.deeper_down.flora;

import de.dafuqs.spectrum.helpers.BlockReference;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class TriStateVineBlock
extends class_2261
implements class_2256 {
    public static final class_2754<LifeStage> LIFE_STAGE = class_2754.method_11850((String)"life_stage", LifeStage.class);
    private final int minHeight;
    private final float growthTickChance;
    private final float spreadChance;
    private final float overgrowth;

    public TriStateVineBlock(class_4970.class_2251 settings, int minHeight, float growthChance, float spreadChance, float overgrowth) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657(LIFE_STAGE, (Comparable)((Object)LifeStage.GROWING)));
        this.minHeight = minHeight;
        this.growthTickChance = growthChance;
        this.spreadChance = spreadChance;
        this.overgrowth = overgrowth;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        BlockReference reference = BlockReference.of(state, pos);
        class_1799 handStack = player.method_5998(hand);
        boolean creative = player.method_31549().field_7477;
        if (handStack.method_31573(ConventionalItemTags.SHEARS)) {
            if (reference.getProperty(LIFE_STAGE) != LifeStage.GROWING) {
                return class_1269.field_5814;
            }
            if (!creative) {
                handStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
            reference.setProperty(LIFE_STAGE, LifeStage.MATURE);
            reference.update((class_1936)world);
            world.method_8396(null, pos, class_3417.field_20611, class_3419.field_15245, 1.0f, class_3532.method_32750((class_5819)world.field_9229, (float)0.6f, (float)1.0f));
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)reference.getState()));
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (handStack.method_31574(SpectrumItems.MOONSTRUCK_NECTAR)) {
            if (reference.getProperty(LIFE_STAGE) != LifeStage.MATURE) {
                return class_1269.field_5814;
            }
            if (!creative) {
                handStack.method_7934(1);
            }
            reference.setProperty(LIFE_STAGE, LifeStage.GROWING);
            reference.update((class_1936)world);
            world.method_8396(null, pos, class_3417.field_26980, class_3419.field_15245, 1.0f, class_3532.method_32750((class_5819)world.field_9229, (float)0.6f, (float)1.0f));
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)reference.getState()));
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2680 state = this.method_9564();
        BlockReference roof = BlockReference.of((class_1936)world, pos.method_10084());
        if (!this.method_9558(world.method_8320(pos), (class_4538)world, pos) || !world.method_22347(pos)) {
            return null;
        }
        if (roof.isOf((class_2248)this)) {
            state = (class_2680)state.method_11657(LIFE_STAGE, (Comparable)((Object)roof.getProperty(LIFE_STAGE)));
            roof.setProperty(LIFE_STAGE, LifeStage.STALK);
            roof.update((class_1936)world);
        }
        return state;
    }

    abstract boolean hasGrowthActions();

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
    }

    public boolean method_9542(class_2680 state) {
        return state.method_11654(LIFE_STAGE) != LifeStage.MATURE;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (random.method_43057() >= this.growthTickChance) {
            return;
        }
        BlockReference reference = BlockReference.of(state, pos);
        LifeStage stage = reference.getProperty(LIFE_STAGE);
        if (this.hasGrowthActions() && random.method_43056() || stage != LifeStage.GROWING) {
            this.method_9652(world, random, pos, state);
        } else {
            if (!this.method_9650((class_1937)world, random, pos, state) || random.method_43057() >= this.spreadChance) {
                return;
            }
            reference.setProperty(LIFE_STAGE, LifeStage.STALK);
            reference.update((class_1936)world);
            class_2680 sprigState = this.method_9564();
            int height = this.getCurrentHeight((class_1937)world, reference.pos);
            if (height >= this.minHeight && random.method_43057() >= this.overgrowth) {
                sprigState = (class_2680)sprigState.method_11657(LIFE_STAGE, (Comparable)((Object)LifeStage.MATURE));
            }
            world.method_8501(reference.pos.method_10074(), sprigState);
        }
    }

    protected int getCurrentHeight(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        int count = 0;
        while (state.method_27852((class_2248)this)) {
            state = world.method_8320(pos.method_10086(++count));
        }
        return count;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        BlockReference roof = BlockReference.of(world, pos.method_10084());
        if (roof.isOf((class_2248)this)) {
            roof.setProperty(LIFE_STAGE, this.getLowestLifeStage(world, pos.method_10074(), (LifeStage)((Object)state.method_11654(LIFE_STAGE))));
            roof.update(world);
        }
        this.scheduleBreakCheck(world, pos);
    }

    public LifeStage getLowestLifeStage(class_1936 world, class_2338 pos, LifeStage stage) {
        class_2680 state = world.method_8320(pos);
        LifeStage lastStage = stage;
        while (state.method_27852((class_2248)this)) {
            lastStage = (LifeStage)((Object)state.method_11654(LIFE_STAGE));
            pos = pos.method_10074();
            state = world.method_8320(pos);
        }
        return lastStage;
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state, boolean isClient) {
        return true;
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return world.method_22347(pos.method_10074());
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.method_9558(state, (class_4538)world, pos)) {
            return;
        }
        this.scheduleBreakCheck((class_1936)world, pos);
        world.method_22352(pos, true);
    }

    private void scheduleBreakCheck(class_1936 world, class_2338 pos) {
        class_2338 underside = pos.method_10074();
        if (world.method_8320(underside).method_27852((class_2248)this)) {
            world.method_39279(underside, (class_2248)this, 1);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!this.method_9558(state, (class_4538)world, pos)) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        return state;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 roof = pos.method_10084();
        class_2680 roofState = world.method_8320(roof);
        if (roofState.method_27852((class_2248)this)) {
            return true;
        }
        return this.method_9695(roofState, (class_1922)world, roof);
    }

    public boolean method_9695(class_2680 roof, class_1922 world, class_2338 pos) {
        return roof.method_26206(world, pos, class_2350.field_11033);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIFE_STAGE});
    }

    public float method_32913() {
        return 0.1f;
    }

    public float method_37247() {
        return -0.15f;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 vec3d = state.method_26226(world, pos);
        return super.method_9530(state, world, pos, context).method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public static enum LifeStage implements class_3542
    {
        STALK("stalk"),
        GROWING("growing"),
        MATURE("mature");

        private final String name;

        private LifeStage(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

