/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.particle_spawner;

import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class ParticleSpawnerConfiguration {
    private final class_2396<?> particleType;
    private final Vector3i cmyColor;
    private final boolean glowing;
    private final float particlesPerSecond;
    private final Vector3fc sourcePosition;
    private final Vector3fc sourcePositionVariance;
    private final Vector3fc velocity;
    private final Vector3fc velocityVariance;
    private final float scale;
    private final float scaleVariance;
    private final int lifetimeTicks;
    private final int lifetimeVariance;
    private final float gravity;
    private final boolean collisions;
    private final Vector3fc rgbColor;

    public ParticleSpawnerConfiguration(class_2396<?> particleType, Vector3i cmyColor, boolean glowing, float particlesPerSecond, Vector3fc sourcePosition, Vector3fc sourcePositionVariance, Vector3fc velocity, Vector3fc velocityVariance, float scale, float scaleVariance, int lifetimeTicks, int lifetimeVariance, float gravity, boolean collisions) {
        this.particleType = particleType;
        this.cmyColor = cmyColor;
        this.glowing = glowing;
        this.particlesPerSecond = particlesPerSecond;
        this.sourcePosition = sourcePosition;
        this.sourcePositionVariance = sourcePositionVariance;
        this.velocity = velocity;
        this.velocityVariance = velocityVariance;
        this.scale = scale;
        this.scaleVariance = scaleVariance;
        this.lifetimeTicks = lifetimeTicks;
        this.lifetimeVariance = lifetimeVariance;
        this.gravity = gravity;
        this.collisions = collisions;
        this.rgbColor = ParticleSpawnerConfiguration.CMYtoRGB(cmyColor);
    }

    public static Vector3fc CMYtoRGB(Vector3i cmy) {
        float r = 1.0f - (float)cmy.x() / 100.0f;
        float g = 1.0f - (float)cmy.y() / 100.0f;
        float b = 1.0f - (float)cmy.z() / 100.0f;
        return new Vector3f(r, g, b);
    }

    public class_2396<?> getParticleType() {
        return this.particleType;
    }

    public Vector3i getCmyColor() {
        return this.cmyColor;
    }

    public boolean glows() {
        return this.glowing;
    }

    public float getParticlesPerSecond() {
        return this.particlesPerSecond;
    }

    public Vector3fc getSourcePosition() {
        return this.sourcePosition;
    }

    public Vector3fc getSourcePositionVariance() {
        return this.sourcePositionVariance;
    }

    public Vector3fc getVelocity() {
        return this.velocity;
    }

    public Vector3fc getVelocityVariance() {
        return this.velocityVariance;
    }

    public float getScale() {
        return this.scale;
    }

    public float getScaleVariance() {
        return this.scaleVariance;
    }

    public int getLifetimeTicks() {
        return this.lifetimeTicks;
    }

    public int getLifetimeVariance() {
        return this.lifetimeVariance;
    }

    public float getGravity() {
        return this.gravity;
    }

    public boolean hasCollisions() {
        return this.collisions;
    }

    public void write(class_2540 buf) {
        buf.method_10814(class_7923.field_41180.method_10221(this.particleType).toString());
        buf.writeInt(this.cmyColor.x());
        buf.writeInt(this.cmyColor.y());
        buf.writeInt(this.cmyColor.z());
        buf.writeBoolean(this.glowing);
        buf.writeFloat(this.particlesPerSecond);
        buf.writeFloat(this.sourcePosition.x());
        buf.writeFloat(this.sourcePosition.y());
        buf.writeFloat(this.sourcePosition.z());
        buf.writeFloat(this.sourcePositionVariance.x());
        buf.writeFloat(this.sourcePositionVariance.y());
        buf.writeFloat(this.sourcePositionVariance.z());
        buf.writeFloat(this.velocity.x());
        buf.writeFloat(this.velocity.y());
        buf.writeFloat(this.velocity.z());
        buf.writeFloat(this.velocityVariance.x());
        buf.writeFloat(this.velocityVariance.y());
        buf.writeFloat(this.velocityVariance.z());
        buf.writeFloat(this.scale);
        buf.writeFloat(this.scaleVariance);
        buf.writeInt(this.lifetimeTicks);
        buf.writeInt(this.lifetimeVariance);
        buf.writeFloat(this.gravity);
        buf.writeBoolean(this.collisions);
    }

    public static ParticleSpawnerConfiguration fromBuf(class_2540 buf) {
        class_2960 particleIdentifier = new class_2960(buf.method_19772());
        class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(particleIdentifier);
        Vector3i cmyColor = new Vector3i(buf.readInt(), buf.readInt(), buf.readInt());
        boolean glowing = buf.readBoolean();
        float particlesPerSecond = buf.readFloat();
        Vector3f sourcePosition = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        Vector3f sourcePositionVariance = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        Vector3f velocity = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        Vector3f velocityVariance = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        float scale = buf.readFloat();
        float scaleVariance = buf.readFloat();
        int lifetimeTicks = buf.readInt();
        int lifetimeVariance = buf.readInt();
        float gravity = buf.readFloat();
        boolean collisions = buf.readBoolean();
        return new ParticleSpawnerConfiguration(particleType, cmyColor, glowing, particlesPerSecond, (Vector3fc)sourcePosition, (Vector3fc)sourcePositionVariance, (Vector3fc)velocity, (Vector3fc)velocityVariance, scale, scaleVariance, lifetimeTicks, lifetimeVariance, gravity, collisions);
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("particle_type_identifier", class_7923.field_41180.method_10221(this.particleType).toString());
        nbt.method_10548("particles_per_tick", this.particlesPerSecond);
        nbt.method_10556("glowing", this.glowing);
        nbt.method_10548("source_pos_x", this.sourcePosition.x());
        nbt.method_10548("source_pos_y", this.sourcePosition.y());
        nbt.method_10548("source_pos_z", this.sourcePosition.z());
        nbt.method_10548("source_pos_variance_x", this.sourcePositionVariance.x());
        nbt.method_10548("source_pos_variance_y", this.sourcePositionVariance.y());
        nbt.method_10548("source_pos_variance_z", this.sourcePositionVariance.z());
        nbt.method_10548("source_velocity_x", this.velocity.x());
        nbt.method_10548("source_velocity_y", this.velocity.y());
        nbt.method_10548("source_velocity_z", this.velocity.z());
        nbt.method_10548("source_velocity_variance_x", this.velocityVariance.x());
        nbt.method_10548("source_velocity_variance_y", this.velocityVariance.y());
        nbt.method_10548("source_velocity_variance_z", this.velocityVariance.z());
        nbt.method_10569("color_c", this.cmyColor.x());
        nbt.method_10569("color_m", this.cmyColor.y());
        nbt.method_10569("color_y", this.cmyColor.z());
        nbt.method_10548("scale", this.scale);
        nbt.method_10548("scale_variance", this.scaleVariance);
        nbt.method_10569("lifetime", this.lifetimeTicks);
        nbt.method_10569("lifetime_variance", this.lifetimeVariance);
        nbt.method_10548("gravity", this.gravity);
        nbt.method_10556("collisions", this.collisions);
        return nbt;
    }

    public static ParticleSpawnerConfiguration fromNbt(class_2487 tag) {
        class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(new class_2960(tag.method_10558("particle_type_identifier")));
        float particlesPerSecond = tag.method_10583("particles_per_tick");
        boolean glowing = tag.method_10577("glowing");
        Vector3f particleSourcePosition = new Vector3f(tag.method_10583("source_pos_x"), tag.method_10583("source_pos_y"), tag.method_10583("source_pos_z"));
        Vector3f particleSourcePositionVariance = new Vector3f(tag.method_10583("source_pos_variance_x"), tag.method_10583("source_pos_variance_y"), tag.method_10583("source_pos_variance_z"));
        Vector3f velocity = new Vector3f(tag.method_10583("source_velocity_x"), tag.method_10583("source_velocity_y"), tag.method_10583("source_velocity_z"));
        Vector3f velocityVariance = new Vector3f(tag.method_10583("source_velocity_variance_x"), tag.method_10583("source_velocity_variance_y"), tag.method_10583("source_velocity_variance_z"));
        Vector3i cmyColor = new Vector3i(tag.method_10550("color_c"), tag.method_10550("color_m"), tag.method_10550("color_y"));
        float scale = tag.method_10583("scale");
        float scaleVariance = tag.method_10583("scale_variance");
        int lifetimeTicks = tag.method_10550("lifetime");
        int lifetimeVariance = tag.method_10550("lifetime_variance");
        float gravity = tag.method_10583("gravity");
        boolean collisions = tag.method_10577("collisions");
        return new ParticleSpawnerConfiguration(particleType, cmyColor, glowing, particlesPerSecond, (Vector3fc)particleSourcePosition, (Vector3fc)particleSourcePositionVariance, (Vector3fc)velocity, (Vector3fc)velocityVariance, scale, scaleVariance, lifetimeTicks, lifetimeVariance, gravity, collisions);
    }

    public void spawnParticles(class_1937 world, @NotNull class_2338 pos) {
        for (float particlesToSpawn = this.particlesPerSecond / 20.0f; particlesToSpawn >= 1.0f || world.field_9229.method_43057() < particlesToSpawn; particlesToSpawn -= 1.0f) {
            this.spawnParticle(world, pos, world.field_9229);
        }
    }

    private void spawnParticle(class_1937 world, @NotNull class_2338 pos, class_5819 random) {
        int randomLifetime;
        float randomScale = this.scaleVariance == 0.0f ? this.scale : (float)((double)(this.scale + this.scaleVariance) - random.method_43058() * (double)this.scaleVariance * 2.0);
        int n = randomLifetime = this.lifetimeVariance == 0 ? this.lifetimeTicks : (int)((double)(this.lifetimeTicks + this.lifetimeVariance) - random.method_43058() * (double)this.lifetimeVariance * 2.0);
        if (randomScale > 0.0f && randomLifetime > 0) {
            double randomOffsetX = this.sourcePositionVariance.x() == 0.0f ? 0.0 : (double)this.sourcePositionVariance.x() - random.method_43058() * (double)this.sourcePositionVariance.x() * 2.0;
            double randomOffsetY = this.sourcePositionVariance.y() == 0.0f ? 0.0 : (double)this.sourcePositionVariance.y() - random.method_43058() * (double)this.sourcePositionVariance.y() * 2.0;
            double randomOffsetZ = this.sourcePositionVariance.z() == 0.0f ? 0.0 : (double)this.sourcePositionVariance.z() - random.method_43058() * (double)this.sourcePositionVariance.z() * 2.0;
            double randomVelocityX = this.velocityVariance.x() == 0.0f ? 0.0 : (double)this.velocityVariance.x() - random.method_43058() * (double)this.velocityVariance.x() * 2.0;
            double randomVelocityY = this.velocityVariance.y() == 0.0f ? 0.0 : (double)this.velocityVariance.y() - random.method_43058() * (double)this.velocityVariance.y() * 2.0;
            double randomVelocityZ = this.velocityVariance.z() == 0.0f ? 0.0 : (double)this.velocityVariance.z() - random.method_43058() * (double)this.velocityVariance.z() * 2.0;
            world.method_8406((class_2394)new DynamicParticleEffect(this.particleType, this.gravity, new Vector3f(this.rgbColor), randomScale, randomLifetime, this.collisions, this.glowing), (double)pos.method_10263() + 0.5 + (double)this.sourcePosition.x() + randomOffsetX, (double)pos.method_10264() + 0.5 + (double)this.sourcePosition.y() + randomOffsetY, (double)pos.method_10260() + 0.5 + (double)this.sourcePosition.z() + randomOffsetZ, (double)this.velocity.x() + randomVelocityX, (double)this.velocity.y() + randomVelocityY, (double)this.velocity.z() + randomVelocityZ);
        }
    }
}

