/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultEdge;

public class PastelTransmissionLogic {
    public static final int DEFAULT_MAX_TRANSFER_AMOUNT = 1;
    public static final int DEFAULT_TRANSFER_TICKS_PER_NODE = 30;
    private final ServerPastelNetwork network;
    private DijkstraShortestPath<class_2338, DefaultEdge> dijkstra;
    private Map<class_2338, Map<class_2338, GraphPath<class_2338, DefaultEdge>>> pathCache = new HashMap<class_2338, Map<class_2338, GraphPath<class_2338, DefaultEdge>>>();

    public PastelTransmissionLogic(ServerPastelNetwork network) {
        this.network = network;
    }

    public void invalidateCache() {
        this.dijkstra = null;
        this.pathCache = new HashMap<class_2338, Map<class_2338, GraphPath<class_2338, DefaultEdge>>>();
    }

    @Nullable
    public GraphPath<class_2338, DefaultEdge> getPath(Graph<class_2338, DefaultEdge> graph, PastelNodeBlockEntity source, PastelNodeBlockEntity destination) {
        Map e;
        if (this.dijkstra == null) {
            this.dijkstra = new DijkstraShortestPath(graph);
        }
        if ((e = (Map)this.pathCache.getOrDefault(source.method_11016(), null)) != null && e.containsKey(destination.method_11016())) {
            return (GraphPath)e.get(destination.method_11016());
        }
        ShortestPathAlgorithm.SingleSourcePaths paths = this.dijkstra.getPaths((Object)source.method_11016());
        GraphPath path = paths.getPath((Object)destination.method_11016());
        if (this.pathCache.containsKey(source.method_11016())) {
            this.pathCache.get(source.method_11016()).put(destination.method_11016(), (GraphPath<class_2338, DefaultEdge>)path);
        } else {
            HashMap<class_2338, GraphPath> newMap = new HashMap<class_2338, GraphPath>();
            newMap.put(destination.method_11016(), path);
            this.pathCache.put(source.method_11016(), newMap);
        }
        return path;
    }

    public void tick(PastelNetwork.NodePriority priority) {
        this.transferBetween(PastelNodeType.BUFFER, PastelNodeType.GATHER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.GATHER, TransferMode.PUSH_PULL, priority);
        this.transferBetween(PastelNodeType.PROVIDER, PastelNodeType.GATHER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.STORAGE, PastelNodeType.GATHER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.BUFFER, TransferMode.PUSH_PULL, priority);
        this.transferBetween(PastelNodeType.PROVIDER, PastelNodeType.BUFFER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.STORAGE, PastelNodeType.BUFFER, TransferMode.PULL, priority);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.STORAGE, TransferMode.PUSH, priority);
    }

    private void transferBetween(PastelNodeType sourceType, PastelNodeType destinationType, TransferMode transferMode, PastelNetwork.NodePriority priority) {
        for (PastelNodeBlockEntity sourceNode : this.network.getLoadedNodes(sourceType, priority)) {
            Storage<ItemVariant> sourceStorage;
            if (!sourceNode.canTransfer() || (sourceStorage = sourceNode.getConnectedStorage()) == null || !sourceStorage.supportsExtraction()) continue;
            this.tryTransferToType(sourceNode, sourceStorage, destinationType, transferMode);
        }
    }

    private void tryTransferToType(PastelNodeBlockEntity sourceNode, Storage<ItemVariant> sourceStorage, PastelNodeType type, TransferMode transferMode) {
        for (PastelNodeBlockEntity destinationNode : this.network.getLoadedNodes(type, PastelNetwork.NodePriority.GENERIC)) {
            boolean success;
            Storage<ItemVariant> destinationStorage;
            if (!destinationNode.canTransfer() || (destinationStorage = destinationNode.getConnectedStorage()) == null || !destinationStorage.supportsInsertion() || !(success = this.transferBetween(sourceNode, sourceStorage, destinationNode, destinationStorage, transferMode)) || transferMode == TransferMode.PULL) continue;
            return;
        }
    }

    private boolean transferBetween(PastelNodeBlockEntity sourceNode, Storage<ItemVariant> sourceStorage, PastelNodeBlockEntity destinationNode, Storage<ItemVariant> destinationStorage, TransferMode transferMode) {
        Predicate<ItemVariant> filter = sourceNode.getTransferFilterTo(destinationNode);
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : sourceStorage) {
                long storedAmount;
                ItemVariant storedResource;
                if (view.isResourceBlank() || (storedResource = (ItemVariant)view.getResource()).isBlank() || !filter.test(storedResource) || (storedAmount = view.getAmount()) <= 0L) continue;
                long transferrableAmount = sourceNode.getMaxTransferredAmount();
                int vertexTime = sourceNode.getTransferTime();
                long itemCountUnderway = destinationNode.getItemCountUnderway();
                transferrableAmount = (int)StorageUtil.simulateInsert(destinationStorage, (Object)storedResource, (long)(transferrableAmount + itemCountUnderway), (TransactionContext)transaction);
                if ((transferrableAmount -= itemCountUnderway) <= 0L || (transferrableAmount = sourceStorage.extract((Object)storedResource, transferrableAmount, (TransactionContext)transaction)) <= 0L) continue;
                Optional<PastelTransmission> optionalTransmission = this.createTransmissionOnValidPath(sourceNode, destinationNode, storedResource, transferrableAmount, vertexTime);
                if (!optionalTransmission.isPresent()) continue;
                PastelTransmission transmission = optionalTransmission.get();
                int travelTime = transmission.getTransmissionDuration();
                this.network.addTransmission(transmission, travelTime);
                SpectrumS2CPacketSender.sendPastelTransmissionParticle(this.network, travelTime, transmission);
                if (transferMode == TransferMode.PULL) {
                    destinationNode.markTransferred();
                } else if (transferMode == TransferMode.PUSH) {
                    sourceNode.markTransferred();
                } else {
                    destinationNode.markTransferred();
                    sourceNode.markTransferred();
                }
                destinationNode.addItemCountUnderway(transferrableAmount);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            transaction.abort();
        }
        return false;
    }

    public Optional<PastelTransmission> createTransmissionOnValidPath(PastelNodeBlockEntity source, PastelNodeBlockEntity destination, ItemVariant variant, long amount, int vertexTime) {
        GraphPath<class_2338, DefaultEdge> graphPath = this.getPath(this.network.getGraph(), source, destination);
        if (graphPath != null) {
            ArrayList<class_2338> vertexPositions = new ArrayList<class_2338>(graphPath.getVertexList());
            SpectrumS2CPacketSender.sendPastelNodeStatusUpdate(List.of(source), true);
            return Optional.of(new PastelTransmission(vertexPositions, variant, amount, vertexTime));
        }
        return Optional.empty();
    }

    private static enum TransferMode {
        PUSH,
        PULL,
        PUSH_PULL;

    }
}

