/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.cca;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.entity.PlayerEntityAccessor;
import de.dafuqs.spectrum.api.item.SleepAlteringItem;
import de.dafuqs.spectrum.mixin.accessors.StatusEffectInstanceAccessor;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumBiomes;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2783;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MiscPlayerDataComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final ComponentKey<MiscPlayerDataComponent> MISC_PLAYER_DATA_COMPONENT = ComponentRegistry.getOrCreate((class_2960)SpectrumCommon.locate("misc_player_data"), MiscPlayerDataComponent.class);
    public static final int MAX_DRAGONROT_TICKS = 12000;
    private final class_1657 player;
    private int ticksBeforeSleep = -1;
    private int sleepingWindow = -1;
    private int sleepInvincibility;
    private double lastSyncedSleepPotency = -2.0;
    private Optional<SleepAlteringItem> sleepConsumable = Optional.empty();
    private int dragonrotTicks = 0;
    private boolean isBeingAfflictedByDragonrot;
    private boolean isLunging;
    private boolean bHopWindow;
    private boolean perfectCounter;
    private int parryTicks;

    public MiscPlayerDataComponent(class_1657 player) {
        this.player = player;
    }

    public void tick() {
        this.tickSleep();
        this.tickSwordMechanics();
    }

    public void serverTick() {
        super.serverTick();
        double fortitude = this.player.method_26825(SpectrumEntityAttributes.MENTAL_PRESENCE);
        if (this.lastSyncedSleepPotency != fortitude) {
            this.lastSyncedSleepPotency = fortitude;
            SpectrumS2CPacketSender.sendMentalPresenceSync((class_3222)this.player, fortitude);
        }
    }

    private void tickDragonrotSwampEnvironment() {
        if (!this.player.method_6059(SpectrumStatusEffects.IMMUNITY) && this.player.method_37908().method_23753(this.player.method_24515()).method_40225(SpectrumBiomes.DRAGONROT_SWAMP)) {
            if (this.dragonrotTicks < 6000) {
                ++this.dragonrotTicks;
            }
            if (!(this.isBeingAfflictedByDragonrot || this.dragonrotTicks <= 20 || this.player.method_7325() || this.player.method_7337())) {
                this.isBeingAfflictedByDragonrot = true;
                this.player.method_7353((class_2561)class_2561.method_43471((String)"biome.spectrum.dragonrot_swamp.effect_start"), true);
            }
            if (this.dragonrotTicks >= 1200) {
                this.applyEnvironmentalLifeDrain(5);
                if (this.player.method_37908().method_8510() % 20L == 0L) {
                    this.player.method_5643(SpectrumDamageTypes.dragonrot(this.player.method_37908()), 1.0f);
                }
            } else if (this.dragonrotTicks >= 800) {
                this.applyEnvironmentalLifeDrain(3);
            } else if (this.dragonrotTicks >= 400) {
                this.applyEnvironmentalLifeDrain(1);
            } else if (this.dragonrotTicks >= 200) {
                this.applyEnvironmentalLifeDrain(0);
            }
        } else if (this.dragonrotTicks > 0) {
            this.dragonrotTicks = Math.max(0, this.dragonrotTicks - 3);
            if (this.isBeingAfflictedByDragonrot) {
                this.isBeingAfflictedByDragonrot = false;
                this.player.method_7353((class_2561)class_2561.method_43471((String)"biome.spectrum.dragonrot_swamp.effect_end"), true);
            }
        }
    }

    private boolean isInModifiedMotionState() {
        return this.player.method_24828() || this.player.method_5681() || this.player.method_6128() || this.player.method_31549().field_7479;
    }

    private void applyEnvironmentalLifeDrain(int amplifier) {
        if (this.player.field_6012 % 20 != 0 || this.player.method_6059(SpectrumStatusEffects.IMMUNITY) || this.player.method_7325() || this.player.method_7337()) {
            return;
        }
        class_1293 effect = this.player.method_6112(SpectrumStatusEffects.LIFE_DRAIN);
        if (effect == null) {
            this.player.method_6092(new class_1293(SpectrumStatusEffects.LIFE_DRAIN, 100, amplifier, true, false, true));
            this.dragonrotTicks = Math.max(240, this.dragonrotTicks / 2);
            return;
        }
        if (effect.method_5584() < 60) {
            ((StatusEffectInstanceAccessor)effect).setDuration(100);
            if (effect.method_5578() != amplifier) {
                ((StatusEffectInstanceAccessor)effect).setAmplifier(amplifier);
            }
            ((class_3218)this.player.method_37908()).method_14178().method_18751((class_1297)this.player, (class_2596)new class_2783(this.player.method_5628(), effect));
        }
    }

    public boolean tryIncrementDragonrotTicks(int ticks) {
        if (this.player.method_37908().method_23753(this.player.method_24515()).method_40225(SpectrumBiomes.DRAGONROT_SWAMP)) {
            this.dragonrotTicks = Math.min(12000, this.dragonrotTicks + ticks);
            return true;
        }
        return false;
    }

    public void initiateLungeState() {
        this.isLunging = true;
        this.bHopWindow = true;
    }

    public void endLunge() {
        this.isLunging = false;
        this.bHopWindow = false;
    }

    public boolean isLunging() {
        return this.isLunging;
    }

    public void setParryTicks(int ticks) {
        this.parryTicks = ticks;
    }

    public void markForPerfectCounter() {
        this.perfectCounter = true;
    }

    public boolean consumePerfectCounter() {
        if (this.perfectCounter) {
            this.perfectCounter = false;
            return true;
        }
        return false;
    }

    public boolean isParrying() {
        return this.parryTicks > 0;
    }

    private void tickSwordMechanics() {
        if (this.parryTicks > 1) {
            --this.parryTicks;
        } else if (this.parryTicks == 1) {
            this.parryTicks = 0;
            this.consumePerfectCounter();
        }
        if (!this.bHopWindow && this.isLunging) {
            if (this.isInModifiedMotionState()) {
                this.isLunging = false;
            } else {
                this.bHopWindow = true;
            }
        } else if (this.isLunging && this.isInModifiedMotionState()) {
            this.bHopWindow = false;
        }
    }

    public float getFrictionModifiers() {
        return this.isLunging ? 0.04f : 0.0f;
    }

    private void tickSleep() {
        if (this.ticksBeforeSleep > 0) {
            --this.ticksBeforeSleep;
            if (this.ticksBeforeSleep == 0) {
                this.player.method_18403(this.player.method_24515());
                ((PlayerEntityAccessor)this.player).setSleepTimer(0);
                class_1937 world = this.player.method_37908();
                if (!world.method_8608()) {
                    ((class_3218)world).method_8448();
                }
            }
        }
        if (this.sleepInvincibility > 0) {
            --this.sleepInvincibility;
        }
        if (this.ticksBeforeSleep != 0) {
            return;
        }
        if (this.sleepingWindow > 0) {
            --this.sleepingWindow;
            if (this.sleepingWindow == 0) {
                this.failSleep();
            }
        }
    }

    private void failSleep() {
        if (!this.player.method_37908().method_8608()) {
            this.player.method_18400();
            this.resetSleepingState(true);
        }
    }

    public boolean isSleeping() {
        return this.ticksBeforeSleep == 0 && this.sleepingWindow > 0;
    }

    public boolean shouldLieDown() {
        return this.ticksBeforeSleep > 0;
    }

    public void notifyHit() {
        if (this.sleepInvincibility <= 0) {
            this.resetSleepingState(true);
        }
    }

    public void resetSleepingState(boolean canApplyPenalties) {
        if (this.ticksBeforeSleep == -1) {
            return;
        }
        this.ticksBeforeSleep = -1;
        this.sleepingWindow = -1;
        this.sleepInvincibility = -1;
        if (canApplyPenalties) {
            this.sleepConsumable.ifPresent(p -> p.applyPenalties(this.player));
        }
        this.sleepConsumable = Optional.empty();
    }

    public void setSleepTimers(int wait, int window, int invulnTicks) {
        this.ticksBeforeSleep = wait;
        this.sleepingWindow = window;
        this.sleepInvincibility = invulnTicks;
    }

    public void setLastSleepItem(@NotNull SleepAlteringItem item) {
        this.sleepConsumable = Optional.of(item);
    }

    public void readFromNbt(class_2487 tag) {
        this.ticksBeforeSleep = tag.method_10550("ticksBeforeSleep");
        this.sleepingWindow = tag.method_10550("sleepingWindow");
        this.sleepInvincibility = tag.method_10550("sleepInvincibility");
        this.dragonrotTicks = tag.method_10550("dragonrotTicks");
        if (tag.method_10545("sleepConsumable")) {
            this.sleepConsumable = Optional.of((SleepAlteringItem)class_7923.field_41178.method_10223(class_2960.method_12829((String)tag.method_10558("sleepConsumable"))));
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("ticksBeforeSleep", this.ticksBeforeSleep);
        tag.method_10569("sleepingWindow", this.sleepingWindow);
        tag.method_10569("sleepInvincibility", this.sleepInvincibility);
        tag.method_10569("dragonrotTicks", this.dragonrotTicks);
        this.sleepConsumable.map(sleepPenalizingItem -> (class_1792)sleepPenalizingItem).map(class_1792::method_40131).flatMap(class_6880.class_6883::method_40230).map(class_5321::method_29177).ifPresent(id -> tag.method_10582("sleepConsumable", id.toString()));
    }

    public static MiscPlayerDataComponent get(@NotNull class_1657 player) {
        return (MiscPlayerDataComponent)MISC_PLAYER_DATA_COMPONENT.get((Object)player);
    }

    public void setLastSyncedSleepPotency(double lastSyncedSleepPotency) {
        this.lastSyncedSleepPotency = lastSyncedSleepPotency;
    }

    public double getLastSyncedSleepPotency() {
        return this.lastSyncedSleepPotency;
    }
}

