/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.recipes;

import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.spectrum.compat.emi.GatedSpectrumEmiRecipe;
import de.dafuqs.spectrum.compat.emi.SpectrumEmiRecipeCategories;
import de.dafuqs.spectrum.inventories.PedestalScreen;
import de.dafuqs.spectrum.recipe.pedestal.BuiltinGemstoneColor;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class PedestalCraftingEmiRecipeGated
extends GatedSpectrumEmiRecipe<PedestalRecipe> {
    public PedestalCraftingEmiRecipeGated(PedestalRecipe recipe) {
        super(SpectrumEmiRecipeCategories.PEDESTAL_CRAFTING, recipe, 124, 90);
        this.inputs = PedestalCraftingEmiRecipeGated.getIngredients(recipe);
    }

    @Override
    public boolean isUnlocked() {
        class_310 client = class_310.method_1551();
        return ((PedestalRecipe)this.recipe).getTier().hasUnlocked((class_1657)client.field_1724) && super.isUnlocked();
    }

    private static List<EmiIngredient> getIngredients(PedestalRecipe recipe) {
        int i;
        int powderSlotCount = recipe.getTier().getPowderSlotCount();
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int ingredientCount = ingredients.size();
        class_2371 list = class_2371.method_10213((int)(9 + powderSlotCount), (Object)EmiStack.EMPTY);
        for (i = 0; i < ingredientCount; ++i) {
            list.set(recipe.getGridSlotId(i), EmiIngredient.of(ingredients.get(i).getStacks().stream().map(EmiStack::of).toList()));
        }
        for (i = 0; i < powderSlotCount; ++i) {
            BuiltinGemstoneColor color = BuiltinGemstoneColor.values()[i];
            int powderAmount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (powderAmount <= 0) continue;
            list.set(9 + i, EmiStack.of((class_1935)color.getGemstonePowderItem(), (long)powderAmount));
        }
        return list;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        int powderSlotCount = ((PedestalRecipe)this.recipe).getTier().getPowderSlotCount();
        int gemstoneSlotStartX = 62 - powderSlotCount * 9;
        int gemstoneSlotTextureStartU = 88 - powderSlotCount * 9;
        class_2960 backgroundTexture = PedestalScreen.getBackgroundTextureForTier(((PedestalRecipe)this.recipe).getTier());
        widgets.addTexture(backgroundTexture, gemstoneSlotStartX, 59, 18 * powderSlotCount, 18, gemstoneSlotTextureStartU, 76);
        widgets.addTexture(backgroundTexture, 0, 0, 54, 54, 29, 18);
        widgets.addTexture(backgroundTexture, 90, 14, 26, 26, 122, 32);
        widgets.addTexture(backgroundTexture, 82, 38, 40, 16, 200, 0);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                widgets.addSlot((EmiIngredient)this.inputs.get(y * 3 + x), x * 18, y * 18).drawBack(false);
            }
        }
        for (int i = 0; i < powderSlotCount; ++i) {
            widgets.addSlot((EmiIngredient)this.inputs.get(9 + i), i * 18 + gemstoneSlotStartX, 59).drawBack(false);
        }
        if (((PedestalRecipe)this.recipe).isShapeless()) {
            widgets.addTexture(EmiTexture.SHAPELESS, 94, 0);
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 90, 14).large(true).drawBack(false).recipeContext((EmiRecipe)this);
        widgets.addFillingArrow(60, 18, ((PedestalRecipe)this.recipe).getCraftingTime() * 50);
        widgets.addText(PedestalCraftingEmiRecipeGated.getCraftingTimeText(((PedestalRecipe)this.recipe).getCraftingTime(), ((PedestalRecipe)this.recipe).getExperience()), this.width / 2, 80, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

