/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6025;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightShardBaseEntity
extends class_1676 {
    public static final Predicate<class_1309> EVERYTHING_TARGET = livingEntity -> {
        class_1657 player;
        return !(livingEntity instanceof class_1657) || !(player = (class_1657)livingEntity).method_7337();
    };
    public static final Predicate<class_1309> MONSTER_TARGET = livingEntity -> livingEntity instanceof class_1569;
    public static final class_6017 DEFAULT_COUNT_PROVIDER = class_6019.method_35017((int)7, (int)13);
    private static final class_2940<Integer> MAX_AGE = class_2945.method_12791(LightShardBaseEntity.class, (class_2941)class_2943.field_13327);
    public static final int DECELERATION_PHASE_LENGTH = 25;
    public static final float DEFAULT_ACCELERATION = 0.03f;
    protected float scaleOffset;
    protected float damage;
    protected float detectionRange;
    protected Optional<UUID> target = Optional.empty();
    protected Optional<class_1309> targetEntity = Optional.empty();
    protected class_243 initialVelocity = class_243.field_1353;
    protected Predicate<class_1309> targetPredicate;

    public LightShardBaseEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
        this.scaleOffset = world.field_9229.method_43057() + 0.15f;
    }

    public LightShardBaseEntity(class_1299<? extends class_1676> entityType, class_1937 world, class_1309 owner, float detectionRange, float damage, float lifeSpanTicks) {
        super(entityType, world);
        this.method_7432((class_1297)owner);
        this.detectionRange = detectionRange;
        this.damage = damage;
        this.setMaxAge((int)(lifeSpanTicks + class_3532.method_32855((class_5819)world.method_8409(), (float)10.0f, (float)7.0f)));
    }

    protected void method_5693() {
        this.field_6011.method_12784(MAX_AGE, (Object)20);
    }

    public int getMaxAge() {
        return (Integer)this.field_6011.method_12789(MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.field_6011.method_12778(MAX_AGE, (Object)maxAge);
    }

    public void method_5773() {
        super.method_5773();
        ++this.field_6012;
        if (this.method_37908().method_8608() && this.field_6012 > 24 && this.method_18798().method_1033() > 0.075 && (this.method_18798().method_1033() > 0.2 || this.method_37908().method_8510() % 2L == 0L)) {
            this.method_37908().method_8466((class_2394)SpectrumParticleTypes.LIGHT_TRAIL, true, this.field_6014, this.field_6036, this.field_5969, 0.0, 0.0, 0.0);
        }
        if (this.field_6012 > this.getMaxAge()) {
            this.method_5783(SpectrumSoundEvents.SOFT_HUM, this.field_5974.method_43057() + 0.25f, 1.0f + this.field_5974.method_43057());
            this.method_5650(class_1297.class_5529.field_26999);
        }
        class_243 velocity = this.method_18798();
        this.method_30634(this.method_23317() + velocity.method_10216(), this.method_23318() + velocity.method_10214(), this.method_23321() + velocity.method_10215());
        if (this.field_6012 < 25) {
            double deceleration = Math.max((double)((float)this.field_6012 / 25.0f), 0.5);
            this.method_18800(class_3532.method_16436((double)deceleration, (double)this.initialVelocity.field_1352, (double)0.0), class_3532.method_16436((double)deceleration, (double)this.initialVelocity.field_1351, (double)0.0), class_3532.method_16436((double)deceleration, (double)this.initialVelocity.field_1350, (double)0.0));
            this.field_6007 = true;
            this.method_5785();
            return;
        }
        class_239 hitResult = class_1675.method_49997((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        this.method_7488(hitResult);
        if (this.targetEntity.isEmpty() || !this.isValidTarget(this.targetEntity.get())) {
            class_1937 world = this.method_37908();
            if (world.field_9236) {
                return;
            }
            if ((double)this.field_5974.method_43057() > 0.25) {
                return;
            }
            this.findSuitableTargets((class_3218)this.method_37908());
        }
        if (this.targetEntity.isPresent() && this.isValidTarget(this.targetEntity.get())) {
            class_1309 entity = this.targetEntity.get();
            class_243 transformVector = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0).method_1020(this.method_19538()).method_1029();
            class_243 accelerationVector = transformVector.method_1021((double)0.03f);
            this.method_5762(accelerationVector.field_1352, accelerationVector.field_1351, accelerationVector.field_1350);
        }
    }

    protected void setTargetPredicate(@NotNull Predicate<class_1309> targetPredicate) {
        this.targetPredicate = targetPredicate;
    }

    protected void findSuitableTargets(class_3218 serverWorld) {
        List potentialTargets = serverWorld.method_8390(class_1309.class, class_238.method_30048((class_243)this.method_19538(), (double)this.detectionRange, (double)this.detectionRange, (double)this.detectionRange), this.targetPredicate);
        Collections.shuffle(potentialTargets);
        for (class_1309 potentialTarget : potentialTargets) {
            if (!this.canSee((class_1297)potentialTarget) || !this.isValidTarget(potentialTarget)) continue;
            this.setTarget(potentialTarget);
            return;
        }
    }

    public boolean canSee(class_1297 entity) {
        if (entity.method_37908() != this.method_37908()) {
            return false;
        }
        if (entity.method_19538().method_1022(this.method_19538()) > 128.0) {
            return false;
        }
        return this.method_37908().method_17742(new class_3959(this.method_19538(), entity.method_19538(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    protected boolean isValidTarget(class_1309 entity) {
        class_1309 livingEntity;
        class_6025 pet;
        class_1309 petOwner;
        class_1297 owner = this.method_24921();
        if (entity == owner) {
            return false;
        }
        if (owner != null && entity.method_5722(owner)) {
            return false;
        }
        if (!this.targetPredicate.test(entity)) {
            return false;
        }
        if (entity instanceof class_6025 && (petOwner = (pet = (class_6025)entity).method_35057()) instanceof class_1309 && this.targetPredicate.test(livingEntity = petOwner)) {
            return false;
        }
        return !entity.method_31481() && entity.method_5805() && !entity.method_5767() && !entity.method_5655();
    }

    protected void setInitialVelocity(class_243 vector) {
        this.initialVelocity = vector;
        this.method_18799(vector);
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (!this.method_37908().method_8608()) {
            class_1297 hitEntity = entityHitResult.method_17782();
            if (!(hitEntity instanceof class_1309)) {
                return;
            }
            class_1309 livingEntity = (class_1309)hitEntity;
            if (!this.isValidTarget(livingEntity)) {
                return;
            }
            this.onHitEntity(livingEntity);
        }
        this.method_5650(class_1297.class_5529.field_26999);
        super.method_7454(entityHitResult);
    }

    protected void onHitEntity(class_1309 attacked) {
        class_1309 owner;
        class_1297 class_12972;
        float finalDamage = this.damage * (this.field_5974.method_43057() + 0.5f) * (1.0f - this.getVanishingProgress(this.field_6012));
        attacked.method_5643(SpectrumDamageTypes.irradiance(this.method_37908(), (class_12972 = this.method_24921()) instanceof class_1309 ? (owner = (class_1309)class_12972) : null), finalDamage);
        attacked.method_5783(SpectrumSoundEvents.SOFT_HUM, 1.334f, 0.9f + this.field_5974.method_43057());
        attacked.method_5783(SpectrumSoundEvents.CRYSTAL_STRIKE, this.field_5974.method_43057() * 0.4f + 0.2f, 0.8f + this.field_5974.method_43057());
    }

    public void method_36209() {
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        int bound = this.field_5974.method_43048(11);
        if (reason.method_31486()) {
            for (int i = 0; i < bound + 5; ++i) {
                if ((double)this.field_5974.method_43057() < 0.665) {
                    this.method_37908().method_17452((class_2394)SpectrumParticleTypes.WHITE_SPARKLE_RISING, true, this.method_23317(), this.method_23318(), this.method_23321(), (double)(this.field_5974.method_43057() * 0.25f - 0.125f), (double)(this.field_5974.method_43057() * 0.25f - 0.125f), (double)(this.field_5974.method_43057() * 0.25f - 0.125f));
                    continue;
                }
                this.method_37908().method_17452((class_2394)SpectrumParticleTypes.SHOOTING_STAR, true, this.method_23317(), this.method_23318(), this.method_23321(), (double)(this.field_5974.method_43057() * 0.5f - 0.25f), (double)(this.field_5974.method_43057() * 0.5f - 0.25f), (double)(this.field_5974.method_43057() * 0.5f - 0.25f));
            }
        }
    }

    public static void summonBarrageInternal(class_1937 world, @Nullable class_1309 user, Supplier<LightShardBaseEntity> supplier, @Nullable class_1309 target, Predicate<class_1309> targetPredicate, class_243 pos, class_6017 count) {
        class_5819 random = world.method_8409();
        int projectiles = count.method_35008(random);
        world.method_8396(null, class_2338.method_49638((class_2374)pos), SpectrumSoundEvents.GLASS_SHIMMER, class_3419.field_15256, 1.0f, 0.9f + random.method_43057() * 0.5f);
        for (int i = 0; i < projectiles; ++i) {
            LightShardBaseEntity shard = supplier.get();
            shard.method_33574(pos);
            double velocityY = 0.0;
            if (user != null && user.method_24828()) {
                velocityY = (double)random.method_43057() * 0.75;
                shard.setInitialVelocity(new class_243((double)(random.method_43057() * 2.0f - 1.0f), velocityY, (double)(random.method_43057() * 2.0f - 1.0f)).method_1019(user.method_18798()));
            } else {
                velocityY = (double)random.method_43057() - 0.5;
                shard.setInitialVelocity(new class_243((double)(random.method_43057() * 2.0f - 1.0f), velocityY, (double)(random.method_43057() * 2.0f - 1.0f)));
            }
            if (target != null) {
                shard.setTarget(target);
            }
            shard.setTargetPredicate(targetPredicate);
            world.method_8649((class_1297)shard);
            for (int j = 0; j < 3; ++j) {
                world.method_8406((class_2394)SpectrumParticleTypes.SHOOTING_STAR, pos.field_1352, pos.field_1351, pos.field_1350, (double)(random.method_43057() * 0.8f - 0.4f), velocityY * 2.0, (double)(random.method_43057() * 0.8f - 0.4f));
            }
        }
    }

    public float getScaleOffset() {
        return this.scaleOffset;
    }

    public float getVanishingProgress(int age) {
        return 1.0f - (float)Math.min(this.getMaxAge() - age, this.getVanishingLength()) / (float)this.getVanishingLength();
    }

    public int getVanishingLength() {
        return Math.round((float)this.getMaxAge() / 4.0f);
    }

    public void setTarget(@NotNull class_1309 target) {
        this.target = Optional.ofNullable(target.method_5667());
        this.targetEntity = Optional.of(target);
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.target.ifPresent(uuid -> nbt.method_25927("target", uuid));
        nbt.method_10549("initX", this.initialVelocity.field_1352);
        nbt.method_10549("initY", this.initialVelocity.field_1351);
        nbt.method_10549("initZ", this.initialVelocity.field_1350);
        nbt.method_10548("damage", this.damage);
        nbt.method_10548("scale", this.scaleOffset);
        nbt.method_10569("maxAge", this.getMaxAge());
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("target")) {
            this.target = Optional.ofNullable(nbt.method_25926("target"));
        }
        this.initialVelocity = new class_243(nbt.method_10574("initX"), nbt.method_10574("initY"), nbt.method_10574("initZ"));
        this.damage = nbt.method_10583("damage");
        this.scaleOffset = nbt.method_10583("scale");
        this.setMaxAge(nbt.method_10550("maxAge"));
    }

    public abstract class_2960 getTexture();
}

