/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.render;

import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.PhantomFrameEntity;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_915;
import net.minecraft.class_918;

public class PhantomFrameEntityRenderer<T extends class_1533>
extends class_915<PhantomFrameEntity> {
    public static final class_1091 NORMAL_FRAME_MODEL_IDENTIFIER = class_1091.method_45910((String)"item_frame", (String)"map=false");
    public static final class_1091 MAP_FRAME_MODEL_IDENTIFIER = class_1091.method_45910((String)"item_frame", (String)"map=true");
    public static final class_1091 GLOW_FRAME_MODEL_IDENTIFIER = class_1091.method_45910((String)"glow_item_frame", (String)"map=false");
    public static final class_1091 MAP_GLOW_FRAME_MODEL_IDENTIFIER = class_1091.method_45910((String)"glow_item_frame", (String)"map=true");
    private final class_310 client = class_310.method_1551();
    private final class_918 itemRenderer;

    public PhantomFrameEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.itemRenderer = context.method_32168();
    }

    protected int getBlockLight(PhantomFrameEntity itemFrameEntity, class_2338 blockPos) {
        return itemFrameEntity.method_5864() == SpectrumEntityTypes.GLOW_PHANTOM_FRAME ? Math.max(5, super.method_33435((class_1533)itemFrameEntity, blockPos)) : super.method_33435((class_1533)itemFrameEntity, blockPos);
    }

    public void render(PhantomFrameEntity entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        if (this.hasLabel(entity)) {
            this.method_23175(entity, entity.method_5476(), matrixStack, vertexConsumerProvider, light);
        }
        matrixStack.method_22903();
        class_2350 direction = entity.method_5735();
        class_243 vec3d = this.method_23174(entity, g);
        matrixStack.method_22904(-vec3d.method_10216(), -vec3d.method_10214(), -vec3d.method_10215());
        double d = 0.46875;
        matrixStack.method_22904((double)direction.method_10148() * d, (double)direction.method_10164() * d, (double)direction.method_10165() * d);
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_36455()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        boolean isInvisible = entity.method_5767();
        class_1799 itemStack = entity.method_6940();
        if (!isInvisible) {
            class_776 blockRenderManager = this.client.method_1541();
            class_1092 bakedModelManager = blockRenderManager.method_3351().method_3333();
            class_1091 modelIdentifier = this.getModelId(entity, itemStack);
            matrixStack.method_22903();
            matrixStack.method_22904(-0.5, -0.5, -0.5);
            blockRenderManager.method_3350().method_3367(matrixStack.method_23760(), vertexConsumerProvider.getBuffer(class_4722.method_24073()), null, bakedModelManager.method_4742(modelIdentifier), 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
            matrixStack.method_22909();
        }
        if (!itemStack.method_7960()) {
            boolean isRenderingMap = itemStack.method_31574(class_1802.field_8204);
            if (isInvisible) {
                matrixStack.method_22904(0.0, 0.0, 0.5);
            } else {
                matrixStack.method_22904(0.0, 0.0, 0.4375);
            }
            int renderLight = entity.shouldRenderAtMaxLight() ? 0xF000F0 : light;
            int bakedModelManager = isRenderingMap ? entity.method_6934() % 4 * 2 : entity.method_6934();
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)bakedModelManager * 360.0f / 8.0f));
            if (isRenderingMap) {
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                float scale = 0.0078125f;
                matrixStack.method_22905(scale, scale, scale);
                matrixStack.method_22904(-64.0, -64.0, 0.0);
                Integer mapId = class_1806.method_8003((class_1799)itemStack);
                class_22 mapState = class_1806.method_7997((Integer)mapId, (class_1937)entity.method_37908());
                matrixStack.method_22904(0.0, 0.0, -1.0);
                if (mapState != null) {
                    this.client.field_1773.method_3194().method_1773(matrixStack, vertexConsumerProvider, mapId.intValue(), mapState, true, renderLight);
                }
            } else {
                float scale = 0.75f;
                matrixStack.method_22905(scale, scale, scale);
                this.itemRenderer.method_23178(itemStack, class_811.field_4319, renderLight, class_4608.field_21444, matrixStack, vertexConsumerProvider, entity.method_37908(), entity.method_5628());
            }
        }
        matrixStack.method_22909();
    }

    protected boolean hasLabel(PhantomFrameEntity itemFrameEntity) {
        if (class_310.method_1498() && !itemFrameEntity.method_6940().method_7960() && itemFrameEntity.method_6940().method_7938() && this.field_4676.field_4678 == itemFrameEntity) {
            double d = this.field_4676.method_23168((class_1297)itemFrameEntity);
            float f = itemFrameEntity.method_21751() ? 32.0f : 64.0f;
            return d < (double)(f * f);
        }
        return false;
    }

    private class_1091 getModelId(PhantomFrameEntity entity, class_1799 stack) {
        boolean bl;
        boolean bl2 = bl = entity.method_5864() == SpectrumEntityTypes.GLOW_PHANTOM_FRAME;
        if (stack.method_31574(class_1802.field_8204)) {
            return bl ? MAP_GLOW_FRAME_MODEL_IDENTIFIER : MAP_FRAME_MODEL_IDENTIFIER;
        }
        return bl ? GLOW_FRAME_MODEL_IDENTIFIER : NORMAL_FRAME_MODEL_IDENTIFIER;
    }
}

