/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items;

import com.mojang.datafixers.util.Pair;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.items.food.DrinkItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import org.jetbrains.annotations.Nullable;

public class ConcealingOilsItem
extends DrinkItem
implements InkPoweredPotionFillable {
    public static final String OIL_EFFECT_ID = "ConcealedOilEffect";
    public static final String POISONER_KEY = "Poisoner";
    public static final int POISONED_COLOUR = 4002085;

    public ConcealingOilsItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (!InkPoweredPotionFillable.getEffects(stack).isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.concealing_oils.tooltip").method_27694(s -> s.method_27706(class_124.field_1080).method_10978(Boolean.valueOf(true))));
        }
        this.appendPotionFillableTooltip(stack, tooltip, class_2561.method_43471((String)"item.spectrum.concealing_oils.when_poisoned"), true);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 appliedStack = slot.method_7677();
        if (!appliedStack.method_19267()) {
            return false;
        }
        if (!this.isFull(stack)) {
            return false;
        }
        if (this.tryApplyOil(stack, appliedStack, player)) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_5783(class_3417.field_14826, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean tryApplyOil(class_1799 oil, class_1799 food, class_1657 user) {
        if (food.method_7909() instanceof DrinkItem || food.method_7985() && food.method_7969().method_10545(OIL_EFFECT_ID)) {
            return false;
        }
        InkPoweredStatusEffectInstance effect = InkPoweredPotionFillable.getEffects(oil).get(0);
        if (!InkPowered.tryDrainEnergy(user, effect.getInkCost().getColor(), effect.getInkCost().getCost())) {
            return false;
        }
        if (food.method_7909().method_19264().method_19235().stream().map(Pair::getFirst).map(class_1293::method_5579).anyMatch(e -> e.equals(effect.getStatusEffectInstance().method_5579()))) {
            return false;
        }
        class_1293 instance = effect.getStatusEffectInstance();
        if (instance == null) {
            return true;
        }
        class_2487 compound = new class_2487();
        compound.method_25927(POISONER_KEY, user.method_5667());
        instance.method_5582(compound);
        food.method_7948().method_10566(OIL_EFFECT_ID, (class_2520)compound);
        return true;
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 3;
    }
}

