/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import de.dafuqs.spectrum.registries.SpectrumStructureTags;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureCompassItem
extends class_1759 {
    protected final class_6862<class_3195> locatedStructures;

    public StructureCompassItem(class_1792.class_1793 settings, class_6862<class_3195> locatedStructures) {
        super(settings);
        this.locatedStructures = locatedStructures;
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && world.method_8510() % 200L == 0L) {
            this.locateStructure(stack, world, entity);
        }
    }

    protected void locateStructure(@NotNull class_1799 stack, @NotNull class_1937 world, class_1297 entity) {
        Pair<class_2338, class_6880<class_3195>> foundStructure = this.locateStructure((class_3218)world, entity.method_24515());
        if (foundStructure != null) {
            this.saveStructurePos(stack, (class_5321<class_1937>)world.method_27983(), (class_2338)foundStructure.getFirst());
        } else {
            this.removeStructurePos(stack);
        }
    }

    @Nullable
    public Pair<class_2338, class_6880<class_3195>> locateStructure(@NotNull class_3218 world, @NotNull class_2338 pos) {
        Optional<class_6885.class_6888<class_3195>> registryEntryList = SpectrumStructureTags.entriesOf((class_1937)world, this.locatedStructures);
        if (registryEntryList.isPresent()) {
            return world.method_14178().method_12129().method_12103(world, (class_6885)registryEntryList.get(), pos, 100, false);
        }
        return null;
    }

    public static boolean hasStructure(@NotNull class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null && nbtCompound.method_10545("StructureDimension") && nbtCompound.method_10545("StructurePos");
    }

    @Nullable
    public static class_4208 getStructurePos(class_1799 stack) {
        Optional optional;
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return null;
        }
        boolean bl = nbt.method_10545("StructurePos");
        boolean bl2 = nbt.method_10545("StructureDimension");
        if (bl && bl2 && (optional = class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("StructureDimension")).result()).isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)nbt.method_10562("StructurePos"));
            return class_4208.method_19443((class_5321)((class_5321)optional.get()), (class_2338)blockPos);
        }
        return null;
    }

    protected void saveStructurePos(class_1799 stack, @NotNull class_5321<class_1937> worldKey, @NotNull class_2338 pos) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10566("StructurePos", (class_2520)class_2512.method_10692((class_2338)pos));
        nbt.method_10582("StructureDimension", worldKey.method_29177().toString());
    }

    protected void removeStructurePos(@NotNull class_1799 stack) {
        stack.method_7983("StructurePos");
        stack.method_7983("StructureDimension");
    }
}

