/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.items.tools.MalachiteBidentItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class FractalBidentItem
extends MalachiteBidentItem
implements SlotBackgroundEffectProvider,
InkPowered {
    public static final InkCost MIRROR_IMAGE_COST = new InkCost(InkColors.WHITE, 25L);

    public FractalBidentItem(class_1792.class_1793 settings, double attackSpeed, double damage, float armorPierce, float protPierce) {
        super(settings, attackSpeed, damage, armorPierce, protPierce);
    }

    @Override
    public boolean isThrownAsMirrorImage(class_1799 stack, class_3218 world, class_1657 player) {
        return !this.isDisabled(stack) && InkPowered.tryDrainEnergy(player, MIRROR_IMAGE_COST);
    }

    @Override
    public float getThrowSpeed(class_1799 stack) {
        return this.isDisabled(stack) ? super.getThrowSpeed(stack) : 5.0f;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(MIRROR_IMAGE_COST.getColor());
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.fractal_glass_crest_bident.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.fractal_glass_crest_bident.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.fractal_glass_crest_bident.tooltip3").method_27692(class_124.field_1080));
        this.addInkPoweredTooltip(tooltip);
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return super.acceptsEnchantment(enchantment) || enchantment == class_1893.field_9131 || enchantment == class_1893.field_9103;
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        boolean usable = InkPowered.hasAvailableInk(player, MIRROR_IMAGE_COST);
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public float getProtReduction(class_1309 target, class_1799 stack) {
        return 0.25f;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return -8377404;
    }
}

