/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParryingSwordItem
extends class_1829
implements ExtendedItemBarProvider {
    protected static final UUID REACH_MODIFIER_ID = UUID.fromString("b011e7af-6117-4aef-b4e9-a613f4fb0a2a");
    protected static final UUID CRIT_MODIFIER_ID = UUID.fromString("50cfc2f8-42fb-4bf5-b21c-c0ff4ee952bf");
    public static final int DEFAULT_MAX_BLOCK_TIME = 40;
    public static final int DEFAULT_PERFECT_PARRY_WINDOW = 5;
    private final float attackDamage;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public ParryingSwordItem(class_1832 material, int attackDamage, float attackSpeed, float crit, float reach, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
        this.attackDamage = (float)attackDamage + material.method_8028();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)attackSpeed, class_1322.class_1323.field_6328));
        builder.put((Object)AdditionalEntityAttributes.CRITICAL_BONUS_DAMAGE, (Object)new class_1322(CRIT_MODIFIER_ID, "Weapon modifier", (double)crit, class_1322.class_1323.field_6328));
        builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322(REACH_MODIFIER_ID, "Weapon modifier", (double)reach, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public float method_8020() {
        return this.attackDamage;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        super.method_7840(stack, world, user, remainingUseTicks);
        int usedTime = this.getMaxShieldingTime(user, stack) - remainingUseTicks;
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        this.cooldownAndDamage(stack, player, usedTime);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        this.method_7840(stack, world, user, 0);
        return stack;
    }

    private void cooldownAndDamage(class_1799 stack, class_1657 player, int usedTime) {
        if (usedTime > 1) {
            player.method_7357().method_7906((class_1792)this, Math.max(usedTime, 10));
        }
        stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public abstract float getBlockingMultiplier(class_1282 var1, class_1799 var2, class_1309 var3, int var4);

    public boolean canPerfectParry(class_1799 stack, class_1309 entity, int usedTime) {
        return usedTime <= this.getPerfectParryWindow(entity, stack);
    }

    public boolean canBluffParry(class_1799 stack, class_1309 entity, int usedTime) {
        return usedTime <= this.getPerfectParryWindow(entity, stack) * 2;
    }

    public boolean canDeflect(class_1282 source, boolean perfect) {
        if (source.method_48789(class_8103.field_42255) || source.method_48789(class_8103.field_42241)) {
            return false;
        }
        if (source.method_48789(class_8103.field_43116)) {
            return perfect;
        }
        return true;
    }

    public int method_7881(class_1799 stack) {
        return 40;
    }

    public int getMaxShieldingTime(class_1309 user, class_1799 stack) {
        return this.method_7881(stack);
    }

    public int getPerfectParryWindow(class_1309 user, class_1799 stack) {
        return 5;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    protected abstract int getBarColor();

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        if (player == null || !player.method_6115()) {
            return ExtendedItemBarProvider.PASS;
        }
        class_1799 activeStack = player.method_5998(player.method_6058());
        if (activeStack != stack) {
            return ExtendedItemBarProvider.PASS;
        }
        int progress = Math.round(class_3532.method_37166((float)13.0f, (float)0.0f, (float)((float)player.method_6048() / (float)this.getMaxShieldingTime((class_1309)player, stack))));
        return new ExtendedItemBarProvider.BarSignature(2, 13, 13, progress, 1, this.getBarColor(), 2, -16777216);
    }
}

