/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.item.ExpandedStatTooltip;
import de.dafuqs.spectrum.api.item.Stampable;
import de.dafuqs.spectrum.helpers.BlockReference;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class TuningStampItem
extends class_1792
implements ExpandedStatTooltip {
    public static final String DATA = "spectrum:stamping_data";

    public TuningStampItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        Optional<class_1657> player = Optional.ofNullable(context.method_8036());
        BlockReference reference = BlockReference.of((class_1936)world, pos);
        Optional<Object> potentialData = Optional.empty();
        if (stack.method_7948().method_10545(DATA)) {
            potentialData = Stampable.loadStampingData(world, stack.method_7941(DATA));
        }
        if (potentialData.isPresent()) {
            if (!world.field_9236) {
                Stampable.StampData target;
                Optional<Stampable.StampData> potentialTarget = this.getData(player, reference, world);
                if (potentialTarget.isEmpty()) {
                    return class_1269.field_5811;
                }
                Stampable.StampData source = (Stampable.StampData)potentialData.get();
                if (!source.verifyStampData(target = potentialTarget.get()) || !target.canUserStamp(player)) {
                    this.tryPlaySound(player, SpectrumSoundEvents.SHATTER_LIGHT, 0.75f);
                    return class_1269.field_5814;
                }
                Stampable interactable = target.source();
                boolean targetChanged = interactable.handleImpression(source.stamper(), player, source.reference(), world);
                source.notifySourceOfChange(target, targetChanged);
                if (!targetChanged) {
                    this.tryPlaySound(player, SpectrumSoundEvents.SHATTER_HEAVY, 0.45f);
                    return class_1269.field_5814;
                }
                player.ifPresent(user -> {
                    if (!user.method_5715()) {
                        Stampable.StampData newSource = target.source().recordStampData(player, reference, world);
                        this.saveToNbt(stack, newSource);
                        this.tryPlaySound(player, class_3417.field_26980, 0.825f);
                    } else {
                        this.tryPlaySound(player, SpectrumSoundEvents.BLOCK_ONYX_BLOCK_CHIME, 0.825f);
                    }
                });
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        Optional<Stampable.StampData> candidate = this.getData(player, reference, world);
        if (player.map(class_1297::method_5715).orElse(false).booleanValue()) {
            if (candidate.map(d -> d.canUserStamp(player)).orElse(false).booleanValue()) {
                if (!world.field_9236) {
                    candidate.get().source().clearImpression();
                }
                this.tryPlaySound(player, class_3417.field_26979, 0.825f);
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (candidate.isPresent() && candidate.get().canUserStamp(player)) {
            this.saveToNbt(stack, candidate.get());
            this.tryPlaySound(player, SpectrumSoundEvents.CRYSTAL_STRIKE, 0.75f);
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return super.method_7884(context);
    }

    public void clearData(Optional<class_1657> player, class_1799 stack) {
        stack.method_7948().method_10551(DATA);
        this.tryPlaySound(player, class_3417.field_43155, 1.0f);
    }

    private void tryPlaySound(Optional<class_1657> player, class_3414 sound, float volume) {
        player.ifPresent(p -> p.method_37908().method_43129(null, (class_1297)p, sound, class_3419.field_15248, volume, 0.9f + p.method_6051().method_43057() / 5.0f));
    }

    private void saveToNbt(class_1799 stack, Stampable.StampData data) {
        class_2487 stackNbt = stack.method_7948();
        stackNbt.method_10566(DATA, (class_2520)Stampable.saveStampingData(data));
    }

    private Optional<Stampable.StampData> getData(Optional<class_1657> player, BlockReference reference, class_1937 world) {
        Optional<Stampable.StampData> data = Optional.empty();
        class_2248 class_22482 = reference.getState().method_26204();
        if (class_22482 instanceof Stampable) {
            Stampable interactable = (Stampable)class_22482;
            data = Optional.ofNullable(interactable.recordStampData(player, reference, world));
        }
        if (!data.isPresent()) {
            data = reference.tryGetBlockEntity().map(be -> {
                if (be instanceof Stampable) {
                    Stampable interactable = (Stampable)be;
                    return interactable.recordStampData(player, reference, world);
                }
                return null;
            });
        }
        return data;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_7948().method_10545(DATA)) {
            Optional<Stampable.StampData> data = Stampable.loadStampingData(world, stack.method_7941(DATA));
            if (data.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tuning_stamp.tooltip.missing").method_27694(style -> style.method_36139(16741754)));
                return;
            }
            Stampable.StampData stampData = data.get();
            class_2338 pos = stampData.reference().pos;
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.tuning_stamp.tooltip.linked", (Object[])new Object[]{stampData.reference().getState().method_26204().method_9518()}).method_27694(style -> style.method_36139(16763276)));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.tuning_stamp.tooltip2", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27694(style -> style.method_36139(16358281).method_10978(Boolean.valueOf(true))));
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tuning_stamp.tooltip").method_27692(class_124.field_1080));
    }

    @Override
    public void expandTooltip(class_1799 stack, @Nullable class_1657 player, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tuning_stamp.controls").method_27694(style -> style.method_36139(0x66FF99)));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tuning_stamp.controls2").method_27694(style -> style.method_36139(0x66FF99)));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tuning_stamp.controls3").method_27694(style -> style.method_36139(0x66FF99)));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.press_shift_for_controls").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
        }
    }
}

