/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;

public class DyeRandomlyLootFunction
extends class_120 {
    final List<Integer> colors;

    DyeRandomlyLootFunction(class_5341[] conditions, Collection<Integer> colors) {
        super(conditions);
        this.colors = ImmutableList.copyOf(colors);
    }

    public class_5339 method_29321() {
        return SpectrumLootFunctionTypes.DYE_RANDOMLY;
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1768) {
            class_1768 dyeableItem = (class_1768)class_17922;
            class_5819 random = context.method_294();
            int color = this.colors.isEmpty() ? ColorHelper.getRandomColor(random.method_43054()) : this.colors.get(random.method_43048(this.colors.size()));
            dyeableItem.method_7799(stack, color);
        }
        return stack;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class_120.class_121<?> builder() {
        return DyeRandomlyLootFunction.method_520(conditions -> new DyeRandomlyLootFunction((class_5341[])conditions, (Collection<Integer>)ImmutableList.of()));
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final Set<Integer> colors = Sets.newHashSet();

        protected Builder getThisBuilder() {
            return this;
        }

        public Builder add(Integer color) {
            this.colors.add(color);
            return this;
        }

        public class_117 method_515() {
            return new DyeRandomlyLootFunction(this.method_526(), this.colors);
        }
    }

    public static class Serializer
    extends class_120.class_123<DyeRandomlyLootFunction> {
        public void toJson(JsonObject jsonObject, DyeRandomlyLootFunction lootFunction, JsonSerializationContext jsonSerializationContext) {
            super.method_529(jsonObject, (class_120)lootFunction, jsonSerializationContext);
            if (!lootFunction.colors.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (Integer color : lootFunction.colors) {
                    jsonArray.add((JsonElement)new JsonPrimitive((Number)color));
                }
                jsonObject.add("colors", (JsonElement)jsonArray);
            }
        }

        public DyeRandomlyLootFunction fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, class_5341[] lootConditions) {
            ArrayList colors = Lists.newArrayList();
            if (jsonObject.has("colors")) {
                JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)"colors");
                for (JsonElement jsonElement : jsonArray) {
                    String hex;
                    if (!(jsonElement instanceof JsonPrimitive)) continue;
                    JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                    if (jsonPrimitive.isNumber()) {
                        colors.add(jsonElement.getAsInt());
                        continue;
                    }
                    if (!jsonPrimitive.isString() || !(hex = jsonPrimitive.getAsString()).startsWith("#")) continue;
                    colors.add(Integer.parseInt(hex.substring(1), 16));
                }
            }
            return new DyeRandomlyLootFunction(lootConditions, colors);
        }
    }
}

