/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.matchbooks.recipe.RecipeParser;
import de.dafuqs.spectrum.helpers.NbtHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2259;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class RecipeUtils {
    public static class_1799 itemStackWithNbtFromJson(JsonObject json) {
        class_1792 item = class_1869.method_8155((JsonObject)json);
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        if (count < 1) {
            throw new JsonSyntaxException("Invalid output count: " + count);
        }
        class_1799 stack = new class_1799((class_1935)item, count);
        Optional<class_2487> nbt = NbtHelper.getNbtCompound(json.get("nbt"));
        nbt.ifPresent(arg_0 -> ((class_1799)stack).method_7980(arg_0));
        return stack;
    }

    public static class_2680 blockStateFromString(String string) throws CommandSyntaxException {
        return class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(string), (boolean)true).comp_622();
    }

    public static String blockStateToString(class_2680 state) {
        return class_2259.method_9685((class_2680)state);
    }

    public static List<IngredientStack> createIngredientStackPatternMatrix(String[] pattern, Map<String, IngredientStack> symbols, int width, int height) {
        class_2371 list = class_2371.method_10213((int)(width * height), (Object)IngredientStack.EMPTY);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                IngredientStack ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                list.set(j + width * i, ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return list;
    }

    public static Map<String, IngredientStack> readIngredientStackSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry stringJsonElementEntry : json.entrySet()) {
            if (((String)stringJsonElementEntry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)stringJsonElementEntry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(stringJsonElementEntry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)stringJsonElementEntry.getKey(), RecipeParser.ingredientStackFromJson((JsonObject)((JsonObject)stringJsonElementEntry.getValue())));
        }
        map.put(" ", IngredientStack.EMPTY);
        return map;
    }
}

