/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.matchbooks.recipe.RecipeParser;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.predicate.world.WorldConditionPredicate;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.api.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class FusionShrineRecipeSerializer
implements GatedRecipeSerializer<FusionShrineRecipe> {
    public final RecipeFactory recipeFactory;

    public FusionShrineRecipeSerializer(RecipeFactory recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public FusionShrineRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        List craftingInputs = RecipeParser.ingredientStacksFromJson((JsonArray)ingredientArray, (int)ingredientArray.size());
        if (craftingInputs.size() > 7) {
            throw new JsonParseException("Recipe cannot have more than 7 ingredients. Has " + craftingInputs.size());
        }
        FluidIngredient fluid = FluidIngredient.EMPTY;
        if (class_3518.method_34923((JsonObject)jsonObject, (String)"fluid")) {
            JsonObject fluidObject = class_3518.method_15296((JsonObject)jsonObject, (String)"fluid");
            FluidIngredient.JsonParseResult result = FluidIngredient.fromJson(fluidObject);
            fluid = result.result();
            if (result.malformed()) {
                SpectrumCommon.logError("Fusion Recipe " + String.valueOf(identifier) + "contains a malformed fluid input tag! This recipe will not be craftable.");
            } else if (result.result() == FluidIngredient.EMPTY && !result.isTag()) {
                SpectrumCommon.logError("Fusion Recipe " + String.valueOf(identifier) + " specifies fluid " + String.valueOf(result.id()) + " that does not exist! This recipe will not be craftable.");
            }
        }
        class_1799 output = class_3518.method_34923((JsonObject)jsonObject, (String)"result") ? RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result")) : class_1799.field_8037;
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)0.0f);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean yieldUpgradesDisabled = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_upgrades", (boolean)false);
        boolean playCraftingFinishedEffects = class_3518.method_15258((JsonObject)jsonObject, (String)"play_crafting_finished_effects", (boolean)true);
        ArrayList<WorldConditionPredicate> worldConditions = new ArrayList<WorldConditionPredicate>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"world_conditions")) {
            for (JsonElement element : class_3518.method_15261((JsonObject)jsonObject, (String)"world_conditions")) {
                worldConditions.add(WorldConditionPredicate.fromJson(element));
            }
        }
        FusionShrineRecipeWorldEffect startWorldEffect = FusionShrineRecipeWorldEffect.fromString(class_3518.method_15253((JsonObject)jsonObject, (String)"start_crafting_effect", null));
        ArrayList<FusionShrineRecipeWorldEffect> duringWorldEffects = new ArrayList<FusionShrineRecipeWorldEffect>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"during_crafting_effects")) {
            JsonArray worldEffectsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"during_crafting_effects");
            for (int i = 0; i < worldEffectsArray.size(); ++i) {
                duringWorldEffects.add(FusionShrineRecipeWorldEffect.fromString(worldEffectsArray.get(i).getAsString()));
            }
        }
        FusionShrineRecipeWorldEffect finishWorldEffect = FusionShrineRecipeWorldEffect.fromString(class_3518.method_15253((JsonObject)jsonObject, (String)"finish_crafting_effect", null));
        class_5250 description = class_3518.method_15289((JsonObject)jsonObject, (String)"description") ? class_2561.method_43471((String)class_3518.method_15265((JsonObject)jsonObject, (String)"description")) : null;
        boolean copyNbt = class_3518.method_15258((JsonObject)jsonObject, (String)"copy_nbt", (boolean)false);
        if (copyNbt && output.method_7960()) {
            throw new JsonParseException("Recipe does have copy_nbt set, but has no output!");
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, craftingInputs, fluid, output, experience, craftingTime, yieldUpgradesDisabled, playCraftingFinishedEffects, copyNbt, worldConditions, startWorldEffect, duringWorldEffects, finishWorldEffect, (class_2561)description);
    }

    public void write(class_2540 packetByteBuf, FusionShrineRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeShort(recipe.craftingInputs.size());
        for (IngredientStack ingredientStack : recipe.craftingInputs) {
            ingredientStack.write(packetByteBuf);
        }
        this.writeFluidIngredient(packetByteBuf, recipe.fluid);
        packetByteBuf.method_10793(recipe.output);
        packetByteBuf.writeFloat(recipe.experience);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeBoolean(recipe.yieldUpgradesDisabled);
        packetByteBuf.writeBoolean(recipe.playCraftingFinishedEffects);
        if (recipe.getDescription().isEmpty()) {
            packetByteBuf.method_10805((class_2561)class_2561.method_43470((String)""));
        } else {
            packetByteBuf.method_10805(recipe.getDescription().get());
        }
        packetByteBuf.writeBoolean(recipe.copyNbt);
    }

    public FusionShrineRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        short craftingInputCount = packetByteBuf.readShort();
        List ingredients = IngredientStack.decodeByteBuf((class_2540)packetByteBuf, (int)craftingInputCount);
        FluidIngredient fluid = this.readFluidIngredient(packetByteBuf);
        class_1799 output = packetByteBuf.method_10819();
        float experience = packetByteBuf.readFloat();
        int craftingTime = packetByteBuf.readInt();
        boolean yieldUpgradesDisabled = packetByteBuf.readBoolean();
        boolean playCraftingFinishedEffects = packetByteBuf.readBoolean();
        class_2561 description = packetByteBuf.method_10808();
        boolean copyNbt = packetByteBuf.readBoolean();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, fluid, output, experience, craftingTime, yieldUpgradesDisabled, playCraftingFinishedEffects, copyNbt, List.of(), FusionShrineRecipeWorldEffect.NOTHING, List.of(), FusionShrineRecipeWorldEffect.NOTHING, description);
    }

    public static interface RecipeFactory {
        public FusionShrineRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, List<IngredientStack> var5, FluidIngredient var6, class_1799 var7, float var8, int var9, boolean var10, boolean var11, boolean var12, List<WorldConditionPredicate> var13, FusionShrineRecipeWorldEffect var14, List<FusionShrineRecipeWorldEffect> var15, FusionShrineRecipeWorldEffect var16, class_2561 var17);
    }
}

