/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.api.item.GemstoneColor;
import de.dafuqs.spectrum.recipe.pedestal.BuiltinGemstoneColor;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PedestalRecipeTier {
    BASIC(SpectrumAdvancements.PLACED_PEDESTAL, new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW}),
    SIMPLE(SpectrumAdvancements.BUILD_BASIC_PEDESTAL_STRUCTURE, new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW}),
    ADVANCED(SpectrumAdvancements.BUILD_ADVANCED_PEDESTAL_STRUCTURE, new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW, BuiltinGemstoneColor.BLACK}),
    COMPLEX(SpectrumAdvancements.BUILD_COMPLEX_PEDESTAL_STRUCTURE, BuiltinGemstoneColor.values());

    private final class_2960 unlockAdvancementId;
    private final GemstoneColor[] gemstoneColors;

    private PedestalRecipeTier(class_2960 unlockAdvancementId, GemstoneColor[] gemstoneColors) {
        this.unlockAdvancementId = unlockAdvancementId;
        this.gemstoneColors = gemstoneColors;
    }

    @Contract(pure=true)
    public int getPowderSlotCount() {
        return this.gemstoneColors.length;
    }

    @Contract(pure=true)
    public GemstoneColor[] getAvailableGemstoneColors() {
        return this.gemstoneColors;
    }

    @Contract(pure=true)
    public static Optional<PedestalRecipeTier> getHighestUnlockedRecipeTier(class_1657 playerEntity) {
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.COMPLEX.unlockAdvancementId)) {
            return Optional.of(COMPLEX);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.ADVANCED.unlockAdvancementId)) {
            return Optional.of(ADVANCED);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.SIMPLE.unlockAdvancementId)) {
            return Optional.of(SIMPLE);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.BASIC.unlockAdvancementId)) {
            return Optional.of(BASIC);
        }
        return Optional.empty();
    }

    public boolean hasUnlocked(class_1657 playerEntity) {
        return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)this.unlockAdvancementId);
    }

    public static Optional<PedestalRecipeTier> hasJustUnlockedANewRecipeTier(@NotNull class_2960 advancementIdentifier) {
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.BASIC.unlockAdvancementId)) {
            return Optional.of(BASIC);
        }
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.SIMPLE.unlockAdvancementId)) {
            return Optional.of(SIMPLE);
        }
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.ADVANCED.unlockAdvancementId)) {
            return Optional.of(ADVANCED);
        }
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.COMPLEX.unlockAdvancementId)) {
            return Optional.of(COMPLEX);
        }
        return Optional.empty();
    }

    @Contract(pure=true)
    @Nullable
    public class_2960 getStructureID(class_1657 player) {
        switch (this.ordinal()) {
            case 3: {
                if (AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)SpectrumAdvancements.BUILD_COMPLEX_PEDESTAL_STRUCTURE_WITHOUT_MOONSTONE)) {
                    return SpectrumMultiblocks.PEDESTAL_COMPLEX;
                }
                return SpectrumMultiblocks.PEDESTAL_COMPLEX_WITHOUT_MOONSTONE;
            }
            case 2: {
                return SpectrumMultiblocks.PEDESTAL_ADVANCED;
            }
            case 1: {
                return SpectrumMultiblocks.PEDESTAL_SIMPLE;
            }
        }
        return null;
    }

    @Nullable
    public class_2561 getStructureText() {
        switch (this.ordinal()) {
            case 3: {
                return SpectrumMultiblocks.PEDESTAL_COMPLEX_TEXT;
            }
            case 2: {
                return SpectrumMultiblocks.PEDESTAL_ADVANCED_TEXT;
            }
            case 1: {
                return SpectrumMultiblocks.PEDESTAL_SIMPLE_TEXT;
            }
        }
        return null;
    }
}

