/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.potion_workshop.PotionWorkshopBlockEntity;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PotionWorkshopRecipe
extends GatedStackSpectrumRecipe<class_1263> {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/blocks/potion_workshop");
    public static final int[] INGREDIENT_SLOTS = new int[]{2, 3, 4};
    protected final int craftingTime;
    protected final int color;
    protected final IngredientStack ingredient1;
    protected final IngredientStack ingredient2;
    protected final IngredientStack ingredient3;

    public PotionWorkshopRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, int craftingTime, int color, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.color = color;
        this.craftingTime = craftingTime;
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.ingredient3 = ingredient3;
    }

    public List<IngredientStack> getOtherIngredients() {
        ArrayList<IngredientStack> ingredients = new ArrayList<IngredientStack>();
        ingredients.add(this.ingredient1);
        if (!this.ingredient2.isEmpty()) {
            ingredients.add(this.ingredient2);
            if (!this.ingredient3.isEmpty()) {
                ingredients.add(this.ingredient3);
            }
        }
        return ingredients;
    }

    protected void addIngredientStacks(class_2371<IngredientStack> ingredients) {
        ingredients.add((Object)this.ingredient1);
        ingredients.add((Object)this.ingredient2);
        ingredients.add((Object)this.ingredient3);
    }

    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        if (inv.method_5439() > 4 && inv.method_5438(0).method_31574(SpectrumItems.MERMAIDS_GEM) && this.isValidBaseIngredient(inv.method_5438(1))) {
            if (this.usesReagents() ? !this.areStacksInReagentSlotsAllReagents(inv) : !this.areReagentSlotsEmpty(inv)) {
                return false;
            }
            return this.matchIngredientStacksExclusively(inv, this.getOtherIngredients(), INGREDIENT_SLOTS);
        }
        return false;
    }

    private boolean areStacksInReagentSlotsAllReagents(@NotNull class_1263 inv) {
        for (int i : PotionWorkshopBlockEntity.REAGENT_SLOTS) {
            class_1799 itemStack = inv.method_5438(i);
            if (itemStack.method_7960() || PotionWorkshopReactingRecipe.isReagent(itemStack.method_7909())) continue;
            return false;
        }
        return true;
    }

    private boolean areReagentSlotsEmpty(@NotNull class_1263 inv) {
        for (int i : PotionWorkshopBlockEntity.REAGENT_SLOTS) {
            if (inv.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isValidBaseIngredient(class_1799 var1);

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_17447() {
        return SpectrumBlocks.POTION_WORKSHOP.method_8389().method_7854();
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.ANVIL_CRUSHING_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.ANVIL_CRUSHING;
    }

    public abstract boolean usesReagents();

    public abstract int getMinOutputCount(class_1799 var1);

    public int getColor() {
        return this.color;
    }

    @Override
    @Nullable
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    public int getRequiredExperience() {
        return 0;
    }
}

