/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlockEntity;
import de.dafuqs.spectrum.helpers.LoreHelper;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.food.beverages.properties.StatusEffectBeverageProperties;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public interface ITitrationBarrelRecipe
extends GatedRecipe<TitrationBarrelBlockEntity> {
    public static final class_2960 UNLOCK_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("unlocks/blocks/titration_barrel");

    default public class_1799 getResult(class_1263 inventory, long secondsFermented, float downfall) {
        if (secondsFermented < 0L) {
            float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
            List<class_1293> statusEffects = List.of(new class_1293(class_1294.field_5905, 3600, 0));
            class_1799 stack = new StatusEffectBeverageProperties((long)ageIngameDays, 0, 0.0f, statusEffects).getStack(SpectrumItems.SUSPICIOUS_BREW.method_7854());
            LoreHelper.setLore(stack, (class_2561)class_2561.method_43471((String)"lore.spectrum.time_travel_tap"));
            return stack;
        }
        return this.tap(inventory, secondsFermented, downfall);
    }

    public class_1799 tap(class_1263 var1, long var2, float var4);

    public class_1792 getTappingItem();

    public FluidIngredient getFluidInput();

    public float getAngelsSharePerMcDay();

    default public int getOutputCountAfterAngelsShare(class_1937 world, float temperature, long secondsFermented) {
        int originalOutputCount = this.method_8110(world.method_30349()).method_7947();
        if (this.getFermentationData() == null) {
            return originalOutputCount;
        }
        float angelsShareResultCountMod = this.getAngelsShareResultCountMod(secondsFermented, temperature);
        if (angelsShareResultCountMod > 0.0f) {
            return Math.max(1, (int)Math.ceil((float)originalOutputCount - angelsShareResultCountMod));
        }
        return Math.max(1, (int)Math.floor((float)originalOutputCount - angelsShareResultCountMod));
    }

    default public float getAngelsShareResultCountMod(long secondsFermented, float temperature) {
        return Math.max(0.1f, temperature / 10.0f) * TimeHelper.minecraftDaysFromSeconds(secondsFermented) * this.getAngelsSharePerMcDay();
    }

    default public boolean method_8113(int width, int height) {
        return true;
    }

    default public class_1799 method_17447() {
        return SpectrumBlocks.TITRATION_BARREL.method_8389().method_7854();
    }

    default public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.TITRATION_BARREL;
    }

    public List<IngredientStack> getIngredientStacks();

    public int getMinFermentationTimeHours();

    default public boolean isFermentingLongEnoughToTap(long secondsFermented) {
        return secondsFermented / 60L / 60L >= (long)this.getMinFermentationTimeHours();
    }

    public FermentationData getFermentationData();
}

