/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.recipe.EmptyRecipeSerializer;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.dynamic.SweetenableTitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

public class AquaRegiaRecipe
extends SweetenableTitrationBarrelRecipe {
    public static final class_1865<AquaRegiaRecipe> SERIALIZER = new EmptyRecipeSerializer<AquaRegiaRecipe>(AquaRegiaRecipe::new);
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("hidden/collect_cookbooks/imbrifer_cookbook");
    public static final int MIN_FERMENTATION_TIME_HOURS = 24;
    public static final class_1799 OUTPUT_STACK = AquaRegiaRecipe.getDefaultStackWithCount(SpectrumItems.AQUA_REGIA, 4);
    public static final class_1792 TAPPING_ITEM = class_1802.field_8469;
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.ofItems((int)1, (class_1935[])new class_1935[]{SpectrumBlocks.JADEITE_LOTUS_BULB}));
            this.add(IngredientStack.ofItems((int)3, (class_1935[])new class_1935[]{SpectrumItems.JADEITE_PETALS}));
        }
    };

    public AquaRegiaRecipe(class_2960 identifier) {
        super(identifier, "", false, UNLOCK_IDENTIFIER, INGREDIENT_STACKS, FluidIngredient.of((class_3611)class_3612.field_15910), OUTPUT_STACK, TAPPING_ITEM, 24, new FermentationData(0.2f, 0.01f, List.of()));
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        int bulbCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumBlocks.JADEITE_LOTUS_BULB.method_8389());
        int petalCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.JADEITE_PETALS);
        boolean nectar = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.MOONSTRUCK_NECTAR) > 0;
        float thickness = this.getThickness(bulbCount, petalCount);
        return this.tapWith(bulbCount, petalCount, nectar, thickness, secondsFermented, downfall);
    }

    @Override
    @NotNull
    protected List<class_1293> getEffects(boolean nectar, double bloominess, double alcPercent) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        int effectDuration = 1800;
        if (alcPercent >= 40.0) {
            effects.add(new class_1293(class_1294.field_5927, effectDuration *= 2, 3));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 35.0) {
            effects.add(new class_1293(SpectrumStatusEffects.EFFECT_PROLONGING, effectDuration, (int)(alcPercent / 12.0)));
            effectDuration *= 2;
        }
        if (alcPercent >= 30.0) {
            effects.add(new class_1293(class_1294.field_5900, effectDuration));
            effectDuration *= 3;
        }
        if (alcPercent >= 20.0) {
            effects.add(new class_1293(class_1294.field_5898, effectDuration, (int)(alcPercent / 10.0)));
            effectDuration *= 2;
        }
        if (alcPercent >= 10.0) {
            effects.add(new class_1293(SpectrumStatusEffects.NOURISHING, effectDuration));
            effectDuration *= 2;
        }
        if (nectar) {
            effects.add(new class_1293(SpectrumStatusEffects.IMMUNITY, effectDuration / 2));
        }
        int nectarMod = nectar ? 3 : 1;
        effectDuration = 1200;
        int alcAfterBloominess = (int)(alcPercent / ((double)nectarMod + bloominess));
        if (alcAfterBloominess >= 40) {
            effects.add(new class_1293(class_1294.field_5919, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 30) {
            effects.add(new class_1293(class_1294.field_5899, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 20) {
            effects.add(new class_1293(class_1294.field_5916, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 10) {
            effects.add(new class_1293(class_1294.field_5911, effectDuration));
        }
        return effects;
    }

    @Override
    public boolean matches(TitrationBarrelBlockEntity inventory, class_1937 world) {
        boolean bulbsFound = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31574(SpectrumBlocks.JADEITE_LOTUS_BULB.method_8389())) {
                bulbsFound = true;
                continue;
            }
            if (stack.method_31574(SpectrumItems.JADEITE_PETALS) || stack.method_31574(SpectrumItems.MOONSTRUCK_NECTAR)) continue;
            return false;
        }
        return bulbsFound;
    }

    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }
}

