/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3489;
import net.minecraft.class_8242;

public class SpectrumTooltips {
    public static void register() {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            class_2487 nbt = stack.method_7969();
            if (nbt != null) {
                if (stack.method_31574(class_2246.field_37571.method_8389())) {
                    SpectrumTooltips.addSculkShriekerTooltips(lines, nbt);
                } else if (stack.method_31573(class_3489.field_15533)) {
                    SpectrumTooltips.addSignTooltips(lines, nbt);
                } else if (stack.method_31574(class_1802.field_8849)) {
                    SpectrumTooltips.addSpawnerTooltips(lines, nbt);
                }
                if (nbt.method_10577("BMCursed")) {
                    lines.add(class_2561.method_43471((String)"spectrum.tooltip.biomemakeover_cursed").method_27692(class_124.field_1080));
                }
            }
        });
    }

    private static void addSculkShriekerTooltips(List<class_2561> lines, class_2487 nbt) {
        if (!nbt.method_10573("BlockStateTag", 10)) {
            return;
        }
        class_2487 blockStateTag = nbt.method_10562("BlockStateTag");
        if (Boolean.parseBoolean(blockStateTag.method_10558("can_summon"))) {
            lines.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.able_to_summon_warden").method_27692(class_124.field_1080));
        }
    }

    private static void addSignTooltips(List<class_2561> lines, class_2487 nbt) {
        if (!nbt.method_10573("BlockEntityTag", 10)) {
            return;
        }
        class_2487 blockEntityTag = nbt.method_10562("BlockEntityTag");
        SpectrumTooltips.addSignText(lines, (DataResult<class_8242>)class_8242.field_43298.parse((DynamicOps)class_2509.field_11560, (Object)blockEntityTag.method_10562("front_text")));
        SpectrumTooltips.addSignText(lines, (DataResult<class_8242>)class_8242.field_43298.parse((DynamicOps)class_2509.field_11560, (Object)blockEntityTag.method_10562("back_text")));
    }

    private static void addSignText(List<class_2561> lines, DataResult<class_8242> signText) {
        if (signText.result().isPresent()) {
            class_8242 st = (class_8242)signText.result().get();
            class_2583 style = class_2583.field_24360.method_36139(st.method_49872().method_16357());
            for (class_2561 text : st.method_49877(false)) {
                lines.addAll(text.method_36136(style));
            }
        }
    }

    public static void addSpawnerTooltips(List<class_2561> lines, class_2487 nbt) {
        if (!nbt.method_10573("BlockEntityTag", 10)) {
            return;
        }
        Optional entityType = Optional.empty();
        class_2487 blockEntityTag = nbt.method_10562("BlockEntityTag");
        if (blockEntityTag.method_10573("SpawnData", 10) && blockEntityTag.method_10562("SpawnData").method_10573("entity", 10) && blockEntityTag.method_10562("SpawnData").method_10562("entity").method_10573("id", 8)) {
            String spawningEntityType = blockEntityTag.method_10562("SpawnData").method_10562("entity").method_10558("id");
            entityType = class_1299.method_5898((String)spawningEntityType);
        }
        try {
            short spawnCount = blockEntityTag.method_10568("SpawnCount");
            short minSpawnDelay = blockEntityTag.method_10568("MinSpawnDelay");
            short maxSpawnDelay = blockEntityTag.method_10568("MaxSpawnDelay");
            short spawnRange = blockEntityTag.method_10568("SpawnRange");
            short requiredPlayerRange = blockEntityTag.method_10568("RequiredPlayerRange");
            short maxNearbyEntities = blockEntityTag.method_10568("MaxNearbyEntities");
            if (entityType.isPresent()) {
                lines.add((class_2561)class_2561.method_43471((String)((class_1299)entityType.get()).method_5882()));
            } else {
                lines.add((class_2561)class_2561.method_43471((String)"item.spectrum.spawner.tooltip.unknown_mob"));
            }
            if (spawnCount > 0) {
                lines.add((class_2561)class_2561.method_43469((String)"item.spectrum.spawner.tooltip.spawn_count", (Object[])new Object[]{spawnCount}).method_27692(class_124.field_1080));
            }
            if (minSpawnDelay > 0) {
                lines.add((class_2561)class_2561.method_43469((String)"item.spectrum.spawner.tooltip.min_spawn_delay", (Object[])new Object[]{minSpawnDelay}).method_27692(class_124.field_1080));
            }
            if (maxSpawnDelay > 0) {
                lines.add((class_2561)class_2561.method_43469((String)"item.spectrum.spawner.tooltip.max_spawn_delay", (Object[])new Object[]{maxSpawnDelay}).method_27692(class_124.field_1080));
            }
            if (spawnRange > 0) {
                lines.add((class_2561)class_2561.method_43469((String)"item.spectrum.spawner.tooltip.spawn_range", (Object[])new Object[]{spawnRange}).method_27692(class_124.field_1080));
            }
            if (requiredPlayerRange > 0) {
                lines.add((class_2561)class_2561.method_43469((String)"item.spectrum.spawner.tooltip.required_player_range", (Object[])new Object[]{requiredPlayerRange}).method_27692(class_124.field_1080));
            }
            if (maxNearbyEntities > 0) {
                lines.add((class_2561)class_2561.method_43469((String)"item.spectrum.spawner.tooltip.max_nearby_entities", (Object[])new Object[]{maxNearbyEntities}).method_27692(class_124.field_1080));
            }
        }
        catch (Exception e) {
            lines.add((class_2561)class_2561.method_43471((String)"item.spectrum.spawner.tooltip.unknown_mob"));
        }
    }
}

