/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.interaction.ItemProvider;
import de.dafuqs.spectrum.api.interaction.ItemProviderRegistry;
import de.dafuqs.spectrum.api.render.DynamicItemRenderer;
import de.dafuqs.spectrum.api.render.DynamicRenderModel;
import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.data_loaders.ParticleSpawnerParticlesDataLoader;
import de.dafuqs.spectrum.deeper_down.DarknessEffects;
import de.dafuqs.spectrum.deeper_down.HowlingSpireEffects;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.helpers.TooltipHelper;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import de.dafuqs.spectrum.items.magic_items.ConstructorsStaffItem;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.tools.OmniAcceleratorItem;
import de.dafuqs.spectrum.mixin.accessors.WorldRendererAccessor;
import de.dafuqs.spectrum.particle.render.ExtendedParticleManager;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.client.SpectrumColorProviders;
import de.dafuqs.spectrum.render.HudRenderers;
import de.dafuqs.spectrum.sound.BiomeAttenuatingSoundInstance;
import de.dafuqs.spectrum.sound.BlockAuraSoundInstance;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1091;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

@Environment(value=EnvType.CLIENT)
public class SpectrumClientEventListeners {
    public static final ObjectOpenHashSet<class_1091> CUSTOM_ITEM_MODELS = new ObjectOpenHashSet();
    public static final boolean foodEffectsTooltipsModLoaded = FabricLoader.getInstance().isModLoaded("foodeffecttooltips");

    private static void registerCustomItemRenderer(String id, class_1792 item, Supplier<DynamicItemRenderer> renderer) {
        CUSTOM_ITEM_MODELS.add((Object)new class_1091("spectrum", id, "inventory"));
        DynamicItemRenderer.RENDERERS.put((Object)item, (Object)renderer.get());
    }

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ParticleSpawnerParticlesDataLoader.INSTANCE);
        SpectrumClientEventListeners.registerCustomItemRenderer("bottomless_bundle", (class_1792)SpectrumItems.BOTTOMLESS_BUNDLE, BottomlessBundleItem.Renderer::new);
        SpectrumClientEventListeners.registerCustomItemRenderer("omni_accelerator", SpectrumItems.OMNI_ACCELERATOR, OmniAcceleratorItem.Renderer::new);
        WorldRenderEvents.START.register(context -> HudRenderers.clearItemStackOverlay());
        WorldRenderEvents.AFTER_ENTITIES.register(context -> ((ExtendedParticleManager)class_310.method_1551().field_1713).render(context.matrixStack(), context.consumers(), context.camera(), context.tickDelta()));
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> Pastel.getClientInstance().renderLines(context));
        WorldRenderEvents.BLOCK_OUTLINE.register(SpectrumClientEventListeners::renderExtendedBlockOutline);
        BiomeAttenuatingSoundInstance.clear();
        ModelLoadingPlugin.register(ctx -> ctx.modifyModelAfterBake().register((orig, c) -> {
            class_1091 mid;
            class_2960 id = c.id();
            if (id instanceof class_1091 && CUSTOM_ITEM_MODELS.contains((Object)(mid = (class_1091)id))) {
                return new DynamicRenderModel(orig);
            }
            return orig;
        }));
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraftClient -> SpectrumColorProviders.registerClient());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> Pastel.clearClientInstance());
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            if (!foodEffectsTooltipsModLoaded && stack.method_19267() && class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals("spectrum")) {
                TooltipHelper.addFoodComponentEffectTooltip(stack, lines);
            }
            if (stack.method_31573(SpectrumItemTags.COMING_SOON_TOOLTIP)) {
                lines.add(class_2561.method_43471((String)"spectrum.tooltip.coming_soon").method_27692(class_124.field_1061));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_638 world = client.field_1687;
            class_1297 cameraEntity = client.method_1560();
            if (world == null || cameraEntity == null) {
                BiomeAttenuatingSoundInstance.clear();
                BlockAuraSoundInstance.clear();
                return;
            }
            class_6880 biome = world.method_23753(client.method_1560().method_24515());
            HowlingSpireEffects.clientTick(world, cameraEntity, (class_6880<class_1959>)biome);
            DarknessEffects.clientTick(world, cameraEntity, (class_6880<class_1959>)biome);
        });
    }

    private static boolean renderExtendedBlockOutline(WorldRenderContext context, WorldRenderContext.BlockOutlineContext hitResult) {
        boolean shouldCancel = false;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && context.blockOutlines()) {
            for (class_1799 handStack : client.field_1724.method_5877()) {
                class_1792 handItem = handStack.method_7909();
                if (handItem instanceof ConstructorsStaffItem) {
                    class_239 class_2393;
                    if (hitResult == null || !((class_2393 = client.field_1765) instanceof class_3965)) break;
                    class_3965 blockHitResult = (class_3965)class_2393;
                    shouldCancel = SpectrumClientEventListeners.renderPlacementStaffOutline(context.matrixStack(), context.camera(), hitResult.cameraX(), hitResult.cameraY(), hitResult.cameraZ(), context.consumers(), blockHitResult);
                    break;
                }
                if (!(handItem instanceof ExchangeStaffItem)) continue;
                if (hitResult == null) break;
                shouldCancel = SpectrumClientEventListeners.renderExchangeStaffOutline(context.matrixStack(), context.camera(), hitResult.cameraX(), hitResult.cameraY(), hitResult.cameraZ(), context.consumers(), handStack, hitResult);
                break;
            }
        }
        return !shouldCancel;
    }

    private static boolean renderPlacementStaffOutline(class_4587 matrices, class_4184 camera, double d, double e, double f, class_4597 consumers, @NotNull class_3965 hitResult) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (player == null || world == null) {
            return false;
        }
        class_2338 lookingAtPos = hitResult.method_17777();
        class_2680 lookingAtState = world.method_8320(lookingAtPos);
        class_1792 class_17922 = player.method_6047().method_7909();
        if (class_17922 instanceof BuildingStaffItem) {
            BuildingStaffItem staff = (BuildingStaffItem)class_17922;
            if (player.method_7337() || staff.canInteractWith(lookingAtState, (class_1922)world, lookingAtPos, (class_1657)player)) {
                class_2248 lookingAtBlock = lookingAtState.method_26204();
                class_1792 item = lookingAtBlock.method_8389();
                class_265 shape = class_259.method_1073();
                if (item != class_1802.field_8162) {
                    int itemCountInInventory = Integer.MAX_VALUE;
                    long inkLimit = Long.MAX_VALUE;
                    if (!player.method_7337()) {
                        Triplet<class_2248, class_1792, Integer> inventoryItemAndCount = BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars((class_1657)player, lookingAtBlock, Integer.MAX_VALUE);
                        item = (class_1792)inventoryItemAndCount.getB();
                        itemCountInInventory = (Integer)inventoryItemAndCount.getC();
                        inkLimit = InkPowered.getAvailableInk((class_1657)player, ConstructorsStaffItem.USED_COLOR) / 1L;
                    }
                    boolean sneaking = player.method_5715();
                    if (itemCountInInventory == 0) {
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)item), 0, false);
                    } else if (inkLimit == 0L) {
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)item), 1, true);
                    } else {
                        long usableCount = Math.min((long)itemCountInInventory, inkLimit);
                        List<class_2338> positions = BuildingHelper.calculateBuildingStaffSelection((class_1937)world, lookingAtPos, hitResult.method_17780(), usableCount, ConstructorsStaffItem.getRange((class_1657)player), !sneaking);
                        if (!positions.isEmpty()) {
                            for (class_2338 newPosition : positions) {
                                if (!world.method_8621().method_11952(newPosition)) continue;
                                class_2338 testPos = lookingAtPos.method_10059((class_2382)newPosition);
                                shape = class_259.method_1084((class_265)shape, (class_265)lookingAtState.method_26172((class_1922)world, lookingAtPos, class_3726.method_16195((class_1297)camera.method_19331())).method_1096((double)(-testPos.method_10263()), (double)(-testPos.method_10264()), (double)(-testPos.method_10260())));
                            }
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)item), positions.size(), false);
                            class_4588 linesBuffer = consumers.getBuffer(class_1921.method_23594());
                            WorldRendererAccessor.invokeDrawCuboidShapeOutline(matrices, linesBuffer, shape, (double)lookingAtPos.method_10263() - d, (double)lookingAtPos.method_10264() - e, (double)lookingAtPos.method_10260() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean renderExchangeStaffOutline(class_4587 matrices, class_4184 camera, double d, double e, double f, class_4597 consumers, class_1799 exchangeStaffItemStack, WorldRenderContext.BlockOutlineContext hitResult) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_2338 lookingAtPos = hitResult.blockPos();
        class_2680 lookingAtState = hitResult.blockState();
        class_746 player = client.field_1724;
        if (player == null || world == null) {
            return false;
        }
        class_1792 class_17922 = player.method_6047().method_7909();
        if (class_17922 instanceof BuildingStaffItem) {
            BuildingStaffItem staff = (BuildingStaffItem)class_17922;
            if (player.method_7337() || staff.canInteractWith(lookingAtState, (class_1922)world, lookingAtPos, (class_1657)player)) {
                class_2248 lookingAtBlock = lookingAtState.method_26204();
                Optional<class_2248> exchangeBlock = ExchangeStaffItem.getStoredBlock(exchangeStaffItemStack);
                if (exchangeBlock.isPresent() && exchangeBlock.get() != lookingAtBlock) {
                    class_1792 exchangeBlockItem = exchangeBlock.get().method_8389();
                    class_265 shape = class_259.method_1073();
                    if (exchangeBlockItem != class_1802.field_8162) {
                        int itemCountInInventory = Integer.MAX_VALUE;
                        long inkLimit = Integer.MAX_VALUE;
                        if (!player.method_7337()) {
                            class_1661 playerInventory = player.method_31548();
                            itemCountInInventory = playerInventory.method_18861(exchangeBlockItem);
                            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                                class_1799 currentStack = playerInventory.method_5438(i);
                                ItemProvider itemProvider = ItemProviderRegistry.getProvider(currentStack);
                                if (itemProvider == null) continue;
                                itemCountInInventory += itemProvider.getItemCount((class_1657)player, currentStack, exchangeBlockItem);
                            }
                            inkLimit = InkPowered.getAvailableInk((class_1657)player, ExchangeStaffItem.USED_COLOR) / 5L;
                        }
                        if (itemCountInInventory == 0) {
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), 0, false);
                        } else if (inkLimit == 0L) {
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), 1, true);
                        } else {
                            long usableCount = Math.min((long)itemCountInInventory, inkLimit);
                            List<class_2338> positions = BuildingHelper.getConnectedBlocks((class_1937)world, lookingAtPos, usableCount, ExchangeStaffItem.getRange((class_1657)player));
                            for (class_2338 newPosition : positions) {
                                if (!world.method_8621().method_11952(newPosition)) continue;
                                class_2338 testPos = lookingAtPos.method_10059((class_2382)newPosition);
                                shape = class_259.method_1084((class_265)shape, (class_265)lookingAtState.method_26172((class_1922)world, lookingAtPos, class_3726.method_16195((class_1297)camera.method_19331())).method_1096((double)(-testPos.method_10263()), (double)(-testPos.method_10264()), (double)(-testPos.method_10260())));
                            }
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), positions.size(), false);
                            class_4588 linesBuffer = consumers.getBuffer(class_1921.method_23594());
                            WorldRendererAccessor.invokeDrawCuboidShapeOutline(matrices, linesBuffer, shape, (double)lookingAtPos.method_10263() - d, (double)lookingAtPos.method_10264() - e, (double)lookingAtPos.method_10260() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

