/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.api.data.SkinQueryResult;
import dev.imb11.skinshuffle.mixin.accessor.MinecraftClientAccessor;
import dev.imb11.skinshuffle.mixin.accessor.MinecraftClientAuthAccessor;
import dev.imb11.skinshuffle.mixin.accessor.YggdrasilUserApiServiceAccessor;
import dev.imb11.skinshuffle.util.NetworkingUtil;
import dev.imb11.skinshuffle.util.SkinCacheRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.RequestBodyEntity;
import kong.unirest.Unirest;
import net.minecraft.class_310;

public class MojangSkinAPI {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean setSkinTexture(String skinURL, String model) {
        UserApiService service = ((MinecraftClientAccessor)class_310.method_1551()).getUserApiService();
        if (service instanceof YggdrasilUserApiService) {
            YggdrasilUserApiService apiService = (YggdrasilUserApiService)service;
            try {
                MinecraftClient client = ((YggdrasilUserApiServiceAccessor)apiService).getMinecraftClient();
                String token = ((MinecraftClientAuthAccessor)client).getAccessToken();
                JsonObject obj = new JsonObject();
                obj.addProperty("variant", model);
                obj.addProperty("url", skinURL);
                String result = (String)((RequestBodyEntity)Unirest.post((String)"https://api.minecraftservices.com/minecraft/profile/skins").body(GSON.toJson((JsonElement)obj)).contentType("application/json").header("Authorization", "Bearer " + token)).asString().getBody();
                SkinShuffle.LOGGER.info("Set player skin: " + skinURL);
            }
            catch (Exception e) {
                SkinShuffle.LOGGER.error("Cannot connect to Mojang API.", (Throwable)e);
                return false;
            }
        } else {
            SkinShuffle.LOGGER.error("Cannot connect to Mojang API - offline mode is active.");
            return false;
        }
        return true;
    }

    public static SkinQueryResult getPlayerSkinTexture(String uuid) {
        try {
            String jsonResponse = (String)Unirest.get((String)("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false")).asString().getBody();
            if (jsonResponse.isBlank()) {
                throw new IOException("Empty response from Mojang API.");
            }
            Gson gson = new Gson();
            JsonObject object = (JsonObject)gson.fromJson(jsonResponse, JsonObject.class);
            JsonObject textureJSON = new JsonObject();
            textureJSON.addProperty("invalid", Boolean.valueOf(true));
            String textureSignature = null;
            String textureValue = null;
            for (JsonElement properties : object.get("properties").getAsJsonArray()) {
                if (!properties.getAsJsonObject().get("name").getAsString().equals("textures")) continue;
                try {
                    textureSignature = properties.getAsJsonObject().get("signature").getAsString();
                    textureValue = properties.getAsJsonObject().get("value").getAsString();
                    if (textureValue != null) {
                        String jsonContent = new String(Base64.getDecoder().decode(textureValue), StandardCharsets.UTF_8);
                        textureJSON = (JsonObject)gson.fromJson(jsonContent, JsonObject.class);
                        break;
                    }
                    SkinShuffle.LOGGER.warn("Received null texture value from Mojang API");
                }
                catch (Exception e) {
                    SkinShuffle.LOGGER.error("Failed to decode texture data", (Throwable)e);
                }
                break;
            }
            if (textureJSON.has("invalid")) {
                return SkinQueryResult.EMPTY_RESULT;
            }
            if (!textureJSON.get("textures").getAsJsonObject().has("SKIN")) {
                return SkinQueryResult.EMPTY_RESULT;
            }
            JsonObject skin = textureJSON.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject();
            if (skin.get("url").getAsString().equals("Steve?") || skin.get("url").getAsString().equals("Alex?")) {
                return SkinQueryResult.EMPTY_RESULT;
            }
            String skinURL = skin.get("url").getAsString();
            String modelType = "classic";
            try {
                modelType = skin.get("metadata").getAsJsonObject().get("model").getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String capeURL = null;
            try {
                JsonObject cape = textureJSON.get("textures").getAsJsonObject().get("CAPE").getAsJsonObject();
                capeURL = cape.get("url").getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new SkinQueryResult(false, skinURL, modelType, textureSignature, textureValue);
        }
        catch (Exception e) {
            SkinShuffle.LOGGER.error(e.getMessage());
            return SkinQueryResult.EMPTY_RESULT;
        }
    }

    public static Optional<UUID> getUUIDFromUsername(String username) {
        try {
            String jsonResponse = (String)Unirest.get((String)("https://api.mojang.com/users/profiles/minecraft/" + username)).asString().getBody();
            Gson gson = new Gson();
            JsonObject object = (JsonObject)gson.fromJson(jsonResponse, JsonObject.class);
            if (object.has("error")) {
                throw new RuntimeException(object.get("errorMessage").getAsString());
            }
            String idString = object.get("id").getAsString();
            return Optional.of(UUID.fromString(idString.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5")));
        }
        catch (Exception e) {
            SkinShuffle.LOGGER.error(e.toString());
            return Optional.empty();
        }
    }

    public static boolean setSkinTexture(File skinFile, String model) {
        UserApiService service = ((MinecraftClientAccessor)class_310.method_1551()).getUserApiService();
        if (model.equals("default")) {
            model = "classic";
        }
        try {
            String cachedURL = SkinCacheRegistry.getCachedUploadedSkin(skinFile);
            if (cachedURL != null) {
                return MojangSkinAPI.setSkinTexture(cachedURL, model);
            }
        }
        catch (IOException e) {
            SkinShuffle.LOGGER.error("Failed to hash file.");
            return false;
        }
        if (NetworkingUtil.isLoggedIn()) {
            try {
                MinecraftClient client = ((YggdrasilUserApiServiceAccessor)service).getMinecraftClient();
                String token = ((MinecraftClientAuthAccessor)client).getAccessToken();
                HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)"https://api.minecraftservices.com/minecraft/profile/skins").header("Authorization", "Bearer " + token)).field("variant", (Object)model).field("file", skinFile).asString();
                JsonObject responseObject = (JsonObject)GSON.fromJson((String)response.getBody(), JsonObject.class);
                String skinURL = responseObject.get("skins").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString();
                SkinCacheRegistry.saveUploadedSkin(skinFile, skinURL);
                SkinShuffle.LOGGER.info("Uploaded texture: " + skinURL);
                SkinShuffle.LOGGER.info("Set player skin: " + skinURL);
                return true;
            }
            catch (Exception e) {
                SkinShuffle.LOGGER.error(e.toString());
                return false;
            }
        }
        SkinShuffle.LOGGER.error("Cannot connect to Mojang API.");
        return false;
    }
}

