/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui;

import dev.imb11.skinshuffle.client.config.SkinPresetManager;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.gui.carousels.CarouselScreen;
import dev.imb11.skinshuffle.client.gui.components.SkinCustomizationTabComponent;
import dev.imb11.skinshuffle.client.gui.components.SkinSourceTabComponent;
import dev.imb11.skinshuffle.client.gui.renderer.SkinPreviewRenderer;
import dev.imb11.skinshuffle.client.gui.widgets.presets.PresetWidget;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;

public class PresetEditScreen
extends SpruceScreen {
    public static final int MAX_WIDTH = 400;
    private final CarouselScreen parent;
    private final SkinPreset originalPreset;
    private final SkinPreset preset;
    private final PresetWidget<?> presetWidget;
    private final SkinPreviewRenderer previewRenderer;
    private int sideMargins;
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    private class_8089 tabNavigation;
    private SkinSourceTabComponent skinSourceTab;
    private SkinCustomizationTabComponent skinCustomizationTab;
    private class_7845 actionButtonsGrid;
    private class_4185 exitButton;
    private boolean isValid = true;

    public PresetEditScreen(PresetWidget<?> presetWidget, CarouselScreen parent, SkinPreset preset) {
        super((class_2561)class_2561.method_43471((String)"skinshuffle.edit.title"));
        this.presetWidget = presetWidget;
        this.preset = preset.copy();
        this.originalPreset = preset;
        this.parent = parent;
        this.previewRenderer = new SkinPreviewRenderer(class_310.method_1551());
    }

    protected void method_25426() {
        super.method_25426();
        this.skinSourceTab = new SkinSourceTabComponent(this.field_22793, this.preset, this.field_22787, isValid -> {
            this.isValid = isValid;
            this.updateButtonStates();
        });
        this.skinCustomizationTab = new SkinCustomizationTabComponent(this.field_22793, this.preset);
        this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(new class_8087[]{this.skinSourceTab, this.skinCustomizationTab}).method_48627();
        this.method_37063((class_364)this.tabNavigation);
        this.actionButtonsGrid = new class_7845().method_48635(10);
        class_7845.class_7939 adder = this.actionButtonsGrid.method_47610(2);
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46431());
        this.exitButton = class_4185.method_46430((class_2561)class_5244.field_44914, button -> {
            this.saveChanges();
            this.parent.hasEditedPreset = true;
            this.method_25419();
        }).method_46431();
        adder.method_47612((class_8021)this.exitButton);
        this.actionButtonsGrid.method_48206(child -> {
            child.method_48591(1);
            this.method_37063((class_364)child);
        });
        this.initTabNavigation();
        this.tabNavigation.method_48987(0, false);
    }

    protected void initTabNavigation() {
        this.sideMargins = Math.max(this.field_22789 - 400, 0) / 2;
        if (this.tabNavigation != null && this.actionButtonsGrid != null) {
            this.tabNavigation.method_48618(this.field_22789);
            this.tabNavigation.method_49613();
            this.actionButtonsGrid.method_48222();
            class_7843.method_46442((class_8021)this.actionButtonsGrid, (int)0, (int)(this.field_22790 - 36), (int)this.field_22789, (int)36);
            int navBottom = this.tabNavigation.method_48202().method_49619();
            class_8030 screenRect = new class_8030(0, navBottom, this.field_22789, this.actionButtonsGrid.method_46427() - navBottom);
            this.tabManager.method_48616(screenRect);
            this.skinSourceTab.initialize(this.field_22789, this.field_22790, this.sideMargins);
            this.skinCustomizationTab.initialize(this.field_22789, this.field_22790, this.sideMargins);
        }
    }

    private void updateButtonStates() {
        this.exitButton.field_22763 = !this.preset.equals(this.originalPreset);
    }

    private void saveChanges() {
        this.originalPreset.copyFrom(this.preset);
        try {
            this.originalPreset.setSkin(this.preset.getSkin().saveToConfig());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SkinPresetManager.savePresets();
    }

    public void method_29638(List<Path> paths) {
        if (!paths.isEmpty()) {
            Path firstPath = paths.getFirst();
            this.tabNavigation.method_48987(0, false);
            this.skinSourceTab.handleFileDrop(firstPath);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        int ratioMulTen = 16;
        int topBottomMargin = 40;
        int leftRightMargin = 20;
        int previewSpanX = 66 - leftRightMargin;
        int previewSpanY = Math.min(this.field_22790 - topBottomMargin * 2, previewSpanX * 2 * ratioMulTen / 10) / 2;
        int previewCenterX = 66 + this.sideMargins;
        int previewCenterY = Math.max(this.field_22790 / 4 + previewSpanY / 2, 120);
        this.previewRenderer.renderPreviewArea(graphics, previewCenterX, previewCenterY, previewSpanX, previewSpanY);
        SkinShuffleConfig.SkinRenderStyle renderStyle = SkinShuffleConfig.get().presetEditScreenRenderStyle;
        this.previewRenderer.renderSkinPreview(graphics, this.preset, mouseX, mouseY, previewCenterX, previewCenterY, previewSpanY, renderStyle, this.skinSourceTab != null && this.skinSourceTab.isLoading());
        this.exitButton.field_22763 = !this.preset.equals(this.originalPreset);
        class_5250 text = class_2561.method_43471((String)"skinshuffle.edit.drag_and_drop");
        int x = this.exitButton.method_46426() - this.field_22793.method_27525((class_5348)text) / 2;
        int n = this.exitButton.method_46427();
        Objects.requireNonNull(this.field_22793);
        int y = n - 9 - 5;
        graphics.method_27535(this.field_22793, (class_2561)text, x, y, -805306369);
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)this.parent);
    }
}

