/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.imb11.skinshuffle.client.SkinShuffleClient;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.skin.Skin;
import dev.imb11.skinshuffle.compat.ETFCompat;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_591;
import net.minecraft.class_630;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class GuiEntityRenderer {
    public static void drawEntity(class_4587 matrices, int x, int y, int size, float rotation, double mouseX, double mouseY, Skin skin, SkinShuffleConfig.SkinRenderStyle style) {
        float yaw = (float)Math.atan2(mouseX, 120.0);
        float pitch = (float)Math.atan2(-mouseY, 120.0);
        Quaternionf entityRotation = new Quaternionf().rotateY(rotation * 0.025f);
        if (style == SkinShuffleConfig.SkinRenderStyle.CURSOR) {
            Quaternionf pitchRotation = new Quaternionf().rotateX(pitch * 10.0f * ((float)Math.PI / 180));
            Quaternionf yawRotation = new Quaternionf().rotateY(yaw * 10.0f * ((float)Math.PI / 180));
            entityRotation.mul((Quaternionfc)pitchRotation);
            entityRotation.mul((Quaternionfc)yawRotation);
        }
        GuiEntityRenderer.setupModelViewStack();
        GuiEntityRenderer.setupMatrices(matrices, x, y, size, entityRotation);
        GuiEntityRenderer.renderEntity(matrices, yaw, pitch, skin, (long)SkinShuffleClient.TOTAL_TICK_DELTA);
        GuiEntityRenderer.cleanupMatrices(matrices);
        GuiEntityRenderer.cleanupModelViewStack();
    }

    private static void setupModelViewStack() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate(0.0f, 0.0f, 1000.0f);
    }

    private static void setupMatrices(class_4587 matrices, int x, int y, int size, Quaternionf entityRotation) {
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 100.0);
        matrices.method_34425((Matrix4fc)new Matrix4f().scaling((float)size, (float)size, (float)(-size)));
        matrices.method_46416(0.0f, -1.0f, 0.0f);
        matrices.method_22907((Quaternionfc)entityRotation);
        matrices.method_46416(0.0f, -1.0f, 0.0f);
        class_308.method_34742();
    }

    private static void renderEntity(class_4587 matrices, float yaw, float pitch, Skin skin, long totalTickDelta) {
        class_5609 modelData = class_591.method_32028((class_5605)class_5605.field_27715, (boolean)skin.getModel().equals("slim"));
        NoEntityPlayerModel model = new NoEntityPlayerModel(class_5607.method_32110((class_5609)modelData, (int)64, (int)64).method_32109(), skin.getModel().equals("slim"));
        model.swingArmsGently(totalTickDelta);
        model.setHeadPos(yaw, pitch);
        model.waveCapeGently(totalTickDelta);
        if (FabricLoader.getInstance().isModLoaded("entity_texture_features")) {
            ETFCompat.preventRenderLayerIssue();
        }
        class_4597.class_4598 vertexConsumers = class_310.method_1551().method_22940().method_23000();
        model.method_62100(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)skin.getTexture())), 0xF000F0, class_4608.field_21444, -1);
        if (skin.getSkinTextures().comp_1627() != null && SkinShuffleConfig.get().showCapeInPreview) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 0.2f);
            matrices.method_22909();
        }
        vertexConsumers.method_22993();
    }

    private static void cleanupMatrices(class_4587 matrices) {
        matrices.method_22909();
        class_308.method_24211();
    }

    private static void cleanupModelViewStack() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.popMatrix();
    }

    public static class NoEntityPlayerModel
    extends class_591 {
        public NoEntityPlayerModel(class_630 root, boolean thinArms) {
            super(root, thinArms);
        }

        public void swingArmsGently(long totalDeltaTick) {
            float f = class_3532.method_15374((float)((float)totalDeltaTick * 0.067f)) * 0.05f;
            this.field_3401.field_3674 = f + 0.06f;
            this.field_3486.field_3674 = f + 0.06f;
            this.field_27433.field_3674 = -f - 0.06f;
            this.field_3484.field_3674 = -f - 0.06f;
        }

        public void setHeadPos(float headYaw, float headPitch) {
            this.field_3398.field_3675 = headYaw;
            this.field_3398.field_3654 = headPitch;
        }

        public void waveCapeGently(long totalDeltaTick) {
            float f = class_3532.method_15374((float)((float)totalDeltaTick * 0.067f)) * 0.05f;
        }
    }
}

